/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.mock.smtp.server.model.Condition;

public interface Operator {
    public static final Operator CONTAINS = new Operator(){

        @Override
        public Expected actual(String actual) {
            return expected -> () -> actual.contains(expected);
        }

        @Override
        public OperatorName getOperatorName() {
            return OperatorName.CONTAINS;
        }
    };

    public Expected actual(String var1);

    public OperatorName getOperatorName();

    @FunctionalInterface
    public static interface Matcher {
        public boolean matches();
    }

    @FunctionalInterface
    public static interface Expected {
        public Matcher expected(String var1);
    }

    public static enum OperatorName {
        CONTAINS("contains", maybeMatchingValue -> {
            Preconditions.checkState((boolean)maybeMatchingValue.isPresent(), (Object)"You need to specify a matchingValue with the contains operator");
            return new Condition.OperatorCondition(CONTAINS, (String)maybeMatchingValue.get());
        }),
        MATCH_ALL("matchAll", maybeMatchingValue -> {
            Preconditions.checkState((!maybeMatchingValue.isPresent() ? 1 : 0) != 0, (Object)"You should not specify a matchingValue with the matchAll operator");
            return new Condition.MatchAllCondition();
        });

        private final String name;
        private final Function<Optional<String>, Condition> conditionFactory;

        @JsonCreator
        public static OperatorName from(String name) {
            return Arrays.stream(OperatorName.values()).filter(value -> value.name.equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsuported " + name + " operator"));
        }

        private OperatorName(String name, Function<Optional<String>, Condition> conditionFactory) {
            this.name = name;
            this.conditionFactory = conditionFactory;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        public Function<Optional<String>, Condition> getConditionFactory() {
            return this.conditionFactory;
        }
    }
}

