/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server;

import org.apache.james.mock.smtp.server.ExtendedEhloCommand;
import org.apache.james.mock.smtp.server.ExtendedMailFromCommand;
import org.apache.james.mock.smtp.server.ExtendedRcptToCommand;
import org.apache.james.mock.smtp.server.MockMessageHandler;
import org.apache.james.mock.smtp.server.ReceivedMailRepository;
import org.apache.james.mock.smtp.server.SMTPBehaviorRepository;
import org.apache.james.util.Port;
import org.subethamail.smtp.internal.server.Command;
import org.subethamail.smtp.server.SMTPServer;

class MockSMTPServer {
    private static final int RANDOM_PORT = 0;
    private final SMTPServer server;

    public static MockSMTPServer onRandomPort(SMTPBehaviorRepository behaviorRepository, ReceivedMailRepository mailRepository) {
        return new MockSMTPServer(behaviorRepository, mailRepository, 0);
    }

    public static MockSMTPServer onPort(SMTPBehaviorRepository behaviorRepository, ReceivedMailRepository mailRepository, Port port) {
        return new MockSMTPServer(behaviorRepository, mailRepository, port.getValue());
    }

    private MockSMTPServer(SMTPBehaviorRepository behaviorRepository, ReceivedMailRepository mailRepository, int port) {
        this.server = SMTPServer.port((int)port).messageHandlerFactory(ctx -> new MockMessageHandler(mailRepository, behaviorRepository)).build();
        this.server.getCommandHandler().addCommand((Command)new ExtendedEhloCommand(behaviorRepository));
        this.server.getCommandHandler().addCommand((Command)new ExtendedMailFromCommand());
        this.server.getCommandHandler().addCommand((Command)new ExtendedRcptToCommand());
    }

    void start() {
        if (!this.server.isRunning()) {
            this.server.start();
        }
    }

    Port getPort() {
        return Port.of((int)this.server.getPortAllocated());
    }

    void stop() {
        this.server.stop();
    }
}

