/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server;

import java.io.IOException;
import java.util.Locale;
import org.apache.james.mock.smtp.server.MockMessageHandler;
import org.apache.james.mock.smtp.server.model.Mail;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.internal.server.BaseCommand;
import org.subethamail.smtp.internal.util.EmailUtils;
import org.subethamail.smtp.server.Session;

public class ExtendedRcptToCommand
extends BaseCommand {
    public ExtendedRcptToCommand() {
        super("RCPT", "Specifies the recipient. Can be used any number of times.", "TO: <recipient> [ <parameters> ]");
    }

    public void execute(String commandString, Session sess) throws IOException, DropConnectionException {
        if (!sess.isMailTransactionInProgress()) {
            sess.sendResponse("503 Error: need MAIL command");
        } else if (sess.getServer().getMaxRecipients() >= 0 && sess.getRecipientCount() >= sess.getServer().getMaxRecipients()) {
            sess.sendResponse("452 Error: too many recipients");
        } else {
            String args = this.getArgPredicate(commandString);
            if (!args.toUpperCase(Locale.ENGLISH).startsWith("TO:")) {
                sess.sendResponse("501 Syntax: RCPT TO: <address>  Error in parameters: \"" + args + "\"");
            } else {
                String recipientAddress = EmailUtils.extractEmailAddress((String)args, (int)3);
                try {
                    MockMessageHandler messageHandler = (MockMessageHandler)sess.getMessageHandler();
                    messageHandler.recipient(recipientAddress, Mail.Parameter.fromArgLine(args));
                    sess.addRecipient(recipientAddress);
                    sess.sendResponse("250 Ok");
                }
                catch (DropConnectionException dropConnectionException) {
                    throw dropConnectionException;
                }
                catch (RejectException rejectException) {
                    sess.sendResponse(rejectException.getErrorResponse());
                }
            }
        }
    }
}

