/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import feign.Feign;
import feign.Logger;
import feign.RequestLine;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.util.List;
import org.apache.james.mock.smtp.server.HTTPConfigurationServer;
import org.apache.james.mock.smtp.server.jackson.MailAddressModule;
import org.apache.james.mock.smtp.server.model.Condition;
import org.apache.james.mock.smtp.server.model.Mail;
import org.apache.james.mock.smtp.server.model.MockSMTPBehavior;
import org.apache.james.mock.smtp.server.model.MockSmtpBehaviors;
import org.apache.james.mock.smtp.server.model.Operator;
import org.apache.james.mock.smtp.server.model.Response;
import org.apache.james.mock.smtp.server.model.SMTPCommand;
import org.apache.james.mock.smtp.server.model.SMTPExtensions;
import org.apache.james.util.Host;

public interface ConfigurationClient {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new GuavaModule()).registerModule((Module)MailAddressModule.MODULE);

    @VisibleForTesting
    public static ConfigurationClient fromServer(HTTPConfigurationServer.RunningStage server) {
        return ConfigurationClient.from(Host.from((String)"localhost", (int)server.getPort().getValue()));
    }

    public static ConfigurationClient from(Host mockServerHttpHost) {
        return (ConfigurationClient)Feign.builder().logger((Logger)new Slf4jLogger(ConfigurationClient.class)).logLevel(Logger.Level.FULL).encoder((Encoder)new JacksonEncoder(OBJECT_MAPPER)).decoder((Decoder)new JacksonDecoder(OBJECT_MAPPER)).retryer((Retryer)new Retryer.Default()).target(ConfigurationClient.class, "http://" + mockServerHttpHost.asString());
    }

    @RequestLine(value="PUT /smtpBehaviors")
    public void setBehaviors(MockSmtpBehaviors var1);

    @RequestLine(value="DELETE /smtpBehaviors")
    public void clearBehaviors();

    @RequestLine(value="GET /smtpBehaviors")
    public List<MockSMTPBehavior> listBehaviors();

    @RequestLine(value="PUT /smtpExtensions")
    public void setSMTPExtensions(SMTPExtensions var1);

    @RequestLine(value="DELETE /smtpExtensions")
    public void clearSMTPExtensions();

    @RequestLine(value="GET /smtpExtensions")
    public SMTPExtensions listSMTPExtensions();

    @RequestLine(value="GET /smtpMails")
    public List<Mail> listMails();

    @RequestLine(value="GET /version")
    public String version();

    @RequestLine(value="DELETE /smtpMails")
    public void clearMails();

    default public void setBehaviors(List<MockSMTPBehavior> behaviors) {
        this.setBehaviors(new MockSmtpBehaviors(behaviors));
    }

    default public void cleanServer() {
        this.clearBehaviors();
        this.clearMails();
        this.clearSMTPExtensions();
    }

    default public BehaviorsParamsBuilder.CommandStep addNewBehavior() {
        return new BehaviorsParamsBuilder(this).addNewBehavior();
    }

    public static class BehaviorsParamsBuilder {
        private final ImmutableList.Builder<MockSMTPBehavior> behaviors = ImmutableList.builder();
        private final ConfigurationClient client;

        public BehaviorsParamsBuilder(ConfigurationClient client) {
            this.client = client;
        }

        public CommandStep addNewBehavior() {
            return new CommandStep(this);
        }

        BehaviorsParamsBuilder add(MockSMTPBehavior behavior) {
            this.behaviors.add((Object)behavior);
            return this;
        }

        public void post() {
            this.client.setBehaviors((List<MockSMTPBehavior>)this.behaviors.build());
        }

        public static class CommandStep {
            private final BehaviorsParamsBuilder backReference;

            CommandStep(BehaviorsParamsBuilder backReference) {
                this.backReference = backReference;
            }

            public ConditionStep expect(SMTPCommand command) {
                Preconditions.checkNotNull((Object)((Object)command), (Object)"'command' should not be null");
                return new ConditionStep(this.backReference, command);
            }
        }

        public static class NumberOfAnswerStep {
            private final BehaviorsParamsBuilder backReference;
            private final SMTPCommand command;
            private final Response response;
            private final Condition condition;

            NumberOfAnswerStep(BehaviorsParamsBuilder backReference, SMTPCommand command, Response response, Condition condition) {
                this.backReference = backReference;
                this.command = command;
                this.response = response;
                this.condition = condition;
            }

            public BehaviorsParamsBuilder anyTimes() {
                return this.backReference.add(this.toBehavior(MockSMTPBehavior.NumberOfAnswersPolicy.anytime()));
            }

            public BehaviorsParamsBuilder onlySomeTimes(int count) {
                return this.backReference.add(this.toBehavior(MockSMTPBehavior.NumberOfAnswersPolicy.times(count)));
            }

            MockSMTPBehavior toBehavior(MockSMTPBehavior.NumberOfAnswersPolicy numberOfAnswersPolicy) {
                return new MockSMTPBehavior(this.command, this.condition, this.response, numberOfAnswersPolicy);
            }
        }

        public static class ResponseStep {
            private final BehaviorsParamsBuilder backReference;
            private final SMTPCommand command;
            private final Condition condition;

            public static Response serviceNotAvailable(String message) {
                return new Response(Response.SMTPStatusCode.SERVICE_NOT_AVAILABLE_421, message);
            }

            public static Response doesNotAcceptAnyMail(String message) {
                return new Response(Response.SMTPStatusCode.DOES_NOT_ACCEPT_MAIL_521, message);
            }

            ResponseStep(BehaviorsParamsBuilder backReference, SMTPCommand command, Condition condition) {
                this.backReference = backReference;
                this.command = command;
                this.condition = condition;
            }

            public NumberOfAnswerStep thenRespond(Response response) {
                return new NumberOfAnswerStep(this.backReference, this.command, response, this.condition);
            }
        }

        public static class ConditionStep {
            private final BehaviorsParamsBuilder backReference;
            private final SMTPCommand command;

            public static Condition anyInput() {
                return Condition.MATCH_ALL;
            }

            public static Condition inputContaining(String value) {
                return new Condition.OperatorCondition(Operator.CONTAINS, value);
            }

            ConditionStep(BehaviorsParamsBuilder backReference, SMTPCommand command) {
                this.backReference = backReference;
                this.command = command;
            }

            public ResponseStep matching(Condition condition) {
                return new ResponseStep(this.backReference, this.command, condition);
            }
        }
    }
}

