/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.util.Optional;

public class MailetMatcherDescriptor {
    private final String name;
    private final String fullyQualifiedClassName;
    private final Type type;
    private final Optional<String> info;
    private final Optional<String> classDocs;
    private final boolean experimental;

    public static Builder.RequiresName builder() {
        return name -> fullyQualifiedClassName -> type -> info -> classDocs -> experimental -> new MailetMatcherDescriptor(name, fullyQualifiedClassName, type, info, classDocs, experimental);
    }

    private MailetMatcherDescriptor(String name, String fullyQualifiedClassName, Type type, Optional<String> info, Optional<String> classDocs, boolean experimental) {
        this.name = name;
        this.fullyQualifiedClassName = fullyQualifiedClassName;
        this.type = type;
        this.info = info;
        this.classDocs = classDocs;
        this.experimental = experimental;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedClassName;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getInfo() {
        return this.info;
    }

    public Optional<String> getClassDocs() {
        return this.classDocs;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public String toString() {
        return MoreObjects.toStringHelper(MailetMatcherDescriptor.class).add("fullyQualifiedClassName", (Object)this.fullyQualifiedClassName).add("name", (Object)this.name).add("info", this.info).add("type", (Object)this.type).add("experimental", this.experimental).toString();
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fullyQualifiedClassName, this.name, this.info, this.classDocs, this.type, this.experimental});
    }

    public final boolean equals(Object obj) {
        if (obj instanceof MailetMatcherDescriptor) {
            MailetMatcherDescriptor other = (MailetMatcherDescriptor)obj;
            return Objects.equal((Object)this.fullyQualifiedClassName, (Object)other.fullyQualifiedClassName) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.classDocs, other.classDocs) && Objects.equal(this.info, other.info) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.experimental, (Object)other.experimental);
        }
        return false;
    }

    public static interface Builder {

        @FunctionalInterface
        public static interface RequiresExperimental {
            default public MailetMatcherDescriptor isExperimental() {
                return this.experimental(true);
            }

            default public MailetMatcherDescriptor isNotExperimental() {
                return this.experimental(false);
            }

            public MailetMatcherDescriptor experimental(boolean var1);
        }

        @FunctionalInterface
        public static interface RequiresClassDocs {
            default public RequiresExperimental classDocs(String classDocs) {
                if (Strings.isNullOrEmpty((String)classDocs)) {
                    return this.noClassDocs();
                }
                return this.classDocs(Optional.of(classDocs));
            }

            default public RequiresExperimental noClassDocs() {
                return this.classDocs(Optional.empty());
            }

            public RequiresExperimental classDocs(Optional<String> var1);
        }

        @FunctionalInterface
        public static interface RequiresInfo {
            default public RequiresClassDocs info(String info) {
                if (Strings.isNullOrEmpty((String)info)) {
                    return this.noInfo();
                }
                return this.info(Optional.of(info));
            }

            default public RequiresClassDocs noInfo() {
                return this.info(Optional.empty());
            }

            public RequiresClassDocs info(Optional<String> var1);
        }

        @FunctionalInterface
        public static interface RequiresType {
            public RequiresInfo type(Type var1);
        }

        @FunctionalInterface
        public static interface RequiresFullyQualifiedClassName {
            public RequiresType fullyQualifiedClassName(String var1);
        }

        @FunctionalInterface
        public static interface RequiresName {
            public RequiresFullyQualifiedClassName name(String var1);
        }
    }

    public static enum Type {
        MAILET("mailet"),
        MATCHER("matcher");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

