/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.james.mailet.MailetMatcherDescriptor;
import org.apache.mailet.ExcludeFromDocumentation;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mailet;
import org.apache.mailet.Matcher;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class DefaultDescriptorsExtractor {
    private static final String MATCHER_CLASS_NAME = Matcher.class.getName();
    private static final String MAILET_CLASS_NAME = Mailet.class.getName();
    private final List<MailetMatcherDescriptor> descriptors = new ArrayList<MailetMatcherDescriptor>();

    public List<MailetMatcherDescriptor> descriptors() {
        return this.descriptors;
    }

    public DefaultDescriptorsExtractor extract(MavenProject project, Log log) {
        Collection<JavaClass> classes = this.javaClasses(project);
        URLClassLoader classLoader = this.classLoader(project, log);
        this.logProjectDependencies(project, log);
        this.logDirectories(project, log);
        try {
            Class<?> mailetClass = classLoader.loadClass(MAILET_CLASS_NAME);
            Class<?> matcherClass = classLoader.loadClass(MATCHER_CLASS_NAME);
            for (JavaClass nextClass : classes) {
                this.addDescriptor(log, classLoader, mailetClass, matcherClass, nextClass);
            }
        }
        catch (ClassNotFoundException e) {
            log.debug((Throwable)e);
            log.info((CharSequence)("No mailets in " + project.getName()));
        }
        return this;
    }

    private void addDescriptor(Log log, URLClassLoader classLoader, Class<?> mailetClass, Class<?> matcherClass, JavaClass nextClass) {
        String nameOfNextClass = nextClass.getFullyQualifiedName();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Class: " + nameOfNextClass));
        }
        if (this.isExcludedFromDocumentation(nextClass)) {
            log.debug((CharSequence)(nameOfNextClass + " is excluded from documentation"));
            return;
        }
        try {
            Class<?> klass = classLoader.loadClass(nameOfNextClass);
            this.logConstructor(log, klass);
            List<Class<?>> allInterfaces = this.getAllInterfaces(klass);
            if (allInterfaces.contains(mailetClass)) {
                MailetMatcherDescriptor descriptor = this.describeMailet(log, nextClass, nameOfNextClass, klass);
                this.descriptors.add(descriptor);
            } else if (allInterfaces.contains(matcherClass)) {
                MailetMatcherDescriptor descriptor = this.describeMatcher(log, nextClass, nameOfNextClass, klass);
                this.descriptors.add(descriptor);
            } else {
                this.logInterfaces(log, klass, allInterfaces);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            log.error((CharSequence)"NotFound", e);
        }
        catch (SecurityException e) {
            log.error((CharSequence)"Security exception", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((CharSequence)"IllegalArgumentException", (Throwable)e);
        }
        this.logInterfacesImplemented(log, nextClass);
    }

    private void logInterfaces(Log log, Class<?> klass, List<Class<?>> allInterfaces) {
        if (log.isDebugEnabled()) {
            if (allInterfaces.size() > 0) {
                log.debug((CharSequence)("Interfaces for " + klass.getName()));
                for (Class<?> allInterface : allInterfaces) {
                    log.debug((CharSequence)("Interface: " + allInterface.getName()));
                }
            } else {
                log.debug((CharSequence)("No interfaces for " + klass.getName()));
            }
        }
    }

    private MailetMatcherDescriptor describeMatcher(Log log, JavaClass nextClass, String nameOfNextClass, Class<?> klass) {
        MailetMatcherDescriptor result = MailetMatcherDescriptor.builder().name(nextClass.getName()).fullyQualifiedClassName(nameOfNextClass).type(MailetMatcherDescriptor.Type.MATCHER).info(this.fetchInfo(log, nameOfNextClass, klass, "getMatcherInfo", MailetMatcherDescriptor.Type.MATCHER)).classDocs(nextClass.getComment()).experimental(this.isExperimental(nextClass));
        log.info((CharSequence)("Found a Matcher: " + klass.getName()));
        return result;
    }

    private Optional<String> fetchInfo(Log log, String nameOfClass, Class<?> klass, String infoMethodName, MailetMatcherDescriptor.Type type) {
        try {
            Object instance = this.instantiateClass(klass);
            String info = (String)klass.getMethod(infoMethodName, new Class[0]).invoke(instance, new Object[0]);
            if (info != null && info.length() > 0) {
                return Optional.of(info);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.handleInfoLoadFailure(log, nameOfClass, type, e);
        }
        return Optional.empty();
    }

    private Object instantiateClass(Class<?> klass) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        Constructor<?>[] constructors = klass.getConstructors();
        if (constructors.length > 0) {
            Constructor<?> constructor = constructors[0];
            Object[] studentObjects = new Object[constructor.getParameterCount()];
            return constructor.newInstance(studentObjects);
        }
        return klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private boolean isExperimental(JavaClass javaClass) {
        return javaClass.getAnnotations().stream().anyMatch(annotation -> annotation.getType().getCanonicalName().equals(Experimental.class.getName()));
    }

    private boolean isExcludedFromDocumentation(JavaClass javaClass) {
        return javaClass.getAnnotations().stream().anyMatch(annotation -> annotation.getType().getCanonicalName().equals(ExcludeFromDocumentation.class.getName()));
    }

    private void handleInfoLoadFailure(Log log, String nameOfClass, MailetMatcherDescriptor.Type type, Exception e) {
        log.info((CharSequence)("Cannot load " + String.valueOf((Object)type) + " info for " + nameOfClass), (Throwable)e);
        log.debug((Throwable)e);
    }

    private MailetMatcherDescriptor describeMailet(Log log, JavaClass nextClass, String nameOfNextClass, Class<?> klass) {
        MailetMatcherDescriptor result = MailetMatcherDescriptor.builder().name(nextClass.getName()).fullyQualifiedClassName(nameOfNextClass).type(MailetMatcherDescriptor.Type.MAILET).info(this.fetchInfo(log, nameOfNextClass, klass, "getMailetInfo", MailetMatcherDescriptor.Type.MAILET)).classDocs(nextClass.getComment()).experimental(this.isExperimental(nextClass));
        log.info((CharSequence)("Found a Mailet: " + klass.getName()));
        return result;
    }

    private void logInterfacesImplemented(Log log, JavaClass nextClass) {
        if (log.isDebugEnabled()) {
            List<JavaClass> implementedInterfaces = this.getAllInterfacesQdox(nextClass);
            for (JavaClass implemented : implementedInterfaces) {
                log.debug((CharSequence)("Interface implemented: " + String.valueOf(implemented)));
            }
        }
    }

    private void logConstructor(Log log, Class<?> klass) {
        if (log.isDebugEnabled()) {
            try {
                log.debug((CharSequence)("Constructor(empty): " + String.valueOf(klass.getConstructor(new Class[]{null}))));
            }
            catch (NoSuchMethodException | SecurityException e) {
                log.debug((CharSequence)"Cannot introspect empty constructor", (Throwable)e);
            }
        }
    }

    private URLClassLoader classLoader(MavenProject project, Log log) {
        URLClassLoader classLoader = null;
        try {
            List cpes = project.getCompileClasspathElements();
            int size = cpes.size();
            URL[] urls = new URL[size];
            for (int k = 0; k < size; ++k) {
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("CPE: " + (String)cpes.get(k)));
                }
                urls[k] = new File((String)cpes.get(k)).toURI().toURL();
            }
            classLoader = new URLClassLoader(urls);
        }
        catch (DependencyResolutionRequiredException e) {
            log.error((CharSequence)"Failed to load project dependencies.", (Throwable)e);
        }
        catch (MalformedURLException e) {
            log.error((CharSequence)"Cannot build classloader from project URLs.", (Throwable)e);
        }
        return classLoader;
    }

    private Collection<JavaClass> javaClasses(MavenProject project) {
        JavaProjectBuilder builder = new JavaProjectBuilder();
        for (String s : project.getCompileSourceRoots()) {
            builder.addSourceTree(new File(s));
        }
        return builder.getClasses();
    }

    private void logDirectories(MavenProject project, Log log) {
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("OutDir: " + project.getBuild().getOutputDirectory()));
        }
    }

    private void logProjectDependencies(MavenProject project, Log log) {
        log.debug((CharSequence)"Logging project dependencies");
        if (log.isDebugEnabled()) {
            Set dependencies = project.getDependencyArtifacts();
            if (dependencies == null) {
                log.debug((CharSequence)"No project dependencies");
            } else {
                for (Artifact artifact : dependencies) {
                    log.debug((CharSequence)("DEP: " + String.valueOf(artifact)));
                }
            }
        }
    }

    private List<JavaClass> getAllInterfacesQdox(JavaClass javaClass) {
        LinkedList<JavaClass> res = new LinkedList<JavaClass>();
        if (javaClass.getInterfaces() != null) {
            res.addAll(javaClass.getInterfaces());
        }
        if (javaClass.getSuperJavaClass() != null) {
            res.addAll(this.getAllInterfacesQdox(javaClass.getSuperJavaClass()));
        }
        return res;
    }

    private List<Class<?>> getAllInterfaces(Class<?> klass) {
        LinkedList res = new LinkedList();
        if (klass.getInterfaces() != null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = klass.getInterfaces()) {
                res.add(anInterface);
                res.addAll(this.getAllInterfaces(anInterface));
            }
        }
        if (klass.getSuperclass() != null) {
            res.addAll(this.getAllInterfaces(klass.getSuperclass()));
        }
        return res;
    }
}

