/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet;

import java.util.List;
import org.apache.james.mailet.AbstractMailetdocsReport;
import org.apache.james.mailet.DefaultDescriptorsExtractor;
import org.apache.james.mailet.MailetMatcherDescriptor;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="aggregate", requiresDependencyResolution=ResolutionScope.COMPILE, aggregator=true)
public class AggregateMailetdocsReport
extends AbstractMailetdocsReport {
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;

    @Override
    protected final List<MailetMatcherDescriptor> buildDescriptors(MavenProject project) {
        DefaultDescriptorsExtractor extractor = new DefaultDescriptorsExtractor();
        if (project.isExecutionRoot()) {
            this.logProject(project);
            for (MavenProject subproject : this.reactorProjects) {
                this.logSubproject(subproject);
                extractor.extract(subproject, this.getLog());
            }
        } else {
            this.logNoSubprojects(project);
            extractor.extract(project, this.getLog());
        }
        return extractor.descriptors();
    }

    private void logProject(MavenProject project) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Aggregating mailets within " + project.getName()));
        }
    }

    private void logSubproject(MavenProject subproject) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Adding descriptors in " + subproject.getName()));
        }
    }

    private void logNoSubprojects(MavenProject project) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("No subprojects for " + project.getName()));
        }
    }
}

