/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.james.mailet.MailetMatcherDescriptor;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

public abstract class AbstractMailetdocsReport
extends AbstractMavenReport {
    private static final String EXPERIMENTAL = " (Experimental)";
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component
    private Renderer siteRenderer;

    protected void executeReport(Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)"Executing Mailets/Matchers Report");
        this.getSink().head();
        this.getSink().title();
        this.getSink().text("Mailet and Matchers Reference");
        this.getSink().title_();
        this.getSink().head_();
        this.getSink().body();
        this.getSink().section1();
        this.getSink().sectionTitle1();
        this.getSink().text("Mailets and Matchers Reference");
        this.getSink().sectionTitle1_();
        this.getSink().text("Items marked as Experimental are not yet supported by James; however, you can try them.");
        this.getSink().section1_();
        this.writeDescriptions();
        this.getSink().body_();
        this.getSink().flush();
        this.getSink().close();
    }

    private void writeDescriptions() {
        boolean mailetsExist;
        List<MailetMatcherDescriptor> descriptors = this.buildSortedDescriptors();
        List matchers = (List)descriptors.stream().filter(descriptor -> descriptor.getType() == MailetMatcherDescriptor.Type.MATCHER).collect(ImmutableList.toImmutableList());
        List mailets = (List)descriptors.stream().filter(descriptor -> descriptor.getType() == MailetMatcherDescriptor.Type.MAILET).collect(ImmutableList.toImmutableList());
        boolean matchersExist = matchers.size() > 0;
        boolean bl = mailetsExist = mailets.size() > 0;
        if (matchersExist && mailetsExist) {
            this.getSink().table();
            this.getSink().tableRow();
            this.getSink().tableCell();
        }
        if (matchersExist) {
            this.outputDescriptorIndex(matchers, "Matchers");
        }
        if (matchersExist && mailetsExist) {
            this.getSink().tableCell_();
            this.getSink().tableCell();
        }
        if (mailetsExist) {
            this.outputDescriptorIndex(mailets, "Mailets");
        }
        if (matchersExist && mailetsExist) {
            this.getSink().tableCell_();
            this.getSink().tableRow_();
            this.getSink().table_();
        }
        if (matchersExist) {
            this.outputDescriptorList(matchers, "Matchers");
        }
        if (mailetsExist) {
            this.outputDescriptorList(mailets, "Mailets");
        }
    }

    private List<MailetMatcherDescriptor> buildSortedDescriptors() {
        List<MailetMatcherDescriptor> descriptors = this.buildDescriptors(this.project);
        descriptors.sort(Comparator.comparing(MailetMatcherDescriptor::getName));
        this.logDescriptors(descriptors);
        return descriptors;
    }

    private void logDescriptors(List<MailetMatcherDescriptor> descriptors) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Built descriptors: " + String.valueOf(descriptors)));
        }
    }

    protected abstract List<MailetMatcherDescriptor> buildDescriptors(MavenProject var1);

    private void outputDescriptorIndex(List<MailetMatcherDescriptor> descriptors, String title) {
        this.getSink().section2();
        this.getSink().sectionTitle2();
        this.getSink().text(title);
        this.getSink().sectionTitle2_();
        this.getSink().list();
        for (MailetMatcherDescriptor descriptor : descriptors) {
            this.getSink().listItem();
            this.getSink().link("#" + descriptor.getName());
            this.getSink().text(descriptor.getName());
            if (descriptor.isExperimental()) {
                this.getSink().text(EXPERIMENTAL);
            }
            this.getSink().link_();
            this.getSink().listItem_();
        }
        this.getSink().list_();
        this.getSink().section2_();
    }

    private void outputDescriptorList(List<MailetMatcherDescriptor> descriptors, String title) {
        this.getSink().section1();
        this.getSink().sectionTitle1();
        this.getSink().text(title);
        this.getSink().sectionTitle1_();
        for (MailetMatcherDescriptor descriptor : descriptors) {
            this.getSink().section2();
            this.getSink().sectionTitle2();
            this.getSink().anchor(descriptor.getName());
            this.getSink().text(descriptor.getName());
            if (descriptor.isExperimental()) {
                this.getSink().text(EXPERIMENTAL);
            }
            this.getSink().anchor_();
            this.getSink().sectionTitle2_();
            descriptor.getInfo().ifPresent(info -> {
                this.getSink().paragraph();
                if (descriptor.getType() == MailetMatcherDescriptor.Type.MAILET) {
                    this.getSink().text("Mailet Info: ");
                } else if (descriptor.getType() == MailetMatcherDescriptor.Type.MATCHER) {
                    this.getSink().text("Matcher Info: ");
                } else {
                    this.getSink().text("Info: ");
                }
                this.getSink().bold();
                this.getSink().text(descriptor.getInfo().orElse(""));
                this.getSink().bold_();
                this.getSink().lineBreak();
                this.getSink().paragraph_();
            });
            this.getSink().paragraph();
            descriptor.getClassDocs().ifPresent(classDocs -> this.getSink().rawText(classDocs));
            this.getSink().paragraph_();
            this.getSink().section2_();
        }
        this.getSink().section1_();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale arg0) {
        return "Documentation about bundled mailets";
    }

    public String getName(Locale arg0) {
        return "Mailet Reference";
    }

    public String getOutputName() {
        return "mailet-report";
    }

    public void setSiteRenderer(Renderer siteRenderer) {
        this.siteRenderer = siteRenderer;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

