/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import com.google.crypto.tink.apps.webpush.WebPushHybridDecrypt;
import com.google.crypto.tink.subtle.EllipticCurves;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.javacrumbs.jsonunit.assertj.JsonAssert;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.PushSubscriptionProbe;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.SpoolerProbe;
import org.apache.james.utils.UpdatableTickingClock;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.mockserver.verify.VerificationTimes;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.Json$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dfa\u0002\u000b\u0016!\u0003\r\tA\t\u0005\u0006S\u0001!\tA\u000b\u0005\t]\u0001A)\u0019!C\u0005_!A\u0001\b\u0001EC\u0002\u0013%\u0011\bC\u0003F\u0001\u0011\u0005a\tC\u0003Y\u0001\u0011%\u0011\fC\u0003e\u0001\u0011%Q\rC\u0003h\u0001\u0011%\u0001\u000eC\u0003n\u0001\u0011%a\u000eC\u0003q\u0001\u0011%\u0011\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA5\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017\u0013qbV3c!V\u001c\bnQ8oiJ\f7\r\u001e\u0006\u0003-]\t\u0001bY8oiJ\f7\r\u001e\u0006\u00031e\tqA\u001d4dqY\u0012\u0014G\u0003\u0002\u001b7\u0005!!.\\1q\u0015\taR$A\u0003kC6,7O\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001,!\t!C&\u0003\u0002.K\t!QK\\5u\u0003U\tw/Y5u\u0003Rlun\u001d;UK:\u001cVmY8oIN,\u0012\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003gQ\nAaY8sK*\u0011QgH\u0001\u000bC^\f\u0017\u000e^5mSRL\u0018BA\u001c3\u0005A\u0019uN\u001c3ji&|gNR1di>\u0014\u00180A\u0007Q+NCu,\u0016*M?B\u000bE\u000bS\u000b\u0002uA\u00111H\u0011\b\u0003y\u0001\u0003\"!P\u0013\u000e\u0003yR!aP\u0011\u0002\rq\u0012xn\u001c;?\u0013\t\tU%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!&\u0003\u0015\u0019X\r^+q)\tYs\tC\u0003I\t\u0001\u0007\u0011*\u0001\u0004tKJ4XM\u001d\t\u0003\u0015.k\u0011aG\u0005\u0003\u0019n\u0011\u0001cR;jG\u0016T\u0015-\\3t'\u0016\u0014h/\u001a:)\u0005\u0011q\u0005CA(W\u001b\u0005\u0001&BA)S\u0003\r\t\u0007/\u001b\u0006\u0003'R\u000bqA[;qSR,'O\u0003\u0002V?\u0005)!.\u001e8ji&\u0011q\u000b\u0015\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001E4fiB+8\u000f[*feZ,'/\u0016:m)\tQ$\fC\u0003\\\u000b\u0001\u0007A,\u0001\u0006qkND7+\u001a:wKJ\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0017%tG/Z4sCRLwN\u001c\u0006\u0003C~\t!\"\\8dWN,'O^3s\u0013\t\u0019gLA\bDY&,g\u000e^!oIN+'O^3s\u0003Y\u0019'/Z1uKB+8\u000f[*vEN\u001c'/\u001b9uS>tGC\u0001\u001eg\u0011\u0015Yf\u00011\u0001]\u0003y)\b\u000fZ1uKZ\u000bG.\u001b3bi\u00164VM]5gS\u000e\fG/[8o\u0007>$W\rF\u0002;S.DQA[\u0004A\u0002i\n!\u0003];tQN+(m]2sSB$\u0018n\u001c8JI\")An\u0002a\u0001u\u0005\u0001b/\u001a:jM&\u001c\u0017\r^5p]\u000e{G-Z\u0001\u000fg\u0016tG-R7bS2$vNQ8c)\tYs\u000eC\u0003I\u0011\u0001\u0007\u0011*A\ftKR,\b\u000fU;tQN+'O^3s\u0007\u0006dGNY1dWR\u0011!O \t\u0004grTT\"\u0001;\u000b\u0005U4\u0018AB1u_6L7M\u0003\u0002xq\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005eT\u0018\u0001B;uS2T\u0011a_\u0001\u0005U\u00064\u0018-\u0003\u0002~i\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rC\u0003\\\u0013\u0001\u0007A,A\u000fd_J\u0014Xm\u0019;CK\"\fg/[8veNCw.\u001e7e'V\u001c7-Z:t)\u0015Y\u00131AA\u0003\u0011\u0015A%\u00021\u0001J\u0011\u0015Y&\u00021\u0001]Q\rQ\u0011\u0011\u0002\t\u0004\u001f\u0006-\u0011bAA\u0007!\n!A+Z:uQ\u001dQ\u0011\u0011CA\f\u00033\u00012aTA\n\u0013\r\t)\u0002\u0015\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017EAA\u000e\u00031\u0011\u0015m]5d\r\u0016\fG/\u001e:f\u0003I\u001a\bn\\;mIB+8\u000f[#nC&dG)\u001a7jm\u0016\u0014\u0018p\u00115b]\u001e,w\u000b[3o+N,'OU3dK&4Xm]#nC&dG#B\u0016\u0002\"\u0005\r\u0002\"\u0002%\f\u0001\u0004I\u0005\"B.\f\u0001\u0004a\u0006fA\u0006\u0002\n\u0005I4\u000f[8vY\u0012tu\u000e\u001e)vg\",U.Y5m\t\u0016d\u0017N^3ss\u000eC\u0017M\\4f/\",g.V:fe\u000e\u0013X-\u0019;fg\u0012\u0013\u0018M\u001a;F[\u0006LG\u000eF\u0003,\u0003W\ti\u0003C\u0003I\u0019\u0001\u0007\u0011\nC\u0003\\\u0019\u0001\u0007A\fK\u0002\r\u0003\u0013\t!g\u001d5pk2$gj\u001c;QkNDW)\\1jY\u0012+G.\u001b<fef\u001c\u0005.\u00198hK^CWM\\+tKJ\u001cVM\u001c3t\u000b6\f\u0017\u000e\u001c\u000b\u0006W\u0005U\u0012q\u0007\u0005\u0006\u00116\u0001\r!\u0013\u0005\u000676\u0001\r\u0001\u0018\u0015\u0004\u001b\u0005%\u0011aN<fEB+8\u000f[*i_VdGMT8u!V\u001c\b\u000eV8QkND7+\u001a:wKJ<\u0006.\u001a8FqBL'/\u001a3Tk\n\u001c8M]5qi&|g\u000eF\u0004,\u0003\u007f\t\t%a\u0011\t\u000b!s\u0001\u0019A%\t\u000bms\u0001\u0019\u0001/\t\u000f\u0005\u0015c\u00021\u0001\u0002H\u0005)1\r\\8dWB!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002Nm\tQ!\u001e;jYNLA!!\u0015\u0002L\t)R\u000b\u001d3bi\u0006\u0014G.\u001a+jG.LgnZ\"m_\u000e\\\u0007f\u0001\b\u0002\n\u00059t/\u001a2QkND7\u000b[8vY\u0012tu\u000e\u001e)vg\"$v\u000eU;tQN+'O^3s/\",g\u000eR3mKR,GmU;cg\u000e\u0014\u0018\u000e\u001d;j_:$RaKA-\u00037BQ\u0001S\bA\u0002%CQaW\bA\u0002qC3aDA\u0005\u0003Q:XM\u0019)vg\"\u001c\u0006n\\;mI:{G\u000fU;tQR{\u0007+^:i'\u0016\u0014h/\u001a:XQ\u0016tgj\u001c;WC2LG-\u0019;fI\u000e{G-\u001a\u000b\u0006W\u0005\r\u0014Q\r\u0005\u0006\u0011B\u0001\r!\u0013\u0005\u00067B\u0001\r\u0001\u0018\u0015\u0004!\u0005%\u0011aL2peJ,7\r\u001e\"fQ\u00064\u0018n\\;s'\"|W\u000f\u001c3Tk\u000e\u001cWm]:XQ\u0016tWI\\2ssB$\u0018n\u001c8LKf\u001cH#B\u0016\u0002n\u0005=\u0004\"\u0002%\u0012\u0001\u0004I\u0005\"B.\u0012\u0001\u0004a\u0006fA\t\u0002\n\u0005\u0019\u0002O]3qCJ,GI]1gi6+7o]1hKR!\u0011qOAD!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nQ!\\8eK2T1!!!\u001c\u0003\u001di\u0017-\u001b7c_bLA!!\"\u0002|\tIQ*Z:tC\u001e,\u0017\n\u001a\u0005\u0006\u0011J\u0001\r!S\u0001\u001cg\u0016$X\u000f\u001d)vg\"\u001cVOY:de&\u0004H/[8o\r>\u0014(i\u001c2\u0015\t\u00055\u0015Q\u0015\t\u0005\u0003\u001f\u000b\t+\u0004\u0002\u0002\u0012*!\u00111SAK\u0003\u001d\t7o]3si*TA!a&\u0002\u001a\u0006A!n]8ok:LGO\u0003\u0003\u0002\u001c\u0006u\u0015A\u00036bm\u0006\u001c'/^7cg*\u0011\u0011qT\u0001\u0004]\u0016$\u0018\u0002BAR\u0003#\u0013!BS:p]\u0006\u001b8/\u001a:u\u0011\u0015Y6\u00031\u0001]\u0001")
public interface WebPushContract {
    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds$(WebPushContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds() {
        return Awaitility.with().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).and().with().pollDelay(Durations.ONE_HUNDRED_MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ String org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH$(WebPushContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH();
    }

    default public String org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH() {
        return "/push2";
    }

    public static /* synthetic */ void setUp$(WebPushContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
    }

    private String getPushServerUrl(ClientAndServer pushServer) {
        return "http://127.0.0.1:" + pushServer.getLocalPort() + this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH();
    }

    private String createPushSubscription(ClientAndServer pushServer) {
        return (String)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"a889-ffea-910\",\n           |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n           |                  \"types\": [\"Mailbox\"]\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }"))).when().post()).then().statusCode(200).extract().jsonPath().get("methodResponses[0][1].created.4f29.id");
    }

    private String updateValidateVerificationCode(String pushSubscriptionId, String verificationCode) {
        return ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"update\": {\n           |                \"" + pushSubscriptionId + "\": {\n           |                  \"verificationCode\": \"" + verificationCode + "\"\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
    }

    private void sendEmailToBob(GuiceJamesServer server) {
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender(Fixture$.MODULE$.DOMAIN().asString());
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).authenticate(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD()).sendMessage(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.BOB().asString());
        smtpMessageSender.close();
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().until(() -> Predef$.MODULE$.boolean2Boolean(((SpoolerProbe)server.getProbe(SpoolerProbe.class)).processingFinished()));
    }

    private AtomicReference<String> setupPushServerCallback(ClientAndServer pushServer) {
        AtomicReference<String> bodyRequestOnPushServer = new AtomicReference<String>("");
        pushServer.when((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withMethod("POST")).respond(new ExpectationResponseCallback(null, bodyRequestOnPushServer){
            private final AtomicReference bodyRequestOnPushServer$1;

            public HttpResponse handle(HttpRequest httpRequest) {
                this.bodyRequestOnPushServer$1.set(httpRequest.getBodyAsString());
                return HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(201));
            }
            {
                this.bodyRequestOnPushServer$1 = bodyRequestOnPushServer$1;
            }
        });
        return bodyRequestOnPushServer;
    }

    public static /* synthetic */ void correctBehaviourShouldSuccess$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.correctBehaviourShouldSuccess(server, pushServer);
    }

    @Test
    @Tag(value="BasicFeature")
    default public void correctBehaviourShouldSuccess(GuiceJamesServer server, ClientAndServer pushServer) {
        AtomicReference<String> bodyRequestOnPushServer = this.setupPushServerCallback(pushServer);
        String pushSubscriptionId = this.createPushSubscription(pushServer);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"" + pushSubscriptionId + "\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}")));
            Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).hasSizeGreaterThanOrEqualTo(1).anySatisfy(bodyAssert);
        });
        String verificationCode = ((JsString)((JsObject)Json$.MODULE$.parse(bodyRequestOnPushServer.get())).value().apply((Object)"verificationCode")).value();
        String updateVerificationCodeResponse = this.updateValidateVerificationCode(pushSubscriptionId, verificationCode);
        JsonAssertions.assertThatJson((Object)updateVerificationCodeResponse).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscriptionId + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        this.sendEmailToBob(server);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"StateChange\",\n             |    \"changed\": {\n             |        \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\": {\n             |          \"Mailbox\": \"${json-unit.any-string}\"\n             |        }\n             |    }\n             |}")));
            Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).hasSizeGreaterThanOrEqualTo(1).anySatisfy(bodyAssert);
        });
    }

    public static /* synthetic */ void shouldPushEmailDeliveryChangeWhenUserReceivesEmail$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.shouldPushEmailDeliveryChangeWhenUserReceivesEmail(server, pushServer);
    }

    @Test
    default public void shouldPushEmailDeliveryChangeWhenUserReceivesEmail(GuiceJamesServer server, ClientAndServer pushServer) {
        this.setupPushSubscriptionForBob(pushServer);
        this.sendEmailToBob(server);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"StateChange\",\n             |    \"changed\": {\n             |        \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\": {\n             |          \"EmailDelivery\": \"${json-unit.any-string}\"\n             |        }\n             |    }\n             |}")));
            Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).hasSizeGreaterThanOrEqualTo(1).anySatisfy(bodyAssert);
        });
    }

    public static /* synthetic */ void shouldNotPushEmailDeliveryChangeWhenUserCreatesDraftEmail$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.shouldNotPushEmailDeliveryChangeWhenUserCreatesDraftEmail(server, pushServer);
    }

    @Test
    default public void shouldNotPushEmailDeliveryChangeWhenUserCreatesDraftEmail(GuiceJamesServer server, ClientAndServer pushServer) {
        this.setupPushSubscriptionForBob(pushServer);
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).getMailboxId("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |    [\"Email/set\", {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"create\": {\n         |        \"aaaaaa\":{\n         |          \"mailboxIds\": {\n         |             \"" + mailboxId.serialize() + "\": true\n         |          },\n         |          \"to\": [{\"email\": \"rcpt1@apache.org\"}, {\"email\": \"rcpt2@apache.org\"}],\n         |          \"from\": [{\"email\": \"" + Fixture$.MODULE$.BOB().asString() + "\"}]\n         |        }\n         |      }\n         |    }, \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isNotEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"StateChange\",\n             |    \"changed\": {\n             |        \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\": {\n             |          \"EmailDelivery\": \"${json-unit.any-string}\"\n             |        }\n             |    }\n             |}")));
            Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).allSatisfy(bodyAssert);
        });
    }

    public static /* synthetic */ void shouldNotPushEmailDeliveryChangeWhenUserSendsEmail$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.shouldNotPushEmailDeliveryChangeWhenUserSendsEmail(server, pushServer);
    }

    @Test
    default public void shouldNotPushEmailDeliveryChangeWhenUserSendsEmail(GuiceJamesServer server, ClientAndServer pushServer) {
        MessageId messageId = this.prepareDraftMessage(server);
        this.setupPushSubscriptionForBob(pushServer);
        String requestBob = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [\n         |     [\"EmailSubmission/set\", {\n         |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |       \"create\": {\n         |         \"k1490\": {\n         |           \"emailId\": \"" + messageId.serialize() + "\",\n         |           \"envelope\": {\n         |             \"mailFrom\": {\"email\": \"" + Fixture$.MODULE$.BOB().asString() + "\"},\n         |             \"rcptTo\": [{\"email\": \"" + Fixture$.MODULE$.ANDRE().asString() + "\"}]\n         |           }\n         |         }\n         |    }\n         |  }, \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(requestBob).when().post()).then().statusCode(200);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isNotEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"StateChange\",\n             |    \"changed\": {\n             |        \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\": {\n             |          \"EmailDelivery\": \"${json-unit.any-string}\"\n             |        }\n             |    }\n             |}")));
            Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).allSatisfy(bodyAssert);
        });
    }

    public static /* synthetic */ void webPushShouldNotPushToPushServerWhenExpiredSubscription$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer, UpdatableTickingClock clock) {
        $this.webPushShouldNotPushToPushServerWhenExpiredSubscription(server, pushServer, clock);
    }

    @Test
    default public void webPushShouldNotPushToPushServerWhenExpiredSubscription(GuiceJamesServer server, ClientAndServer pushServer, UpdatableTickingClock clock) {
        AtomicReference<String> bodyRequestOnPushServer = this.setupPushServerCallback(pushServer);
        String pushSubscriptionId = this.createPushSubscription(pushServer);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"" + pushSubscriptionId + "\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}")));
            Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).anySatisfy(bodyAssert);
        });
        String verificationCode = ((JsString)((JsObject)Json$.MODULE$.parse(bodyRequestOnPushServer.get())).value().apply((Object)"verificationCode")).value();
        String updateVerificationCodeResponse = this.updateValidateVerificationCode(pushSubscriptionId, verificationCode);
        JsonAssertions.assertThatJson((Object)updateVerificationCodeResponse).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscriptionId + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        clock.setInstant(clock.instant().plus(8L, ChronoUnit.DAYS));
        this.sendEmailToBob(server);
        TimeUnit.MILLISECONDS.sleep(200L);
        Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isNotEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"@type\": \"StateChange\",\n           |    \"changed\": {\n           |        \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\": {\n           |          \"Mailbox\": \"${json-unit.any-string}\"\n           |        }\n           |    }\n           |}")));
        Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).allSatisfy(bodyAssert);
    }

    public static /* synthetic */ void webPushShouldNotPushToPushServerWhenDeletedSubscription$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.webPushShouldNotPushToPushServerWhenDeletedSubscription(server, pushServer);
    }

    @Test
    default public void webPushShouldNotPushToPushServerWhenDeletedSubscription(GuiceJamesServer server, ClientAndServer pushServer) {
        AtomicReference<String> bodyRequestOnPushServer = this.setupPushServerCallback(pushServer);
        String pushSubscriptionId = this.createPushSubscription(pushServer);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"" + pushSubscriptionId + "\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}")));
            Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).anySatisfy(bodyAssert);
        });
        String verificationCode = ((JsString)((JsObject)Json$.MODULE$.parse(bodyRequestOnPushServer.get())).value().apply((Object)"verificationCode")).value();
        String updateVerificationCodeResponse = this.updateValidateVerificationCode(pushSubscriptionId, verificationCode);
        JsonAssertions.assertThatJson((Object)updateVerificationCodeResponse).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscriptionId + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        PushSubscriptionProbe pushSubscriptionProbe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"destroy\": [\"" + pushSubscriptionId + "\"]\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }"))).when().post()).then().statusCode(200);
        this.sendEmailToBob(server);
        TimeUnit.MILLISECONDS.sleep(200L);
        Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isNotEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"@type\": \"StateChange\",\n           |    \"changed\": {\n           |        \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\": {\n           |          \"Mailbox\": \"${json-unit.any-string}\"\n           |        }\n           |    }\n           |}")));
        Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).allSatisfy(bodyAssert);
    }

    public static /* synthetic */ void webPushShouldNotPushToPushServerWhenNotValidatedCode$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.webPushShouldNotPushToPushServerWhenNotValidatedCode(server, pushServer);
    }

    @Test
    default public void webPushShouldNotPushToPushServerWhenNotValidatedCode(GuiceJamesServer server, ClientAndServer pushServer) {
        this.setupPushServerCallback(pushServer);
        this.createPushSubscription(pushServer);
        this.sendEmailToBob(server);
        TimeUnit.MILLISECONDS.sleep(200L);
        Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isNotEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"@type\": \"StateChange\",\n           |    \"changed\": {\n           |        \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\": {\n           |          \"Mailbox\": \"${json-unit.any-string}\"\n           |        }\n           |    }\n           |}")));
        Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).allSatisfy(bodyAssert);
    }

    public static /* synthetic */ void correctBehaviourShouldSuccessWhenEncryptionKeys$(WebPushContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.correctBehaviourShouldSuccessWhenEncryptionKeys(server, pushServer);
    }

    @Test
    default public void correctBehaviourShouldSuccessWhenEncryptionKeys(GuiceJamesServer server, ClientAndServer pushServer) {
        AtomicReference bodyRequestOnPushServer = new AtomicReference();
        pushServer.when((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()).withMethod("POST")).respond(new ExpectationResponseCallback(null, bodyRequestOnPushServer){
            private final AtomicReference bodyRequestOnPushServer$2;

            public HttpResponse handle(HttpRequest httpRequest) {
                this.bodyRequestOnPushServer$2.set(httpRequest.getBodyAsRawBytes());
                return HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(201));
            }
            {
                this.bodyRequestOnPushServer$2 = bodyRequestOnPushServer$2;
            }
        });
        KeyPair uaKeyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        ECPublicKey uaPublicKey = (ECPublicKey)uaKeyPair.getPublic();
        ECPrivateKey uaPrivateKey = (ECPrivateKey)uaKeyPair.getPrivate();
        byte[] authSecret = "secret123secret1".getBytes();
        String p256dh = Base64.getUrlEncoder().encodeToString(uaPublicKey.getEncoded());
        String auth = Base64.getUrlEncoder().encodeToString(authSecret);
        String pushSubscriptionId = (String)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"a889-ffea-910\",\n           |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n           |                  \"types\": [\"Mailbox\"],\n           |                  \"keys\": {\n           |                    \"p256dh\": \"" + p256dh + "\",\n           |                    \"auth\": \"" + auth + "\"\n           |                  }\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }"))).when().post()).then().statusCode(200).extract().jsonPath().get("methodResponses[0][1].created.4f29.id");
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isNotEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"" + pushSubscriptionId + "\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}")));
            Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).hasSizeGreaterThanOrEqualTo(1).allSatisfy(bodyAssert);
        });
        WebPushHybridDecrypt hybridDecrypt = new WebPushHybridDecrypt.Builder().withAuthSecret(authSecret).withRecipientPublicKey(uaPublicKey).withRecipientPrivateKey(uaPrivateKey).build();
        String decryptBodyRequestOnPushServer = new String(hybridDecrypt.decrypt((byte[])bodyRequestOnPushServer.get(), null), StandardCharsets.UTF_8);
        String verificationCode = ((JsString)((JsObject)Json$.MODULE$.parse(decryptBodyRequestOnPushServer)).value().apply((Object)"verificationCode")).value();
        this.updateValidateVerificationCode(pushSubscriptionId, verificationCode);
        this.sendEmailToBob(server);
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> pushServer.verify((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()), VerificationTimes.atLeast((int)1)));
        JsonAssertions.assertThatJson((Object)new String(hybridDecrypt.decrypt((byte[])bodyRequestOnPushServer.get(), null), StandardCharsets.UTF_8)).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"@type\": \"StateChange\",\n           |    \"changed\": {\n           |        \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\": {\n           |          \"Mailbox\": \"${json-unit.ignore}\"\n           |        }\n           |    }\n           |}")));
    }

    private MessageId prepareDraftMessage(GuiceJamesServer server) {
        Message message = Message.Builder.of().setSubject("test").setSender(Fixture$.MODULE$.BOB().asString()).setFrom(Fixture$.MODULE$.BOB().asString()).setTo(Fixture$.MODULE$.ANDRE().asString()).setBody("testmail", StandardCharsets.UTF_8).build();
        MailboxPath bobDraftsPath = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"Drafts");
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobDraftsPath);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), bobDraftsPath, MessageManager.AppendCommand.builder().build(message)).getMessageId();
        return messageId;
    }

    private JsonAssert setupPushSubscriptionForBob(ClientAndServer pushServer) {
        AtomicReference<String> bodyRequestOnPushServer = this.setupPushServerCallback(pushServer);
        String pushSubscriptionId = (String)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"a889-ffea-910\",\n           |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n           |                  \"types\": [\"EmailDelivery\"]\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }"))).when().post()).then().statusCode(200).extract().jsonPath().get("methodResponses[0][1].created.4f29.id");
        this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"" + pushSubscriptionId + "\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}")));
            Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.org$apache$james$jmap$rfc8621$contract$WebPushContract$$PUSH_URL_PATH()))))).asJava()).anySatisfy(bodyAssert);
        });
        String verificationCode = ((JsString)((JsObject)Json$.MODULE$.parse(bodyRequestOnPushServer.get())).value().apply((Object)"verificationCode")).value();
        String updateVerificationCodeResponse = this.updateValidateVerificationCode(pushSubscriptionId, verificationCode);
        return JsonAssertions.assertThatJson((Object)updateVerificationCodeResponse).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscriptionId + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static void $init$(WebPushContract $this) {
    }
}

