/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.VacationIntegrationTest$;
import org.apache.james.junit.categories.BasicFeature;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.vacation.api.VacationPatch;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%v!\u0002\u000f\u001e\u0011\u0003Qc!\u0002\u0017\u001e\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%Ia\u000e\u0005\u0007\u0001\u0006\u0001\u000b\u0011\u0002\u001d\t\u000f\u0005\u000b!\u0019!C\u0005o!1!)\u0001Q\u0001\naBqaQ\u0001C\u0002\u0013%q\u0007\u0003\u0004E\u0003\u0001\u0006I\u0001\u000f\u0005\b\u000b\u0006\u0011\r\u0011\"\u0003G\u0011\u0019y\u0015\u0001)A\u0005\u000f\u001a9A&\bI\u0001\u0004\u0003\u0001\u0006\"B)\f\t\u0003\u0011\u0006\u0002\u0003,\f\u0011\u000b\u0007I\u0011B,\t\u0011y[\u0001R1A\u0005\n}C\u0001\u0002[\u0006\t\u0006\u0004%Ia\u0018\u0005\u0006S.!\tA\u001b\u0005\u0006y.!\t! \u0005\b\u0003WYA\u0011AA\u0017\u0011\u001d\t\u0019d\u0003C\u0001\u0003kAq!a\u000f\f\t\u0003\ti\u0004C\u0004\u0002D-!\t!!\u0012\t\u000f\u0005-3\u0002\"\u0001\u0002N!1\u00111K\u0006\u0005\nICa!!\u0016\f\t\u0013\u0011\u0006bBA,\u0017\u0011%\u0011\u0011\f\u0005\b\u0003;ZA\u0011BA0\u0011\u001d\tYj\u0003C\u0005\u0003;\u000bqCV1dCRLwN\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005yy\u0012\u0001C2p]R\u0014\u0018m\u0019;\u000b\u0005\u0001\n\u0013a\u0002:gGb2$'\r\u0006\u0003E\r\nAA[7ba*\u0011A%J\u0001\u0006U\u0006lWm\u001d\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005-\nQ\"A\u000f\u0003/Y\u000b7-\u0019;j_:Le\u000e^3he\u0006$\u0018n\u001c8UKN$8CA\u0001/!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AK\u0001\u0007e\u0016\f7o\u001c8\u0016\u0003a\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\t1\fgn\u001a\u0006\u0002{\u0005!!.\u0019<b\u0013\ty$H\u0001\u0004TiJLgnZ\u0001\be\u0016\f7o\u001c8!\u0003-AG/\u001c7`e\u0016\f7o\u001c8\u0002\u0019!$X\u000e\\0sK\u0006\u001cxN\u001c\u0011\u00025=\u0014\u0018nZ5oC2|V.Z:tC\u001e,w\f^3yi~\u0013w\u000eZ=\u00027=\u0014\u0018nZ5oC2|V.Z:tC\u001e,w\f^3yi~\u0013w\u000eZ=!\u0003=\tg\u000e\u001a:f\tJ\fg\r^:QCRDW#A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015!B7pI\u0016d'B\u0001'$\u0003\u001di\u0017-\u001b7c_bL!AT%\u0003\u00175\u000b\u0017\u000e\u001c2pqB\u000bG\u000f[\u0001\u0011C:$'/\u001a#sC\u001a$8\u000fU1uQ\u0002\u001a\"a\u0003\u0018\u0002\r\u0011Jg.\u001b;%)\u0005\u0019\u0006CA\u0018U\u0013\t)\u0006G\u0001\u0003V]&$\u0018!F:m_^\u0004\u0016mY3e!>dG.\u00138uKJ4\u0018\r\\\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111\fP\u0001\u0005i&lW-\u0003\u0002^5\nAA)\u001e:bi&|g.A\u0006dC2lG._!xC&$X#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001B2pe\u0016T!!Z\u0014\u0002\u0015\u0005<\u0018-\u001b;jY&$\u00180\u0003\u0002hE\n\u00012i\u001c8eSRLwN\u001c$bGR|'/_\u0001\u0016C^\f\u0017\u000e^!u\u001b>\u001cH\u000fV3o'\u0016\u001cwN\u001c3t\u0003\u0015\u0019X\r^+q)\t\u00196\u000eC\u0003m!\u0001\u0007Q.\u0001\u0004tKJ4XM\u001d\t\u0003]>l\u0011aI\u0005\u0003a\u000e\u0012\u0001cR;jG\u0016T\u0015-\\3t'\u0016\u0014h/\u001a:)\u0005A\u0011\bCA:{\u001b\u0005!(BA;w\u0003\r\t\u0007/\u001b\u0006\u0003ob\fqA[;qSR,'O\u0003\u0002zO\u0005)!.\u001e8ji&\u00111\u0010\u001e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\u000b6nCB4\u0016mY1uS>t7\u000b[8vY\u0012<UM\\3sCR,\u0017IU3qYf<\u0006.\u001a8BGRLg/\u001a\u000b\u0003'zDQ\u0001\\\tA\u00025Ds!EA\u0001\u0003#\t\u0019\u0002\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0015\r\fG/Z4pe&,7OC\u0002\u0002\fa\fA\"\u001a=qKJLW.\u001a8uC2LA!a\u0004\u0002\u0006\tA1)\u0019;fO>\u0014\u00180A\u0003wC2,X\r\f\u0002\u0002\u0016\r\u0012\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)!\u0011qAA\u000f\u0015\tI8%\u0003\u0003\u0002\"\u0005m!\u0001\u0004\"bg&\u001cg)Z1ukJ,\u0007fA\t\u0002&A\u00191/a\n\n\u0007\u0005%BO\u0001\u0003UKN$\u0018A\f6nCB4\u0016mY1uS>t7\u000b[8vY\u0012<UM\\3sCR,\u0017IU3qYf,e/\u001a8XQ\u0016tgj\u001c+fqR$2aUA\u0018\u0011\u0015a'\u00031\u0001nQ\r\u0011\u0012QE\u0001)U6\f\u0007OV1dCRLwN\\*i_VdG\rS1wKN+\b\u000f]8si\u001a{'\u000f\u0013;nY6\u000b\u0017\u000e\u001c\u000b\u0004'\u0006]\u0002\"\u00027\u0014\u0001\u0004i\u0007fA\n\u0002&\u0005y#.\\1q-\u0006\u001c\u0017\r^5p]NCw.\u001e7e\u001d>$x)\u001a8fe\u0006$X-\u0011*fa2Lx\u000b[3o\u0013:\f7\r^5wKR\u00191+a\u0010\t\u000b1$\u0002\u0019A7)\u0007Q\t)#\u0001\u0016k[\u0006\u0004h+Y2bi&|gn\u00155pk2$gj\u001c;TK:$gj\u001c;jM&\u001c\u0017\r^5p]R;\u0018nY3\u0015\u0007M\u000b9\u0005C\u0003m+\u0001\u0007Q\u000eK\u0002\u0016\u0003K\t\u0001H[7baZ\u000b7-\u0019;j_:\u001c\u0006n\\;mIN+g\u000e\u001a(pi&4\u0017nY1uS>tGk^5dK^CWM\u001c,bG\u0006$\u0018n\u001c8SKN,G\u000fF\u0002T\u0003\u001fBQ\u0001\u001c\fA\u00025D3AFA\u0013\u0003M\u0019X\r\u001e,bG\u0006$\u0018n\u001c8SKN\u0004xN\\:f\u0003]\u0019X\r\u001e%u[24\u0016mY1uS>t'+Z:q_:\u001cX-\u0001\nb]\u0012\u0014XmU3oI6\u000b\u0017\u000e\u001c+p\u0005>\u0014GcA*\u0002\\!)A.\u0007a\u0001[\u0006\t\u0012n]'fgN\fw-\u001a*fG\u0016Lg/\u001a3\u0015\u001bM\u000b\t'a\u0019\u0002|\u0005\u0015\u00151SAL\u0011\u0015a'\u00041\u0001n\u0011\u001d\t)G\u0007a\u0001\u0003O\n\u0011\"Y2d_VtG/\u00133\u0011\t\u0005%\u0014q\u000f\b\u0005\u0003W\n\u0019\bE\u0002\u0002nAj!!a\u001c\u000b\u0007\u0005E\u0014&\u0001\u0004=e>|GOP\u0005\u0004\u0003k\u0002\u0014A\u0002)sK\u0012,g-C\u0002@\u0003sR1!!\u001e1\u0011\u001d\tiH\u0007a\u0001\u0003\u007f\n\u0011\"\\1jY\n|\u00070\u00133\u0011\u0007!\u000b\t)C\u0002\u0002\u0004&\u0013\u0011\"T1jY\n|\u00070\u00133\t\u000f\u0005\u001d%\u00041\u0001\u0002\n\u0006AQo]3s]\u0006lW\r\u0005\u0003\u0002\f\u0006=UBAAG\u0015\t\u00197%\u0003\u0003\u0002\u0012\u00065%\u0001C+tKJt\u0017-\\3\t\u000f\u0005U%\u00041\u0001\u0002h\u0005A\u0001/Y:to>\u0014H\rC\u0004\u0002\u001aj\u0001\r!a\u001a\u0002\u0019\u0015D\b/Z2uK\u0012\u0014u\u000eZ=\u0002'\u0005\u0014XMM'fgN\fw-\u001a*fG\u0016Lg/\u001a3\u0015\u0017M\u000by*!)\u0002$\u0006\u0015\u0016q\u0015\u0005\u0006Yn\u0001\r!\u001c\u0005\b\u0003KZ\u0002\u0019AA4\u0011\u001d\tih\u0007a\u0001\u0003\u007fBq!a\"\u001c\u0001\u0004\tI\tC\u0004\u0002\u0016n\u0001\r!a\u001a")
public interface VacationIntegrationTest {
    public static /* synthetic */ Duration org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$slowPacedPollInterval$(VacationIntegrationTest $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$slowPacedPollInterval();
    }

    default public Duration org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$slowPacedPollInterval() {
        return Durations.ONE_HUNDRED_MILLISECONDS;
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$calmlyAwait$(VacationIntegrationTest $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$calmlyAwait();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$calmlyAwait() {
        return Awaitility.with().pollInterval(this.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$slowPacedPollInterval()).and().with().pollDelay(this.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$slowPacedPollInterval()).await();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$awaitAtMostTenSeconds$(VacationIntegrationTest $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$awaitAtMostTenSeconds() {
        return this.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$calmlyAwait().atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(VacationIntegrationTest $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain("domain.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "Sent");
        mailboxProbe.createMailbox("#private", Fixture$.MODULE$.ANDRE().asString(), "Sent");
        mailboxProbe.createMailbox(VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$andreDraftsPath());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void jmapVacationShouldGenerateAReplyWhenActive$(VacationIntegrationTest $this, GuiceJamesServer server) {
        $this.jmapVacationShouldGenerateAReplyWhenActive(server);
    }

    @Category(value={BasicFeature.class})
    @Test
    default public void jmapVacationShouldGenerateAReplyWhenActive(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId bobInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        MailboxId andreInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.ANDRE().asString(), "INBOX");
        this.setVacationResponse();
        this.andreSendMailToBob(server);
        this.isMessageReceived(server, Fixture$.MODULE$.ACCOUNT_ID(), bobInboxId, Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$original_message_text_body());
        this.isMessageReceived(server, Fixture$.MODULE$.ANDRE_ACCOUNT_ID(), andreInboxId, Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$reason());
    }

    public static /* synthetic */ void jmapVacationShouldGenerateAReplyEvenWhenNoText$(VacationIntegrationTest $this, GuiceJamesServer server) {
        $this.jmapVacationShouldGenerateAReplyEvenWhenNoText(server);
    }

    @Test
    default public void jmapVacationShouldGenerateAReplyEvenWhenNoText(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId bobInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        MailboxId andreInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.ANDRE().asString(), "INBOX");
        ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).modifyVacation(AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), VacationPatch.builder().isEnabled(Predef$.MODULE$.boolean2Boolean(true)).build());
        this.andreSendMailToBob(server);
        this.isMessageReceived(server, Fixture$.MODULE$.ACCOUNT_ID(), bobInboxId, Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$original_message_text_body());
        this.isMessageReceived(server, Fixture$.MODULE$.ANDRE_ACCOUNT_ID(), andreInboxId, Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD(), "");
    }

    public static /* synthetic */ void jmapVacationShouldHaveSupportForHtmlMail$(VacationIntegrationTest $this, GuiceJamesServer server) {
        $this.jmapVacationShouldHaveSupportForHtmlMail(server);
    }

    @Test
    default public void jmapVacationShouldHaveSupportForHtmlMail(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId bobInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        MailboxId andreInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.ANDRE().asString(), "INBOX");
        this.setHtmlVacationResponse();
        this.andreSendMailToBob(server);
        this.isMessageReceived(server, Fixture$.MODULE$.ACCOUNT_ID(), bobInboxId, Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$original_message_text_body());
        this.isMessageReceived(server, Fixture$.MODULE$.ANDRE_ACCOUNT_ID(), andreInboxId, Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$reason());
    }

    public static /* synthetic */ void jmapVacationShouldNotGenerateAReplyWhenInactive$(VacationIntegrationTest $this, GuiceJamesServer server) {
        $this.jmapVacationShouldNotGenerateAReplyWhenInactive(server);
    }

    @Test
    default public void jmapVacationShouldNotGenerateAReplyWhenInactive(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId bobInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        MailboxId andreInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.ANDRE().asString(), "INBOX");
        this.andreSendMailToBob(server);
        this.isMessageReceived(server, Fixture$.MODULE$.ACCOUNT_ID(), bobInboxId, Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$original_message_text_body());
        Thread.sleep(1000L);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Email/query\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |      \"filter\": {\"inMailbox\": \"" + andreInboxId.serialize() + "\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].ids").isArray().hasSize(0);
    }

    public static /* synthetic */ void jmapVacationShouldNotSendNotificationTwice$(VacationIntegrationTest $this, GuiceJamesServer server) {
        $this.jmapVacationShouldNotSendNotificationTwice(server);
    }

    @Test
    default public void jmapVacationShouldNotSendNotificationTwice(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId bobInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        MailboxId andreInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.ANDRE().asString(), "INBOX");
        this.setVacationResponse();
        this.andreSendMailToBob(server);
        this.andreSendMailToBob(server);
        this.isMessageReceived(server, Fixture$.MODULE$.ANDRE_ACCOUNT_ID(), andreInboxId, Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$reason());
        Thread.sleep(1000L);
        this.isMessageReceived(server, Fixture$.MODULE$.ANDRE_ACCOUNT_ID(), andreInboxId, Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$reason());
    }

    public static /* synthetic */ void jmapVacationShouldSendNotificationTwiceWhenVacationReset$(VacationIntegrationTest $this, GuiceJamesServer server) {
        $this.jmapVacationShouldSendNotificationTwiceWhenVacationReset(server);
    }

    @Test
    default public void jmapVacationShouldSendNotificationTwiceWhenVacationReset(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId bobInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        MailboxId andreInboxId = mailboxProbe.createMailbox("#private", Fixture$.MODULE$.ANDRE().asString(), "INBOX");
        this.setVacationResponse();
        this.andreSendMailToBob(server);
        this.isMessageReceived(server, Fixture$.MODULE$.ANDRE_ACCOUNT_ID(), andreInboxId, Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$reason());
        this.setVacationResponse();
        this.andreSendMailToBob(server);
        this.are2MessageReceived(server, Fixture$.MODULE$.ANDRE_ACCOUNT_ID(), andreInboxId, Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD());
    }

    private void setVacationResponse() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"using\": [ \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:vacationresponse\" ],\n         |  \"methodCalls\": [\n         |    [\"VacationResponse/set\", {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"update\": {\n         |        \"singleton\": {\n         |          \"isEnabled\": true,\n         |          \"subject\": \"I am in vacation\",\n         |          \"textBody\": \"" + VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$reason() + "\"\n         |        }\n         |      }\n         |    }, \"c1\"]\n         |  ]\n         |}\n         |"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().log().ifValidationFails().statusCode(200);
    }

    private void setHtmlVacationResponse() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"using\": [ \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:ietf:params:jmap:vacationresponse\" ],\n         |  \"methodCalls\": [\n         |    [\"VacationResponse/set\", {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"update\": {\n         |        \"singleton\": {\n         |          \"isEnabled\": true,\n         |          \"subject\": \"I am in vacation\",\n         |          \"htmlBody\": \"" + VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$html_reason() + "\"\n         |        }\n         |      }\n         |    }, \"c1\"]\n         |  ]\n         |}\n         |"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().log().ifValidationFails().statusCode(200);
    }

    private void andreSendMailToBob(GuiceJamesServer server) {
        Message message = Message.Builder.of().setSubject("test").setSender(Fixture$.MODULE$.ANDRE().asString()).setFrom("ANDRE <" + Fixture$.MODULE$.ANDRE().asString() + ">").setTo(Fixture$.MODULE$.BOB().asString()).setBody(VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$original_message_text_body(), StandardCharsets.UTF_8).build();
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), VacationIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$andreDraftsPath(), MessageManager.AppendCommand.builder().build(message)).getMessageId();
        String requestAndre = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [\n         |     [\"EmailSubmission/set\", {\n         |       \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |       \"create\": {\n         |         \"k1490\": {\n         |           \"emailId\": \"" + messageId.serialize() + "\",\n         |           \"envelope\": {\n         |             \"mailFrom\": {\"email\": \"" + Fixture$.MODULE$.ANDRE().asString() + "\"},\n         |             \"rcptTo\": [{\"email\": \"" + Fixture$.MODULE$.BOB().asString() + "\"}]\n         |           }\n         |         }\n         |    }\n         |  }, \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(requestAndre).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200);
    }

    private void isMessageReceived(GuiceJamesServer server, String accountId, MailboxId mailboxId, Username username, String password, String expectedBody) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Email/query\",\n         |    {\n         |      \"accountId\": \"" + accountId + "\",\n         |      \"filter\": {\"inMailbox\": \"" + mailboxId.serialize() + "\"}\n         |    },\n         |    \"c1\"], [\n         |     \"Email/get\",\n         |     {\n         |       \"accountId\": \"" + accountId + "\",\n         |       \"#ids\": {\n         |         \"resultOf\":\"c1\",\n         |         \"name\":\"Email/query\",\n         |         \"path\":\"ids/*\"\n         |       }\n         |     },\n         |     \"c2\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(username, password))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].ids").isArray().hasSize(1);
            JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[1][1].list[0].preview").isEqualTo((Object)expectedBody);
        });
    }

    private void are2MessageReceived(GuiceJamesServer server, String accountId, MailboxId mailboxId, Username username, String password) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Email/query\",\n         |    {\n         |      \"accountId\": \"" + accountId + "\",\n         |      \"filter\": {\"inMailbox\": \"" + mailboxId.serialize() + "\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$VacationIntegrationTest$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(username, password))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].ids").isArray().hasSize(2);
        });
    }

    public static void $init$(VacationIntegrationTest $this) {
    }
}

