/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.UploadContract$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005%<Q!\u0005\n\t\u0002}1Q!\t\n\t\u0002\tBQ!K\u0001\u0005\u0002)BqaK\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0003\u0001\u0006I!\f\u0005\bi\u0005\u0011\r\u0011\"\u0003-\u0011\u0019)\u0014\u0001)A\u0005[\u00199\u0011E\u0005I\u0001\u0004\u00031\u0004\"B\u001c\b\t\u0003A\u0004\"\u0002\u001f\b\t\u0003i\u0004\"B(\b\t\u0003A\u0004\"\u0002,\b\t\u0003A\u0004\"B.\b\t\u0003A\u0004\"B/\b\t\u0003A\u0004\"B0\b\t\u0003A\u0004\"B1\b\t\u0003\u0011\u0007\"B3\b\t\u00031\u0017AD+qY>\fGmQ8oiJ\f7\r\u001e\u0006\u0003'Q\t\u0001bY8oiJ\f7\r\u001e\u0006\u0003+Y\tqA\u001d4dqY\u0012\u0014G\u0003\u0002\u00181\u0005!!.\\1q\u0015\tI\"$A\u0003kC6,7O\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001\u0001\t\u0003A\u0005i\u0011A\u0005\u0002\u000f+Bdw.\u00193D_:$(/Y2u'\t\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\t\u0011BQ%H?&s\u0005+\u0016+\u0016\u00035\u00022\u0001\n\u00181\u0013\tySEA\u0003BeJ\f\u0017\u0010\u0005\u0002%c%\u0011!'\n\u0002\u0005\u0005f$X-\u0001\u0006C\u0013\u001e{\u0016J\u0014)V)\u0002\n1BV!M\u0013\u0012{\u0016J\u0014)V)\u0006aa+\u0011'J\t~Ke\nU+UAM\u0011qaI\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003e\u0002\"\u0001\n\u001e\n\u0005m*#\u0001B+oSR\fQa]3u+B$\"!\u000f \t\u000b}J\u0001\u0019\u0001!\u0002\rM,'O^3s!\t\t%)D\u0001\u0019\u0013\t\u0019\u0005D\u0001\tHk&\u001cWMS1nKN\u001cVM\u001d<fe\"\u0012\u0011\"\u0012\t\u0003\r6k\u0011a\u0012\u0006\u0003\u0011&\u000b1!\u00199j\u0015\tQ5*A\u0004kkBLG/\u001a:\u000b\u00051c\u0012!\u00026v]&$\u0018B\u0001(H\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001%g\"|W\u000f\u001c3Va2|\u0017\r\u001a$jY\u0016\fe\u000eZ!mY><Hk\u001c#po:dw.\u00193Ji\"\"!\"\u0015+V!\t1%+\u0003\u0002T\u000f\na!+\u001a9fCR,G\rV3ti\u0006)a/\u00197vKv\tA#A\u0016c_\n\u001c\u0006n\\;mI:{GOQ3BY2|w/\u001a3U_V\u0003Hn\\1e\u0013:\fE.[2f\u0003\u000e\u001cw.\u001e8uQ\tY\u0001\f\u0005\u0002G3&\u0011!l\u0012\u0002\u0005)\u0016\u001cH/A\u0018bY&\u001cWm\u00155pk2$gj\u001c;BG\u000e,7o](s\t><h\u000e\\8bI\u001aKG.Z+qY>\fG-\u001a3Cs\n{'\r\u000b\u0002\r1\u0006\u00013\u000f[8vY\u0012\u0014VM[3di^CWM\\+qY>\fGMR5mKR{wNQ5hQ\ti\u0001,A\u0013va2|\u0017\rZ*i_VdGMU3kK\u000e$x\u000b[3o+:\fW\u000f\u001e5f]RL7-\u0019;fI\"\u0012a\u0002W\u00016E>\u00147\u000b[8vY\u0012\u0014U-\u00117m_^,G\rV8Va2|\u0017\rZ%o\u00032L7-Z!dG>,h\u000e^,iK:$U\r\\3hCR,G\r\u0006\u0002:G\")qh\u0004a\u0001\u0001\"\u0012q\u0002W\u0001<E>\u00147\u000b[8vY\u0012\u0014UMT8u\u00032dwn^3e)>,\u0006\u000f\\8bI&s\u0017\t\\5dK\u0006\u001b7m\\;oi^CWM\u001c(pi\u0012+G.Z4bi\u0016$GCA\u001dh\u0011\u0015y\u0004\u00031\u0001AQ\t\u0001\u0002\f")
public interface UploadContract {
    public static /* synthetic */ void setUp$(UploadContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addDomain(Fixture$.MODULE$._2_DOT_DOMAIN().asString()).addUser(Fixture$.MODULE$.ALICE().asString(), Fixture$.MODULE$.ALICE_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void shouldUploadFileAndAllowToDownloadIt$(UploadContract $this) {
        $this.shouldUploadFileAndAllowToDownloadIt();
    }

    @RepeatedTest(value=20)
    default public void shouldUploadFileAndAllowToDownloadIt() {
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        byte[] downloadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ACCOUNT_ID() + "/" + blobId, new Object[0])).then().statusCode(200).contentType("application/json").extract().body().asByteArray();
        Assertions.assertThat((InputStream)new ByteArrayInputStream(downloadResponse)).hasBinaryContent(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT());
    }

    public static /* synthetic */ void bobShouldNotBeAllowedToUploadInAliceAccount$(UploadContract $this) {
        $this.bobShouldNotBeAllowedToUploadInAliceAccount();
    }

    @Test
    default public void bobShouldNotBeAllowedToUploadInAliceAccount() {
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post("/upload/" + Fixture$.MODULE$.ALICE_ACCOUNT_ID(), new Object[0])).then().statusCode(403).header("Content-Length", "84").body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Upload to other accounts is forbidden"), new Object[0]);
    }

    public static /* synthetic */ void aliceShouldNotAccessOrDownloadFileUploadedByBob$(UploadContract $this) {
        $this.aliceShouldNotAccessOrDownloadFileUploadedByBob();
    }

    @Test
    default public void aliceShouldNotAccessOrDownloadFileUploadedByBob() {
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        ((Validatable)RestAssured.given().auth().basic(Fixture$.MODULE$.ALICE().asString(), Fixture$.MODULE$.ALICE_PASSWORD()).basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ALICE_ACCOUNT_ID() + "/" + blobId, new Object[0])).then().statusCode(403).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"You cannot download in others accounts"), new Object[0]);
    }

    public static /* synthetic */ void shouldRejectWhenUploadFileTooBig$(UploadContract $this) {
        $this.shouldRejectWhenUploadFileTooBig();
    }

    @Test
    default public void shouldRejectWhenUploadFileTooBig() {
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).contentType(ContentType.BINARY).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$BIG_INPUT()).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(400).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)400)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Attempt to upload exceed max size"), new Object[0]);
    }

    public static /* synthetic */ void uploadShouldRejectWhenUnauthenticated$(UploadContract $this) {
        $this.uploadShouldRejectWhenUnauthenticated();
    }

    @Test
    default public void uploadShouldRejectWhenUnauthenticated() {
        ((Validatable)RestAssured.given().auth().none().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).contentType(ContentType.BINARY).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(401).header("WWW-Authenticate", "Basic realm=\"simple\", Bearer realm=\"JWT\"").body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
    }

    public static /* synthetic */ void bobShouldBeAllowedToUploadInAliceAccountWhenDelegated$(UploadContract $this, GuiceJamesServer server) {
        $this.bobShouldBeAllowedToUploadInAliceAccountWhenDelegated(server);
    }

    @Test
    default public void bobShouldBeAllowedToUploadInAliceAccountWhenDelegated(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.ALICE(), Fixture$.MODULE$.BOB());
        String aliceAccountId = ((AccountId)AccountId$.MODULE$.from(Fixture$.MODULE$.ALICE()).toOption().get()).id();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post("/upload/" + aliceAccountId, new Object[0])).then().statusCode(201).body("size", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)0xB00000)), new Object[0]).body("type", Matchers.equalTo((Object)"application/json; charset=UTF-8"), new Object[0]).body("blobId", Matchers.notNullValue(), new Object[0]).body("accountId", Matchers.equalTo((Object)aliceAccountId), new Object[0]);
    }

    public static /* synthetic */ void bobShouldBeNotAllowedToUploadInAliceAccountWhenNotDelegated$(UploadContract $this, GuiceJamesServer server) {
        $this.bobShouldBeNotAllowedToUploadInAliceAccountWhenNotDelegated(server);
    }

    @Test
    default public void bobShouldBeNotAllowedToUploadInAliceAccountWhenNotDelegated(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.ALICE(), Fixture$.MODULE$.ANDRE());
        String aliceAccountId = ((AccountId)AccountId$.MODULE$.from(Fixture$.MODULE$.ALICE()).toOption().get()).id();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(UploadContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$UploadContract$$VALID_INPUT()).when().post("/upload/" + aliceAccountId, new Object[0])).then().statusCode(403).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"Upload to other accounts is forbidden"), new Object[0]);
    }

    public static void $init$(UploadContract $this) {
    }
}

