/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.ImapKeywordsConsistencyContract$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.TestIMAPClient;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ux!\u0002\u0010 \u0011\u0003ac!\u0002\u0018 \u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004b\u0002\u001d\u0002\u0005\u0004%I!\u000f\u0005\u0007\u0005\u0006\u0001\u000b\u0011\u0002\u001e\u0007\u000f9z\u0002\u0013aA\u0001\u0007\")A)\u0002C\u0001\u000b\"A\u0011*\u0002EC\u0002\u0013%!\n\u0003\u0005T\u000b!\u0015\r\u0011\"\u0003U\u0011!iV\u0001#b\u0001\n\u0013!\u0006\"\u00020\u0006\r\u0003y\u0006\"\u00024\u0006\t\u00039\u0007\"B=\u0006\t\u0003Q\bbBA\u001d\u000b\u0011\u0005\u00111\b\u0005\b\u0003+*A\u0011AA,\u0011\u001d\t\u0019'\u0002C\u0001\u0003KBq!a\u001b\u0006\t\u0003\ti\u0007C\u0004\u0002t\u0015!\t!!\u001e\t\u000f\u0005mT\u0001\"\u0001\u0002~!9\u00111Q\u0003\u0005\u0002\u0005\u0015\u0005bBAF\u000b\u0011%\u0011Q\u0012\u0005\b\u0003/+A\u0011AAM\u0011\u001d\t\t+\u0002C\u0001\u0003GCq!!+\u0006\t\u0003\tY\u000bC\u0004\u0002:\u0016!\t!a/\t\u000f\u0005\u0005W\u0001\"\u0001\u0002D\"9\u0011qY\u0003\u0005\u0002\u0005%\u0007bBAi\u000b\u0011\u0005\u00111\u001b\u0005\b\u00033,A\u0011BAn\u0011\u001d\t\u0019/\u0002C\u0005\u0003K\fq$S7ba.+\u0017p^8sIN\u001cuN\\:jgR,gnY=D_:$(/Y2u\u0015\t\u0001\u0013%\u0001\u0005d_:$(/Y2u\u0015\t\u00113%A\u0004sM\u000eDdGM\u0019\u000b\u0005\u0011*\u0013\u0001\u00026nCBT!AJ\u0014\u0002\u000b)\fW.Z:\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001!\ti\u0013!D\u0001 \u0005}IU.\u00199LKf<xN\u001d3t\u0007>t7/[:uK:\u001c\u0017pQ8oiJ\f7\r^\n\u0003\u0003A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001-\u00031\u0011wNY%oE>D\b+\u0019;i+\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0015iw\u000eZ3m\u0015\tyT%A\u0004nC&d'm\u001c=\n\u0005\u0005c$aC'bS2\u0014w\u000e\u001f)bi\"\fQBY8c\u0013:\u0014w\u000e\u001f)bi\"\u00043CA\u00031\u0003\u0019!\u0013N\\5uIQ\ta\t\u0005\u00022\u000f&\u0011\u0001J\r\u0002\u0005+:LG/A\u000btY><\b+Y2fIB{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0003-\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\tQLW.\u001a\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJ\u0001\u0005EkJ\fG/[8o\u0003-\u0019\u0017\r\\7ms\u0006;\u0018-\u001b;\u0016\u0003U\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\t\r|'/\u001a\u0006\u00035&\n!\"Y<bSRLG.\u001b;z\u0013\tavK\u0001\tD_:$\u0017\u000e^5p]\u001a\u000b7\r^8ss\u0006!\u0012m^1ji\u0006#Xj\\:u\u001f:,W*\u001b8vi\u0016\f!\"[7ba\u000ec\u0017.\u001a8u+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2&\u0003\u0015)H/\u001b7t\u0013\t)'M\u0001\bUKN$\u0018*T!Q\u00072LWM\u001c;\u0002\u000bM,G/\u00169\u0015\u0005\u0019C\u0007\"B5\f\u0001\u0004Q\u0017AB:feZ,'\u000f\u0005\u0002lY6\tQ%\u0003\u0002nK\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u0017=\u0004\"\u0001]<\u000e\u0003ET!A]:\u0002\u0007\u0005\u0004\u0018N\u0003\u0002uk\u00069!.\u001e9ji\u0016\u0014(B\u0001<*\u0003\u0015QWO\\5u\u0013\tA\u0018O\u0001\u0006CK\u001a|'/Z#bG\"\f!(Z7bS2<U\r^*i_VdG-\u00168j_:\\U-_<pe\u0012\u001cx\u000b[3o\u0013:\u001cwN\\:jgR,gnY=De\u0016\fG/\u001a3WS\u0006LU.\u00199\u0015\t\u0019[\u0018q\u0002\u0005\u0006\u007f1\u0001\r\u0001 \t\u0004{\u0006%ab\u0001@\u0002\u0006A\u0011qPM\u0007\u0003\u0003\u0003Q1!a\u0001,\u0003\u0019a$o\\8u}%\u0019\u0011q\u0001\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\tY!!\u0004\u0003\rM#(/\u001b8h\u0015\r\t9A\r\u0005\u0006S2\u0001\rA\u001b\u0015\u0004\u0019\u0005M\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005e1/\u0001\u0004qCJ\fWn]\u0005\u0005\u0003;\t9BA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDs\u0001DA\u0011\u0003[\ty\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\u0011\t9#a\u0006\u0002\u0011A\u0014xN^5eKJLA!a\u000b\u0002&\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!!\r\u00026\u0005\u0012\u00111G\u0001\u0006\u0013:\u0013u\nW\u0011\u0003\u0003o\tq!\u0011:dQ&4X-A\u001ef[\u0006LGnR3u'\"|W\u000f\u001c3J]R,'o]3di\u0012\u0013\u0018M\u001a;XQ\u0016t\u0017J\\2p]NL7\u000f^3oGf\u001c%/Z1uK\u00124\u0016.Y%nCB$RARA\u001f\u0003\u007fAQaP\u0007A\u0002qDQ![\u0007A\u0002)Ds!DA\"\u0003\u0013\nY\u0005E\u0002q\u0003\u000bJ1!a\u0012r\u0005!!\u0015n]1cY\u0016$\u0017!\u0002<bYV,\u0017EAA'\u0003iru\u000eI5oi\u0016\u00148/Z2uS>t\u0007e\u001c8!\u00156\u000b\u0005\u000b\t*G\u00072\u0002\u0013\r\u001c7!W\u0016Lxo\u001c:eg\u0002\n'/\u001a\u0011kkN$\b%\u001e8j_:,G\rK\u0002\u000e\u0003'As!DA\u0011\u0003[\t\u0019\u0006\f\u0003\u00022\u0005U\u0012AR3nC&d\u0017+^3ssNCw.\u001e7e%\u0016$XO\u001d8NCR\u001c\u0007.\u001b8h\u001b\u0016\u001c8/Y4f\u0013\u0012<\u0006.\u001a8NCR\u001c\u0007.\u001b8h\u0013:\fE\u000fT3bgR|e.Z'bS2\u0014w\u000e\u001f\u000b\u0004\r\u0006e\u0003\"B5\u000f\u0001\u0004Q\u0007f\u0001\b\u0002^A\u0019\u0001/a\u0018\n\u0007\u0005\u0005\u0014O\u0001\u0003UKN$\u0018\u0001P3nC&d\u0017+^3ss&s7\u000b]3dS\u001aL7-T1jY\n|\u0007p\u00155pk2$'+\u001a;ve:lUm]:bO\u0016LEm\u00165f]6\u000bGo\u00195j]\u001e$2ARA4\u0011\u0015Iw\u00021\u0001kQ\ry\u0011QL\u0001>K6\f\u0017\u000e\\)vKJL\u0018J\\*qK\u000eLg-[2NC&d'm\u001c=TQ>,H\u000eZ*lSBlUm]:bO\u0016LEm\u00165f]:{G/T1uG\"Lgn\u001a\u000b\u0004\r\u0006=\u0004\"B5\u0011\u0001\u0004Q\u0007f\u0001\t\u0002^\u0005yU-\\1jYN+Go\u00155pk2$7+^2dK\u0016$Gk\\*pYZ,7*Z=x_J$7oQ8oM2L7\r^:J]R\u0014x\u000eZ;dK\u00124\u0016.Y%nCB,\u0006o\u001c8GY\u0006<7/\u00113eSRLwN\u001c\u000b\u0004\r\u0006]\u0004\"B5\u0012\u0001\u0004Q\u0007fA\t\u0002^\u0005!V-\\1jYN+Go\u00155pk2$\u0017j\u001a8pe\u0016\\U-_<pe\u0012\u001c8i\u001c8gY&\u001cG/\u00138ue>$WoY3e-&\f\u0017*\\1q+B|gN\u00127bON$U\r\\3uS>tw+\u001b;i\u000b6\f\u0017\u000e\\)vKJLHc\u0001$\u0002\u0000!)\u0011N\u0005a\u0001U\"\u001a!#!\u0018\u0002%\u0016l\u0017-\u001b7TKR\u001c\u0006n\\;mI&;gn\u001c:f\u0017\u0016Lxo\u001c:eg\u000e{gN\u001a7jGRLe\u000e\u001e:pIV\u001cW\r\u001a,jC&k\u0017\r]+q_:4E.Y4t\t\u0016dW\r^5p]^KG\u000f[#nC&dw)\u001a;\u0015\u0007\u0019\u000b9\tC\u0003j'\u0001\u0007!\u000eK\u0002\u0014\u0003;\nA#\u00199qK:$W*Z:tC\u001e,Gk\\%oE>DH\u0003BAH\u0003+\u00032aOAI\u0013\r\t\u0019\n\u0010\u0002\n\u001b\u0016\u001c8/Y4f\u0013\u0012DQ!\u001b\u000bA\u0002)\fQ$\\8wK6+7o]1hK\u001a\u0013x.\\%oE>DHk\\!sG\"Lg/\u001a\u000b\u0006\r\u0006m\u0015Q\u0014\u0005\u0006SV\u0001\rA\u001b\u0005\b\u0003?+\u0002\u0019AAH\u0003%iWm]:bO\u0016LE-A\u000fd_BLX*Z:tC\u001e,gI]8n\u0013:\u0014w\u000e\u001f+p\u0003J\u001c\u0007.\u001b<f)\u00151\u0015QUAT\u0011\u0015Ig\u00031\u0001k\u0011\u001d\tyJ\u0006a\u0001\u0003\u001f\u000ba\u0002\\5ti6+7o]1hK&#7\u000f\u0006\u0002\u0002.B)\u0011qVA[y6\u0011\u0011\u0011\u0017\u0006\u0004\u0003g{\u0015\u0001B;uS2LA!a.\u00022\nI\u0011I\u001d:bs2K7\u000f^\u0001\u0018Y&\u001cH/T3tg\u0006<W-\u00133t\u0005f\\W-_<pe\u0012$B!!,\u0002>\"1\u0011q\u0018\rA\u0002q\fqa[3zo>\u0014H-A\u000bmSN$X*Z:tC\u001e,\u0017\nZ:Be\u000eD\u0017N^3\u0015\t\u00055\u0016Q\u0019\u0005\u0006Sf\u0001\rA[\u0001\"Y&\u001cH/T3tg\u0006<W-\u00133t\u0005fl\u0015-\u001b7c_b\fe\u000eZ&fs^|'\u000f\u001a\u000b\t\u0003[\u000bY-!4\u0002P\")\u0011N\u0007a\u0001U\")qH\u0007a\u0001y\"1\u0011q\u0018\u000eA\u0002q\f\u0001cZ3u\u001b\u0016\u001c8/Y4fg\nK\u0018\nZ:\u0015\u0007q\f)\u000e\u0003\u0004\u0002Xn\u0001\r\u0001`\u0001\tS\u0012\u001cFO]5oO\u0006iQ-\\1jYN+GO\u00127bON$RARAo\u0003?Dq!a(\u001d\u0001\u0004\ty\t\u0003\u0004\u0002br\u0001\r\u0001`\u0001\u0005M2\fw-\u0001\td_:\u001c\u0017\r^'fgN\fw-Z%egR\u0019A0a:\t\u000f\u0005%X\u00041\u0001\u0002l\u0006\u0019\u0011\u000eZ:\u0011\u000b\u00055\u0018q\u001f?\u000f\t\u0005=\u00181\u001f\b\u0004\u007f\u0006E\u0018\"A\u001a\n\u0007\u0005U('A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00181 \u0002\u0005\u0019&\u001cHOC\u0002\u0002vJ\u0002")
public interface ImapKeywordsConsistencyContract {
    public static /* synthetic */ Duration org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$slowPacedPollInterval$(ImapKeywordsConsistencyContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$slowPacedPollInterval();
    }

    default public Duration org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$slowPacedPollInterval() {
        return Durations.ONE_HUNDRED_MILLISECONDS;
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$calmlyAwait$(ImapKeywordsConsistencyContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$calmlyAwait();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$calmlyAwait() {
        return Awaitility.with().pollInterval(this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$slowPacedPollInterval()).and().with().pollDelay(this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$slowPacedPollInterval()).await();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute$(ImapKeywordsConsistencyContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute() {
        return this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$calmlyAwait().atMost(1L, TimeUnit.MINUTES);
    }

    public TestIMAPClient imapClient();

    public static /* synthetic */ void setUp$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain("domain.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "Archive");
        mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "Trash");
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void emailGetShouldUnionKeywordsWhenInconsistencyCreatedViaImap$(ImapKeywordsConsistencyContract $this, String mailbox, GuiceJamesServer server) {
        $this.emailGetShouldUnionKeywordsWhenInconsistencyCreatedViaImap(mailbox, server);
    }

    @ParameterizedTest
    @ValueSource(strings={"INBOX", "Archive"})
    default public void emailGetShouldUnionKeywordsWhenInconsistencyCreatedViaImap(String mailbox, GuiceJamesServer server) {
        MessageId messageId = this.appendMessageToInbox(server);
        this.copyMessageFromInboxToArchive(server, messageId);
        this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIdsArchive(server).size() == 1));
        this.imapClient().connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()).select(mailbox);
        this.imapClient().setFlagsForAllMessagesInMailbox("\\Flagged");
        List ids = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIds()).asScala().toList();
        Assertions.assertThat((int)ids.size()).isEqualTo(1);
        Assertions.assertThat((Object)ids).isEqualTo((Object)new .colon.colon((Object)messageId.serialize(), (List)Nil$.MODULE$));
        String idString = this.concatMessageIds((List<String>)ids);
        String response = this.getMessagesByIds(idString);
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].list[0].keywords").isEqualTo((Object)"{\"$flagged\": true}");
    }

    public static /* synthetic */ void emailGetShouldIntersectDraftWhenInconsistencyCreatedViaImap$(ImapKeywordsConsistencyContract $this, String mailbox, GuiceJamesServer server) {
        $this.emailGetShouldIntersectDraftWhenInconsistencyCreatedViaImap(mailbox, server);
    }

    @Disabled(value="No intersection on JMAP RFC, all keywords are just unioned")
    @ParameterizedTest
    @ValueSource(strings={"INBOX", "Archive"})
    default public void emailGetShouldIntersectDraftWhenInconsistencyCreatedViaImap(String mailbox, GuiceJamesServer server) {
        MessageId messageId = this.appendMessageToInbox(server);
        this.copyMessageFromInboxToArchive(server, messageId);
        this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIdsArchive(server).size() == 1));
        this.imapClient().connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()).select(mailbox);
        this.imapClient().setFlagsForAllMessagesInMailbox("\\Draft");
        List ids = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIds()).asScala().toList();
        Assertions.assertThat((int)ids.size()).isEqualTo(1);
        Assertions.assertThat((Object)ids).isEqualTo((Object)new .colon.colon((Object)messageId.serialize(), (List)Nil$.MODULE$));
        String idString = this.concatMessageIds((List<String>)ids);
        String response = this.getMessagesByIds(idString);
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].list[0].keywords").isEqualTo((Object)"");
    }

    public static /* synthetic */ void emailQueryShouldReturnMatchingMessageIdWhenMatchingInAtLeastOneMailbox$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server) {
        $this.emailQueryShouldReturnMatchingMessageIdWhenMatchingInAtLeastOneMailbox(server);
    }

    @Test
    default public void emailQueryShouldReturnMatchingMessageIdWhenMatchingInAtLeastOneMailbox(GuiceJamesServer server) {
        MessageId messageId = this.appendMessageToInbox(server);
        this.copyMessageFromInboxToArchive(server, messageId);
        this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIdsArchive(server).size() == 1));
        this.imapClient().connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()).select("Archive");
        this.imapClient().setFlagsForAllMessagesInMailbox("\\Flagged");
        List ids = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIdsBykeyword("$Flagged")).asScala().toList();
        Assertions.assertThat((int)ids.size()).isEqualTo(1);
        Assertions.assertThat((Object)ids).isEqualTo((Object)new .colon.colon((Object)messageId.serialize(), (List)Nil$.MODULE$));
    }

    public static /* synthetic */ void emailQueryInSpecificMailboxShouldReturnMessageIdWhenMatching$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server) {
        $this.emailQueryInSpecificMailboxShouldReturnMessageIdWhenMatching(server);
    }

    @Test
    default public void emailQueryInSpecificMailboxShouldReturnMessageIdWhenMatching(GuiceJamesServer server) {
        MessageId messageId = this.appendMessageToInbox(server);
        this.copyMessageFromInboxToArchive(server, messageId);
        this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIdsArchive(server).size() == 1));
        this.imapClient().connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()).select("Archive");
        this.imapClient().setFlagsForAllMessagesInMailbox("\\Flagged");
        List ids = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIdsByMailboxAndKeyword(server, "Archive", "$Flagged")).asScala().toList();
        Assertions.assertThat((int)ids.size()).isEqualTo(1);
        Assertions.assertThat((Object)ids).isEqualTo((Object)new .colon.colon((Object)messageId.serialize(), (List)Nil$.MODULE$));
    }

    public static /* synthetic */ void emailQueryInSpecificMailboxShouldSkipMessageIdWhenNotMatching$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server) {
        $this.emailQueryInSpecificMailboxShouldSkipMessageIdWhenNotMatching(server);
    }

    @Test
    default public void emailQueryInSpecificMailboxShouldSkipMessageIdWhenNotMatching(GuiceJamesServer server) {
        MessageId messageId = this.appendMessageToInbox(server);
        this.copyMessageFromInboxToArchive(server, messageId);
        this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIdsArchive(server).size() == 1));
        this.imapClient().connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()).select("Archive");
        this.imapClient().setFlagsForAllMessagesInMailbox("\\Flagged");
        List ids = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIdsByMailboxAndKeyword(server, "INBOX", "$Flagged")).asScala().toList();
        Assertions.assertThat((int)ids.size()).isEqualTo(0);
    }

    public static /* synthetic */ void emailSetShouldSucceedToSolveKeywordsConflictsIntroducedViaImapUponFlagsAddition$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server) {
        $this.emailSetShouldSucceedToSolveKeywordsConflictsIntroducedViaImapUponFlagsAddition(server);
    }

    @Test
    default public void emailSetShouldSucceedToSolveKeywordsConflictsIntroducedViaImapUponFlagsAddition(GuiceJamesServer server) {
        MessageId messageId = this.appendMessageToInbox(server);
        this.copyMessageFromInboxToArchive(server, messageId);
        this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIdsArchive(server).size() == 1));
        this.imapClient().connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()).select("Archive");
        this.imapClient().setFlagsForAllMessagesInMailbox("\\Flagged");
        this.emailSetFlags(messageId, "$Flagged");
        List idsArchive = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIdsByMailboxAndKeyword(server, "Archive", "$Flagged")).asScala().toList();
        Assertions.assertThat((int)idsArchive.size()).isEqualTo(1);
        Assertions.assertThat((Object)idsArchive).isEqualTo((Object)new .colon.colon((Object)messageId.serialize(), (List)Nil$.MODULE$));
        List idsInbox = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIdsByMailboxAndKeyword(server, "INBOX", "$Flagged")).asScala().toList();
        Assertions.assertThat((int)idsInbox.size()).isEqualTo(1);
        Assertions.assertThat((Object)idsInbox).isEqualTo((Object)new .colon.colon((Object)messageId.serialize(), (List)Nil$.MODULE$));
    }

    public static /* synthetic */ void emailSetShouldIgnoreKeywordsConflictIntroducedViaImapUponFlagsDeletionWithEmailQuery$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server) {
        $this.emailSetShouldIgnoreKeywordsConflictIntroducedViaImapUponFlagsDeletionWithEmailQuery(server);
    }

    @Test
    default public void emailSetShouldIgnoreKeywordsConflictIntroducedViaImapUponFlagsDeletionWithEmailQuery(GuiceJamesServer server) {
        MessageId messageId = this.appendMessageToInbox(server);
        this.copyMessageFromInboxToArchive(server, messageId);
        this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIdsArchive(server).size() == 1));
        this.imapClient().connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()).select("Archive");
        this.imapClient().setFlagsForAllMessagesInMailbox("\\Flagged");
        this.emailSetFlags(messageId, "$Answered");
        List idsArchive = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIdsByMailboxAndKeyword(server, "Archive", "$Flagged")).asScala().toList();
        Assertions.assertThat((int)idsArchive.size()).isEqualTo(0);
        List idsInbox = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIdsByMailboxAndKeyword(server, "INBOX", "$Flagged")).asScala().toList();
        Assertions.assertThat((int)idsInbox.size()).isEqualTo(0);
        List idsAnsweredArchive = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIdsByMailboxAndKeyword(server, "Archive", "$Answered")).asScala().toList();
        Assertions.assertThat((int)idsAnsweredArchive.size()).isEqualTo(1);
        Assertions.assertThat((Object)idsAnsweredArchive).isEqualTo((Object)new .colon.colon((Object)messageId.serialize(), (List)Nil$.MODULE$));
        List idsAnsweredInbox = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIdsByMailboxAndKeyword(server, "INBOX", "$Answered")).asScala().toList();
        Assertions.assertThat((int)idsAnsweredInbox.size()).isEqualTo(1);
        Assertions.assertThat((Object)idsAnsweredInbox).isEqualTo((Object)new .colon.colon((Object)messageId.serialize(), (List)Nil$.MODULE$));
    }

    public static /* synthetic */ void emailSetShouldIgnoreKeywordsConflictIntroducedViaImapUponFlagsDeletionWithEmailGet$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server) {
        $this.emailSetShouldIgnoreKeywordsConflictIntroducedViaImapUponFlagsDeletionWithEmailGet(server);
    }

    @Test
    default public void emailSetShouldIgnoreKeywordsConflictIntroducedViaImapUponFlagsDeletionWithEmailGet(GuiceJamesServer server) {
        MessageId messageId = this.appendMessageToInbox(server);
        this.copyMessageFromInboxToArchive(server, messageId);
        this.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$awaitAtMostOneMinute().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIdsArchive(server).size() == 1));
        this.imapClient().connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()).select("Archive");
        this.imapClient().setFlagsForAllMessagesInMailbox("\\Flagged");
        this.emailSetFlags(messageId, "$Answered");
        List ids = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIds()).asScala().toList();
        Assertions.assertThat((int)ids.size()).isEqualTo(1);
        Assertions.assertThat((Object)ids).isEqualTo((Object)new .colon.colon((Object)messageId.serialize(), (List)Nil$.MODULE$));
        String idString = this.concatMessageIds((List<String>)ids);
        String response = this.getMessagesByIds(idString);
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].list[0].keywords").isEqualTo((Object)"{\"$answered\": true}");
    }

    private MessageId appendMessageToInbox(GuiceJamesServer server) {
        Message message = Message.Builder.of().setSubject("test").setSender(Fixture$.MODULE$.ANDRE().asString()).setFrom("ANDRE <" + Fixture$.MODULE$.ANDRE().asString() + ">").setTo(Fixture$.MODULE$.BOB().asString()).setSubject("My awesome subject").setBody("This is the content", StandardCharsets.UTF_8).build();
        return ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), ImapKeywordsConsistencyContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$ImapKeywordsConsistencyContract$$bobInboxPath(), MessageManager.AppendCommand.builder().build(message)).getMessageId();
    }

    public static /* synthetic */ void moveMessageFromInboxToArchive$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server, MessageId messageId) {
        $this.moveMessageFromInboxToArchive(server, messageId);
    }

    default public void moveMessageFromInboxToArchive(GuiceJamesServer server, MessageId messageId) {
        MailboxId archiveMailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).getMailboxId("#private", Fixture$.MODULE$.BOB().asString(), "Archive");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |    [\"Email/set\", {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"update\": {\n         |        \"" + messageId.serialize() + "\": {\n         |          \"mailboxIds\": {\n         |            \"" + archiveMailboxId.serialize() + "\": true\n         |          }\n         |        }\n         |      }\n         |    }, \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200);
    }

    public static /* synthetic */ void copyMessageFromInboxToArchive$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server, MessageId messageId) {
        $this.copyMessageFromInboxToArchive(server, messageId);
    }

    default public void copyMessageFromInboxToArchive(GuiceJamesServer server, MessageId messageId) {
        MailboxId inboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).getMailboxId("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        MailboxId archiveMailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).getMailboxId("#private", Fixture$.MODULE$.BOB().asString(), "Archive");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |    [\"Email/set\", {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"update\": {\n         |        \"" + messageId.serialize() + "\": {\n         |          \"mailboxIds\": {\n         |            \"" + inboxId.serialize() + "\": true,\n         |            \"" + archiveMailboxId.serialize() + "\": true\n         |          }\n         |        }\n         |      }\n         |    }, \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200);
    }

    public static /* synthetic */ ArrayList listMessageIds$(ImapKeywordsConsistencyContract $this) {
        return $this.listMessageIds();
    }

    default public ArrayList<String> listMessageIds() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/query\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        return (ArrayList)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).extract().body().path("methodResponses[0][1].ids", new String[0]);
    }

    public static /* synthetic */ ArrayList listMessageIdsBykeyword$(ImapKeywordsConsistencyContract $this, String keyword) {
        return $this.listMessageIdsBykeyword(keyword);
    }

    default public ArrayList<String> listMessageIdsBykeyword(String keyword) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/query\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\" : {\n         |        \"hasKeyword\": \"" + keyword + "\"\n         |      }\n         |    },\n         |    \"c1\"]]\n         |}"));
        return (ArrayList)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).extract().body().path("methodResponses[0][1].ids", new String[0]);
    }

    public static /* synthetic */ ArrayList listMessageIdsArchive$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server) {
        return $this.listMessageIdsArchive(server);
    }

    default public ArrayList<String> listMessageIdsArchive(GuiceJamesServer server) {
        MailboxId archiveMailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).getMailboxId("#private", Fixture$.MODULE$.BOB().asString(), "Archive");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/query\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\": {\"inMailbox\": \"" + archiveMailboxId.serialize() + "\"}\n         |    },\n         |    \"c1\"]]\n         |}"));
        return (ArrayList)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).extract().body().path("methodResponses[0][1].ids", new String[0]);
    }

    public static /* synthetic */ ArrayList listMessageIdsByMailboxAndKeyword$(ImapKeywordsConsistencyContract $this, GuiceJamesServer server, String mailbox, String keyword) {
        return $this.listMessageIdsByMailboxAndKeyword(server, mailbox, keyword);
    }

    default public ArrayList<String> listMessageIdsByMailboxAndKeyword(GuiceJamesServer server, String mailbox, String keyword) {
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).getMailboxId("#private", Fixture$.MODULE$.BOB().asString(), mailbox);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/query\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\": {\n         |        \"inMailbox\": \"" + mailboxId.serialize() + "\",\n         |        \"hasKeyword\": \"" + keyword + "\"\n         |      }\n         |    },\n         |    \"c1\"]]\n         |}"));
        return (ArrayList)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).extract().body().path("methodResponses[0][1].ids", new String[0]);
    }

    public static /* synthetic */ String getMessagesByIds$(ImapKeywordsConsistencyContract $this, String idString) {
        return $this.getMessagesByIds(idString);
    }

    default public String getMessagesByIds(String idString) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |     \"Email/get\",\n         |     {\n         |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |       \"ids\": [" + idString + "]\n         |     },\n         |     \"c1\"]]\n         |}"));
        return ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
    }

    private void emailSetFlags(MessageId messageId, String flag) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |    [\"Email/set\", {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"update\": {\n         |        \"" + messageId.serialize() + "\":{\n         |          \"keywords\": {\n         |            \"" + flag + "\": true\n         |          }\n         |        }\n         |      }\n         |    }, \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200);
    }

    private String concatMessageIds(List<String> ids) {
        return ids.map((Function1 & Serializable)id -> "\"" + id + "\"").mkString(",");
    }

    public static void $init$(ImapKeywordsConsistencyContract $this) {
    }
}

