/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import jakarta.mail.internet.SharedInputStream;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.DownloadContract$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E4q\u0001E\t\u0011\u0002\u0007\u0005a\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0003>\u0001\u0019\u0005a\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003T\u0001\u0011\u0005A\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0003\\\u0001\u0011\u0005A\fC\u0003`\u0001\u0011\u0005\u0001\rC\u0003d\u0001\u0011\u0005A\rC\u0003h\u0001\u0011\u0005a\u0005C\u0003j\u0001\u0011\u0005a\u0005C\u0003l\u0001\u0011\u0005a\u0005C\u0003n\u0001\u0011\u0005a\u0005C\u0003p\u0001\u0011\u0005aE\u0001\rF[\u0006LG\u000eU1sg\u0016lU\r\u001e5pI\u000e{g\u000e\u001e:bGRT!AE\n\u0002\u0011\r|g\u000e\u001e:bGRT!\u0001F\u000b\u0002\u000fI47\r\u000f\u001c3c)\u0011acF\u0001\u0005U6\f\u0007O\u0003\u0002\u00193\u0005)!.Y7fg*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\tq\u0005\u0005\u0002!Q%\u0011\u0011&\t\u0002\u0005+:LG/A\u0003tKR,\u0006\u000f\u0006\u0002(Y!)QF\u0001a\u0001]\u000511/\u001a:wKJ\u0004\"a\f\u0019\u000e\u0003]I!!M\f\u0003!\u001d+\u0018nY3KC6,7oU3sm\u0016\u0014\bF\u0001\u00024!\t!4(D\u00016\u0015\t1t'A\u0002ba&T!\u0001O\u001d\u0002\u000f),\b/\u001b;fe*\u0011!hG\u0001\u0006UVt\u0017\u000e^\u0005\u0003yU\u0012!BQ3g_J,W)Y2i\u0003=\u0011\u0018M\u001c3p[6+7o]1hK&#W#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015!B7pI\u0016d'B\u0001#\u0018\u0003\u001di\u0017-\u001b7c_bL!AR!\u0003\u00135+7o]1hK&#\u0017A\u00059beN,7\u000b[8vY\u0012\u001cVoY2fgN$\"aJ%\t\u000b)#\u0001\u0019\u0001\u0018\u0002!\u001d,\u0018nY3KC6,7oU3sm\u0016\u0014\bF\u0001\u0003M!\t!T*\u0003\u0002Ok\t!A+Z:u\u0003=\nG\u000f^1dQ6,g\u000e^:PM:+7\u000f^3e\u001b\u0016\u001c8/Y4fgNCw.\u001e7e\u0005\u0016$un\u001e8m_\u0006$\u0017M\u00197f)\t9\u0013\u000bC\u0003K\u000b\u0001\u0007a\u0006\u000b\u0002\u0006\u0019\u0006\u0001\u0003/\u0019:tKNCw.\u001e7e'V\u001c7-Z:t/\",g.\u0011;uC\u000eDW.\u001a8u)\t9S\u000bC\u0003K\r\u0001\u0007a\u0006\u000b\u0002\u0007\u0019\u0006y\u0002/\u0019:tKNCw.\u001e7e'V\u0004\bo\u001c:u\u00032d\u0007K]8qKJ$\u0018.Z:\u0015\u0005\u001dJ\u0006\"\u0002&\b\u0001\u0004q\u0003FA\u0004M\u0003m\u0001\u0018M]:f'\"|W\u000f\u001c3GS2$XM\u001d)s_B,'\u000f^5fgR\u0011q%\u0018\u0005\u0006\u0015\"\u0001\rA\f\u0015\u0003\u00111\u000ba\u0004]1sg\u0016\u001c\u0006n\\;mI\u0006cGn\\<SKR\u0014\u0018.\u001a<j]\u001e\u0014u\u000eZ=\u0015\u0005\u001d\n\u0007\"\u0002&\n\u0001\u0004q\u0003FA\u0005M\u0003u\u0001\u0018M]:f'\"|W\u000f\u001c3BaBd\u0017PQ8es\u001aKG\u000e^3sS:<GCA\u0014f\u0011\u0015Q%\u00021\u0001/Q\tQA*A\u0011qCJ\u001cXm\u00155pk2$g)Y5m/\",gn\u0016:p]\u001e\f5mY8v]RLE\r\u000b\u0002\f\u0019\u0006Y\u0003/\u0019:tKNCw.\u001e7e%\u0016$XO\u001d8O_R4u.\u001e8e/\",gN\u00117pE\u0012{gj\u001c;Fq&\u001cH\u000f\u000b\u0002\r\u0019\u00061\u0003/\u0019:tKNCw.\u001e7e%\u0016$XO\u001d8O_R4u.\u001e8e/\",gNQ1e\u00052|'-\u00133)\u00055a\u0015A\u000e9beN,7\u000b[8vY\u0012\u0014V\r^;s]Vs7N\\8x]6+G\u000f[8e/\",g.T5tg&twm\u00148f\u0007\u0006\u0004\u0018MY5mSRL\bF\u0001\bM\u0003a\u0002\u0018M]:f'\"|W\u000f\u001c3SKR,(O\\+oW:|wO\\'fi\"|Gm\u00165f]6K7o]5oO\u0006cGnQ1qC\nLG.\u001b;jKND#a\u0004'")
public interface EmailParseMethodContract {
    public static /* synthetic */ void setUp$(EmailParseMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public MessageId randomMessageId();

    public static /* synthetic */ void parseShouldSuccess$(EmailParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldSuccess(guiceJamesServer);
    }

    @Test
    default public void parseShouldSuccess(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/html.eml"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"" + messageId.serialize() + "\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().serialize() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Email/parse\",\n           |            {\n           |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |                \"parsed\": {\n           |                    \"" + messageId.serialize() + "\": {\n           |                        \"inReplyTo\": null,\n           |                        \"to\": [\n           |                            {\n           |                                \"email\": \"to@linagora.com\"\n           |                            }\n           |                        ],\n           |                        \"references\": null,\n           |                        \"textBody\": [\n           |                            {\n           |                                \"charset\": \"utf-8\",\n           |                                \"size\": 39,\n           |                                \"partId\": \"2\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_2\",\n           |                                \"type\": \"text/html\"\n           |                            }\n           |                        ],\n           |                        \"sentAt\": \"2017-02-27T04:24:48Z\",\n           |                        \"hasAttachment\": true,\n           |                        \"attachments\": [\n           |                            {\n           |                                \"charset\": \"UTF-8\",\n           |                                \"disposition\": \"attachment\",\n           |                                \"size\": 271,\n           |                                \"partId\": \"3\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_3\",\n           |                                \"name\": \"text1\",\n           |                                \"type\": \"text/plain\"\n           |                            },\n           |                            {\n           |                                \"charset\": \"us-ascii\",\n           |                                \"disposition\": \"attachment\",\n           |                                \"size\": 398,\n           |                                \"partId\": \"4\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_4\",\n           |                                \"name\": \"text2\",\n           |                                \"type\": \"application/vnd.ms-publisher\"\n           |                            },\n           |                            {\n           |                                \"charset\": \"UTF-8\",\n           |                                \"disposition\": \"attachment\",\n           |                                \"size\": 412,\n           |                                \"partId\": \"5\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_5\",\n           |                                \"name\": \"text3\",\n           |                                \"type\": \"text/plain\"\n           |                            }\n           |                        ],\n           |                        \"subject\": \"MultiAttachment\",\n           |                        \"size\": 2725,\n           |                        \"blobId\": \"" + messageId.serialize() + "\",\n           |                        \"preview\": \"Send concerted from html\",\n           |                        \"htmlBody\": [\n           |                            {\n           |                                \"charset\": \"utf-8\",\n           |                                \"size\": 39,\n           |                                \"partId\": \"2\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_2\",\n           |                                \"type\": \"text/html\"\n           |                            }\n           |                        ],\n           |                        \"bodyValues\": {\n           |\n           |                        },\n           |                        \"messageId\": [\n           |                            \"13d4375e-a4a9-f613-06a1-7e8cb1e0ea93@linagora.com\"\n           |                        ],\n           |                        \"from\": [\n           |                            {\n           |                                \"name\": \"Lina\",\n           |                                \"email\": \"from@linagora.com\"\n           |                            }\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void attachmentsOfNestedMessagesShouldBeDownloadable$(EmailParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.attachmentsOfNestedMessagesShouldBeDownloadable(guiceJamesServer);
    }

    @Test
    default public void attachmentsOfNestedMessagesShouldBeDownloadable(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/nested.eml"))).getMessageId();
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3_3", new Object[0])).then().statusCode(200).contentType("text/plain").extract().body().asString();
        Assertions.assertThat((String)response).isEqualTo("test attachment\n");
    }

    public static /* synthetic */ void parseShouldSuccessWhenAttachment$(EmailParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldSuccessWhenAttachment(guiceJamesServer);
    }

    @Test
    default public void parseShouldSuccessWhenAttachment(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/nested.eml"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"" + messageId.serialize() + "_3\" ],\n         |      \"properties\":[\"bodyValues\", \"preview\", \"hasAttachment\", \"attachments\", \"blobId\", \"size\", \"headers\", \"references\", \"subject\", \"inReplyTo\", \"messageId\", \"from\", \"to\", \"sentAt\"],\n         |      \"fetchTextBodyValues\": true,\n         |      \"fetchHTMLBodyValues\": true,\n         |      \"bodyProperties\":[\"partId\", \"blobId\", \"size\", \"name\", \"type\", \"charset\", \"disposition\", \"cid\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().serialize() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Email/parse\",\n           |            {\n           |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |                \"parsed\": {\n           |                    \"" + messageId.serialize() + "_3\": {\n           |                        \"inReplyTo\": null,\n           |                        \"to\": [\n           |                            {\n           |                                \"name\": \"Me ME\",\n           |                                \"email\": \"me@linagora.com\"\n           |                            }\n           |                        ],\n           |                        \"references\": null,\n           |                        \"bodyValues\": {\n           |                            \"2\": {\n           |                                \"value\": \"test body\\r\\n\",\n           |                                \"isEncodingProblem\": false,\n           |                                \"isTruncated\": false\n           |                            }\n           |                        },\n           |                        \"sentAt\": \"2023-05-03T00:36:49Z\",\n           |                        \"headers\": [\n           |                            {\n           |                                \"name\": \"Return-Path\",\n           |                                \"value\": \" <me@linagora.com>\"\n           |                            },\n           |                            {\n           |                                \"name\": \"Delivered-To\",\n           |                                \"value\": \" me@linagora.com\"\n           |                            },\n           |                            {\n           |                                \"name\": \"Content-Type\",\n           |                                \"value\": \" multipart/mixed; boundary=\\\"------------F6Ykx4Sf21a3Ovh9U5C4q1Qb\\\"\"\n           |                            },\n           |                            {\n           |                                \"name\": \"Message-ID\",\n           |                                \"value\": \" <ed24d4ad-53c0-48c7-2fc9-39f762e4d98d@linagora.com>\"\n           |                            },\n           |                            {\n           |                                \"name\": \"Date\",\n           |                                \"value\": \" Wed, 3 May 2023 07:36:49 +0700\"\n           |                            },\n           |                            {\n           |                                \"name\": \"MIME-Version\",\n           |                                \"value\": \" 1.0\"\n           |                            },\n           |                            {\n           |                                \"name\": \"To\",\n           |                                \"value\": \" Me ME <me@linagora.com>\"\n           |                            },\n           |                            {\n           |                                \"name\": \"From\",\n           |                                \"value\": \" Me ME <me@linagora.com>\"\n           |                            },\n           |                            {\n           |                                \"name\": \"Subject\",\n           |                                \"value\": \" test subject\"\n           |                            }\n           |                        ],\n           |                        \"hasAttachment\": true,\n           |                        \"attachments\": [\n           |                            {\n           |                                \"partId\": \"3\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_3_3\",\n           |                                \"size\": 16,\n           |                                \"name\": \"whatever.txt\",\n           |                                \"type\": \"text/plain\",\n           |                                \"charset\": \"UTF-8\",\n           |                                \"disposition\": \"attachment\"\n           |                            }\n           |                        ],\n           |                        \"subject\": \"test subject\",\n           |                        \"size\": 797,\n           |                        \"blobId\": \"" + messageId.serialize() + "_3\",\n           |                        \"preview\": \"test body\",\n           |                        \"messageId\": [\n           |                            \"ed24d4ad-53c0-48c7-2fc9-39f762e4d98d@linagora.com\"\n           |                        ],\n           |                        \"from\": [\n           |                            {\n           |                                \"name\": \"Me ME\",\n           |                                \"email\": \"me@linagora.com\"\n           |                            }\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void parseShouldSupportAllProperties$(EmailParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldSupportAllProperties(guiceJamesServer);
    }

    @Test
    default public void parseShouldSupportAllProperties(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/html.eml"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"" + messageId.serialize() + "\" ],\n         |      \"properties\": [\"blobId\", \"size\", \"headers\", \"references\", \"subject\", \"inReplyTo\", \"messageId\", \"from\", \"to\", \"sentAt\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String contentType = " multipart/mixed;\\r\\n boundary=\\\"------------64D8D789FC30153D6ED18258\\\"";
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |      [ \"Email/parse\", {\n           |         \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |         \"parsed\": {\n           |           \"" + messageId.serialize() + "\": {\n           |             \"size\": 2725,\n           |             \"blobId\": \"" + messageId.serialize() + "\",\n           |             \"headers\": [\n           |               {\n           |                 \"name\": \"Return-Path\",\n           |                 \"value\": \" <from@linagora.com>\"\n           |               },\n           |               {\n           |                 \"name\": \"To\",\n           |                 \"value\": \" to@linagora.com\"\n           |               },\n           |               {\n           |                 \"name\": \"From\",\n           |                 \"value\": \" Lina <from@linagora.com>\"\n           |               },\n           |               {\n           |                 \"name\": \"Subject\",\n           |                 \"value\": \" MultiAttachment\"\n           |               },\n           |               {\n           |                 \"name\": \"Message-ID\",\n           |                 \"value\": \" <13d4375e-a4a9-f613-06a1-7e8cb1e0ea93@linagora.com>\"\n           |               },\n           |               {\n           |                 \"name\": \"Date\",\n           |                 \"value\": \" Mon, 27 Feb 2017 11:24:48 +0700\"\n           |               },\n           |               {\n           |                 \"name\": \"User-Agent\",\n           |                 \"value\": \" Mozilla/5.0 (X11; Linux x86_64; rv:45.0) Gecko/20100101\\r\\n Thunderbird/45.2.0\"\n           |               },\n           |               {\n           |                 \"name\": \"MIME-Version\",\n           |                 \"value\": \" 1.0\"\n           |               },\n           |               {\n           |                 \"name\": \"Content-Type\",\n           |                 \"value\": \"" + contentType + "\"\n           |               }\n           |             ],\n           |             \"references\": null,\n           |             \"subject\": \"MultiAttachment\",\n           |             \"inReplyTo\": null,\n           |             \"messageId\": [ \"13d4375e-a4a9-f613-06a1-7e8cb1e0ea93@linagora.com\"],\n           |             \"from\": [\n           |               {\n           |                 \"name\": \"Lina\",\n           |                  \"email\": \"from@linagora.com\"\n           |               }\n           |             ],\n           |             \"sentAt\": \"2017-02-27T04:24:48Z\",\n           |             \"to\": [\n           |               {\n           |                  \"email\": \"to@linagora.com\"\n           |               }\n           |             ]\n           |           }\n           |         }\n           |      }, \"c1\" ]]\n           |}")));
    }

    public static /* synthetic */ void parseShouldFilterProperties$(EmailParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldFilterProperties(guiceJamesServer);
    }

    @Test
    default public void parseShouldFilterProperties(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/html.eml"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"" + messageId.serialize() + "\" ],\n         |      \"properties\": [\"blobId\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |      [ \"Email/parse\", {\n           |         \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |         \"parsed\": {\n           |           \"" + messageId.serialize() + "\": {\n           |             \"blobId\": \"" + messageId.serialize() + "\"\n           |           }\n           |         }\n           |      }, \"c1\" ]]\n           |}")));
    }

    public static /* synthetic */ void parseShouldAllowRetrievingBody$(EmailParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldAllowRetrievingBody(guiceJamesServer);
    }

    @Test
    default public void parseShouldAllowRetrievingBody(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/html.eml"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"" + messageId.serialize() + "\" ],\n         |      \"properties\":[\"bodyValues\", \"preview\", \"hasAttachment\", \"attachments\"],\n         |      \"fetchTextBodyValues\": true,\n         |      \"fetchHTMLBodyValues\": true,\n         |      \"bodyProperties\":[\"partId\", \"blobId\", \"size\", \"name\", \"type\", \"charset\", \"disposition\", \"cid\", \"language\", \"location\", \"subParts\", \"headers\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |      [ \"Email/parse\", {\n           |         \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |         \"parsed\":{\n           |         \"" + messageId.serialize() + "\": {\n           |           \"preview\": \"Send concerted from html\",\n           |           \"bodyValues\": {\n           |             \"2\": {\n           |               \"value\": \"Send\\nconcerted from html\\n\\n\\r\\n\\r\\n\",\n           |               \"isEncodingProblem\": false,\n           |               \"isTruncated\": false\n           |             }\n           |           },\n           |           \"hasAttachment\": true,\n           |                        \"attachments\": [\n           |                            {\n           |                                \"partId\": \"3\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_3\",\n           |                                \"headers\": [\n           |                                    {\n           |                                        \"name\": \"Content-Type\",\n           |                                        \"value\": \" text/plain; charset=UTF-8;\\r\\n name=\\\"text1\\\"\"\n           |                                    },\n           |                                    {\n           |                                        \"name\": \"Content-Transfer-Encoding\",\n           |                                        \"value\": \" base64\"\n           |                                    },\n           |                                    {\n           |                                        \"name\": \"Content-Disposition\",\n           |                                        \"value\": \" attachment;\\r\\n filename=\\\"text1\\\"\"\n           |                                    }\n           |                                ],\n           |                                \"size\": 271,\n           |                                \"name\": \"text1\",\n           |                                \"type\": \"text/plain\",\n           |                                \"charset\": \"UTF-8\",\n           |                                \"disposition\": \"attachment\"\n           |                            },\n           |                            {\n           |                                \"partId\": \"4\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_4\",\n           |                                \"headers\": [\n           |                                    {\n           |                                        \"name\": \"Content-Type\",\n           |                                        \"value\": \" application/vnd.ms-publisher;\\r\\n name=\\\"text2\\\"\"\n           |                                    },\n           |                                    {\n           |                                        \"name\": \"Content-Transfer-Encoding\",\n           |                                        \"value\": \" base64\"\n           |                                    },\n           |                                    {\n           |                                        \"name\": \"Content-Disposition\",\n           |                                        \"value\": \" attachment;\\r\\n filename=\\\"text2\\\"\"\n           |                                    }\n           |                                ],\n           |                                \"size\": 398,\n           |                                \"name\": \"text2\",\n           |                                \"type\": \"application/vnd.ms-publisher\",\n           |                                \"charset\": \"us-ascii\",\n           |                                \"disposition\": \"attachment\"\n           |                            },\n           |                            {\n           |                                \"partId\": \"5\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_5\",\n           |                                \"headers\": [\n           |                                    {\n           |                                        \"name\": \"Content-Type\",\n           |                                        \"value\": \" text/plain; charset=UTF-8;\\r\\n name=\\\"text3\\\"\"\n           |                                    },\n           |                                    {\n           |                                        \"name\": \"Content-Transfer-Encoding\",\n           |                                        \"value\": \" base64\"\n           |                                    },\n           |                                    {\n           |                                        \"name\": \"Content-Disposition\",\n           |                                        \"value\": \" attachment;\\r\\n filename=\\\"text3\\\"\"\n           |                                    }\n           |                                ],\n           |                                \"size\": 412,\n           |                                \"name\": \"text3\",\n           |                                \"type\": \"text/plain\",\n           |                                \"charset\": \"UTF-8\",\n           |                                \"disposition\": \"attachment\"\n           |                            }\n           |                        ]\n           |         }}\n           |      }, \"c1\" ]]\n           |}")));
    }

    public static /* synthetic */ void parseShouldApplyBodyFiltering$(EmailParseMethodContract $this, GuiceJamesServer guiceJamesServer) {
        $this.parseShouldApplyBodyFiltering(guiceJamesServer);
    }

    @Test
    default public void parseShouldApplyBodyFiltering(GuiceJamesServer guiceJamesServer) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/html.eml"))).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"" + messageId.serialize() + "\" ],\n         |      \"properties\":[\"bodyValues\", \"preview\", \"hasAttachment\", \"attachments\"],\n         |      \"fetchTextBodyValues\": true,\n         |      \"fetchHTMLBodyValues\": true,\n         |      \"bodyProperties\":[\"partId\", \"blobId\", \"size\", \"name\", \"type\", \"charset\", \"disposition\", \"cid\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |      [ \"Email/parse\", {\n           |         \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |         \"parsed\":{\n           |         \"" + messageId.serialize() + "\": {\n           |           \"preview\": \"Send concerted from html\",\n           |           \"bodyValues\": {\n           |             \"2\": {\n           |               \"value\": \"Send\\nconcerted from html\\n\\n\\r\\n\\r\\n\",\n           |               \"isEncodingProblem\": false,\n           |               \"isTruncated\": false\n           |             }\n           |           },\n           |           \"hasAttachment\": true,\n           |                        \"attachments\": [\n           |                            {\n           |                                \"partId\": \"3\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_3\",\n           |                                \"size\": 271,\n           |                                \"name\": \"text1\",\n           |                                \"type\": \"text/plain\",\n           |                                \"charset\": \"UTF-8\",\n           |                                \"disposition\": \"attachment\"\n           |                            },\n           |                            {\n           |                                \"partId\": \"4\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_4\",\n           |                                \"size\": 398,\n           |                                \"name\": \"text2\",\n           |                                \"type\": \"application/vnd.ms-publisher\",\n           |                                \"charset\": \"us-ascii\",\n           |                                \"disposition\": \"attachment\"\n           |                            },\n           |                            {\n           |                                \"partId\": \"5\",\n           |                                \"blobId\": \"" + messageId.serialize() + "_5\",\n           |                                \"size\": 412,\n           |                                \"name\": \"text3\",\n           |                                \"type\": \"text/plain\",\n           |                                \"charset\": \"UTF-8\",\n           |                                \"disposition\": \"attachment\"\n           |                            }\n           |                        ]\n           |         }}\n           |      }, \"c1\" ]]\n           |}")));
    }

    public static /* synthetic */ void parseShouldFailWhenWrongAccountId$(EmailParseMethodContract $this) {
        $this.parseShouldFailWhenWrongAccountId();
    }

    @Test
    default public void parseShouldFailWhenWrongAccountId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"unknownAccountId\",\n         |      \"blobIds\": [ \"0f9f65ab-dc7b-4146-850f-6e4881093965\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [[\n         |            \"error\",\n         |            {\n         |                \"type\": \"accountNotFound\"\n         |            },\n         |            \"c1\"\n         |        ]]\n         |}")));
    }

    public static /* synthetic */ void parseShouldReturnNotFoundWhenBlobDoNotExist$(EmailParseMethodContract $this) {
        $this.parseShouldReturnNotFoundWhenBlobDoNotExist();
    }

    @Test
    default public void parseShouldReturnNotFoundWhenBlobDoNotExist() {
        String blobIdShouldNotFound = this.randomMessageId().serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"" + blobIdShouldNotFound + "\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [[\n         |      \"Email/parse\",\n         |      {\n         |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |        \"parsed\":{},\n         |        \"notFound\": [\"" + blobIdShouldNotFound + "\"]\n         |      },\n         |      \"c1\"\n         |        ]]\n         |}")));
    }

    public static /* synthetic */ void parseShouldReturnNotFoundWhenBadBlobId$(EmailParseMethodContract $this) {
        $this.parseShouldReturnNotFoundWhenBadBlobId();
    }

    @Test
    default public void parseShouldReturnNotFoundWhenBadBlobId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"invalid\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [[\n         |      \"Email/parse\",\n         |      {\n         |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |        \"parsed\":{},\n         |        \"notFound\": [\"invalid\"]\n         |      },\n         |      \"c1\"\n         |    ]]\n         |}")));
    }

    public static /* synthetic */ void parseShouldReturnUnknownMethodWhenMissingOneCapability$(EmailParseMethodContract $this) {
        $this.parseShouldReturnUnknownMethodWhenMissingOneCapability();
    }

    @Test
    default public void parseShouldReturnUnknownMethodWhenMissingOneCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\"],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"123\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mail\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void parseShouldReturnUnknownMethodWhenMissingAllCapabilities$(EmailParseMethodContract $this) {
        $this.parseShouldReturnUnknownMethodWhenMissingAllCapabilities();
    }

    @Test
    default public void parseShouldReturnUnknownMethodWhenMissingAllCapabilities() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [],\n         |  \"methodCalls\": [[\n         |    \"Email/parse\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"blobIds\": [ \"123\" ]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mail, urn:ietf:params:jmap:core\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static void $init$(EmailParseMethodContract $this) {
    }
}

