/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.QuotaProbesImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsLookupResult;
import play.api.libs.json.JsLookupResult$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005eca\u0002\r\u001a!\u0003\r\tA\n\u0005\u0006[\u0001!\tA\f\u0005\te\u0001A)\u0019!C\u0005g!)a\b\u0001C\u0001\u007f!)\u0011\u000b\u0001D\u0001%\")1\f\u0001D\u00019\")\u0001\r\u0001C\u0001]!)Q\r\u0001C\u0001]!)q\r\u0001C\u0001Q\")1\u000e\u0001C\u0001Y\")q\u000e\u0001C\u0001a\")1\u000f\u0001C\u0001i\")q\u000f\u0001C\u0001q\")1\u0010\u0001C\u0001y\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\u0007\u0003\u0003\u0002A\u0011\u0001\u0018\t\r\u0005\u0015\u0003\u0001\"\u0001/\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!!\u0015\u0001\t\u0003\t\u0019FA\nF[\u0006LG.S7q_J$8i\u001c8ue\u0006\u001cGO\u0003\u0002\u001b7\u0005A1m\u001c8ue\u0006\u001cGO\u0003\u0002\u001d;\u00059!OZ29mI\n$B\u0001\u0010 \u0003\u0011QW.\u00199\u000b\u0005\u0001\n\u0013!\u00026b[\u0016\u001c(B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001OA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#A\u0018\u0011\u0005!\u0002\u0014BA\u0019*\u0005\u0011)f.\u001b;\u0002\u001fU#6i\u0018#B)\u0016{fi\u0014*N\u0003R+\u0012\u0001\u000e\t\u0003kqj\u0011A\u000e\u0006\u0003oa\naAZ8s[\u0006$(BA\u001d;\u0003\u0011!\u0018.\\3\u000b\u0003m\nAA[1wC&\u0011QH\u000e\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\u0018!B:fiV\u0003HCA\u0018A\u0011\u0015\t5\u00011\u0001C\u0003\u0019\u0019XM\u001d<feB\u00111\tR\u0007\u0002?%\u0011Qi\b\u0002\u0011\u000fVL7-\u001a&b[\u0016\u001c8+\u001a:wKJD#aA$\u0011\u0005!{U\"A%\u000b\u0005)[\u0015aA1qS*\u0011A*T\u0001\bUV\u0004\u0018\u000e^3s\u0015\tq5%A\u0003kk:LG/\u0003\u0002Q\u0013\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001fI\fg\u000eZ8n\u001b\u0016\u001c8/Y4f\u0013\u0012,\u0012a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bQ!\\8eK2T!\u0001W\u0010\u0002\u000f5\f\u0017\u000e\u001c2pq&\u0011!,\u0016\u0002\n\u001b\u0016\u001c8/Y4f\u0013\u0012\fqB]1oI>lW*Y5mE>D\u0018\nZ\u000b\u0002;B\u0011AKX\u0005\u0003?V\u0013\u0011\"T1jY\n|\u00070\u00133\u0002q%l\u0007o\u001c:u'\"|W\u000f\u001c3SKR,(O\\+oW:|wO\\'fi\"|Gm\u00165f]6K7o]5oO\u000e{'/Z\"ba\u0006\u0014\u0017\u000e\\5us\"\u0012aA\u0019\t\u0003\u0011\u000eL!\u0001Z%\u0003\tQ+7\u000f^\u00019S6\u0004xN\u001d;TQ>,H\u000e\u001a*fiV\u0014h.\u00168l]><h.T3uQ>$w\u000b[3o\u001b&\u001c8/\u001b8h\u001b\u0006LGnQ1qC\nLG.\u001b;zQ\t9!-\u0001\u0012j[B|'\u000f^*i_VdG-\u00113e)\",W*Y5m\u0013:$\u0006.Z'bS2\u0014w\u000e\u001f\u000b\u0003_%DQ!\u0011\u0005A\u0002\tC#\u0001\u00032\u0002G%l\u0007o\u001c:u'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3XQ\u0016tW)\u001c9us.+\u0017p^8sIR\u0011q&\u001c\u0005\u0006\u0003&\u0001\rA\u0011\u0015\u0003\u0013\t\f\u0001%[7q_J$8\u000b[8vY\u0012\u001cVoY2fK\u0012<\u0006.\u001a8O_.+\u0017p^8sIR\u0011q&\u001d\u0005\u0006\u0003*\u0001\rA\u0011\u0015\u0003\u0015\t\f1%[7q_J$8\u000b[8vY\u0012\u001cVoY2fK\u0012<\u0006.\u001a8O_J+7-Z5wK\u0012\fE\u000f\u0006\u00020k\")\u0011i\u0003a\u0001\u0005\"\u00121BY\u0001\u001aS6\u0004xN\u001d;TQ>,H\u000eZ#oM>\u00148-Z)v_R\f7\u000f\u0006\u00020s\")\u0011\t\u0004a\u0001\u0005\"\u0012ABY\u0001$S6\u0004xN\u001d;TQ>,H\u000eZ!eIRCW-T1jYNLe\u000e\u00165f\u001b\u0006LGNY8y)\tyS\u0010C\u0003B\u001b\u0001\u0007!\t\u000b\u0002\u000eE\u0006\t\u0013.\u001c9peR\u001c\u0006n\\;mI\u0012K7\u000f\u001d7bs>cG-\u00118e\u001d\u0016<8\u000b^1uKR\u0019q&a\u0001\t\u000b\u0005s\u0001\u0019\u0001\")\u00059\u0011\u0017A\u0005:fiJLWM^3F[\u0006LGn\u0015;bi\u0016,\"!a\u0003\u0011\t\u00055\u00111\u0004\b\u0005\u0003\u001f\t9\u0002E\u0002\u0002\u0012%j!!a\u0005\u000b\u0007\u0005UQ%\u0001\u0004=e>|GOP\u0005\u0004\u00033I\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005}!AB*ue&twMC\u0002\u0002\u001a%\n1%[7q_J$8\u000b[8vY\u00124\u0015-\u001b7XQ\u0016tW*Y5mE>Dhj\u001c;Po:,G\rF\u00020\u0003KAQ!\u0011\tA\u0002\tC#\u0001\u00052\u0002O%l\u0007o\u001c:u'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3XQ\u0016tW*Y5mE>DH)\u001a7fO\u0006$X\r\u001a\u000b\u0004_\u00055\u0002\"B!\u0012\u0001\u0004\u0011\u0005FA\tc\u0003\u0001JW\u000e]8siNCw.\u001e7e\r\u0006LGn\u00165f]\ncwN\u0019(pi>;h.\u001a3\u0015\u0007=\n)\u0004C\u0003B%\u0001\u0007!\t\u000b\u0002\u0013E\u0006!\u0013.\u001c9peR\u001c\u0006n\\;mIN+8mY3fI^CWM\u001c\"m_\n$U\r\\3hCR,G\rF\u00020\u0003{AQ!Q\nA\u0002\tC#a\u00052\u0002?%l\u0007o\u001c:u'\"|W\u000f\u001c3GC&dw\u000b[3o\u001d>l\u0015-\u001b7c_b,7\u000f\u000b\u0002\u0015E\u0006!\u0013.\u001c9peR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:$vn\\'b]fl\u0015-\u001b7c_b,7\u000f\u000b\u0002\u0016E\u0006\u0001\u0013.\u001c9peR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:\u0014En\u001c2O_R4u.\u001e8e)\ry\u0013Q\n\u0005\u0006\u0003Z\u0001\rA\u0011\u0015\u0003-\t\fA%[7q_J$8\u000b[8vY\u00124\u0015-\u001b7XQ\u0016t\u0017J\u001c<bY&$\u0017iY2pk:$\u0018\n\u001a\u000b\u0004_\u0005U\u0003\"B!\u0018\u0001\u0004\u0011\u0005FA\fc\u0001")
public interface EmailImportContract {
    public static /* synthetic */ DateTimeFormatter org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT$(EmailImportContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT();
    }

    default public DateTimeFormatter org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX");
    }

    public static /* synthetic */ void setUp$(EmailImportContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public MessageId randomMessageId();

    public MailboxId randomMailboxId();

    public static /* synthetic */ void importShouldReturnUnknownMethodWhenMissingCoreCapability$(EmailImportContract $this) {
        $this.importShouldReturnUnknownMethodWhenMissingCoreCapability();
    }

    @Test
    default public void importShouldReturnUnknownMethodWhenMissingCoreCapability() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\n              |      \"Email/import\",\n              |      {\n              |        \"arg1\": \"arg1data\",\n              |        \"arg2\": \"arg2data\"\n              |      },\n              |      \"c1\"\n              |    ]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:core\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void importShouldReturnUnknownMethodWhenMissingMailCapability$(EmailImportContract $this) {
        $this.importShouldReturnUnknownMethodWhenMissingMailCapability();
    }

    @Test
    default public void importShouldReturnUnknownMethodWhenMissingMailCapability() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\"],\n              |  \"methodCalls\": [\n              |    [\n              |      \"Email/import\",\n              |      {\n              |        \"arg1\": \"arg1data\",\n              |        \"arg2\": \"arg2data\"\n              |      },\n              |      \"c1\"\n              |    ]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mail\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void importShouldAddTheMailInTheMailbox$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldAddTheMailInTheMailbox(server);
    }

    @Test
    default public void importShouldAddTheMailInTheMailbox(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"],\n              |    [\"Email/get\",\n              |     {\n              |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |       \"ids\": [\"#C42\"],\n              |       \"properties\": [\"keywords\", \"mailboxIds\", \"receivedAt\", \"subject\", \"size\", \"bodyValues\", \"htmlBody\"],\n              |       \"fetchHTMLBodyValues\": true\n              |     },\n              |     \"c2\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsLookupResult responseAsJson = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42");
        String messageId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(responseAsJson), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    [\n         |        [\"Email/import\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"created\": {\n         |                    \"C42\": {\n         |                        \"id\": \"" + messageId + "\",\n         |                        \"blobId\": \"" + messageId + "\",\n         |                        \"threadId\": \"" + messageId + "\",\n         |                        \"size\": 836\n         |                    }\n         |                }\n         |            }, \"c1\"],\n         |        [\"Email/get\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"notFound\": [],\n         |                \"list\": [\n         |                    {\n         |                        \"id\": \"" + messageId + "\",\n         |                        \"htmlBody\": [\n         |                            {\n         |                                \"charset\": \"utf-8\",\n         |                                \"size\": 39,\n         |                                \"partId\": \"2\",\n         |                                \"blobId\": \"" + messageId + "_2\",\n         |                                \"type\": \"text/html\"\n         |                            }\n         |                        ],\n         |                        \"size\": 836,\n         |                        \"keywords\": {\n         |                            \"toto\": true\n         |                        },\n         |                        \"subject\": \"MultiAttachment\",\n         |                        \"mailboxIds\": {\n         |                            \"" + mailboxId.serialize() + "\": true\n         |                        },\n         |                        \"receivedAt\": \"" + receivedAtString + "\",\n         |                        \"bodyValues\": {\n         |                            \"2\": {\n         |                                \"value\": \"<p>Send<br/>concerted from html</p>\\r\\n\\r\\n\",\n         |                                \"isEncodingProblem\": false,\n         |                                \"isTruncated\": false\n         |                            }\n         |                        }\n         |                    }\n         |                ]\n         |            }, \"c2\"]\n         |    ]")));
    }

    public static /* synthetic */ void importShouldSucceedWhenEmptyKeyword$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldSucceedWhenEmptyKeyword(server);
    }

    @Test
    default public void importShouldSucceedWhenEmptyKeyword(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {},\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"],\n              |    [\"Email/get\",\n              |     {\n              |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |       \"ids\": [\"#C42\"],\n              |       \"properties\": [\"keywords\", \"mailboxIds\", \"receivedAt\", \"subject\", \"size\", \"bodyValues\", \"htmlBody\"],\n              |       \"fetchHTMLBodyValues\": true\n              |     },\n              |     \"c2\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsLookupResult responseAsJson = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42");
        String messageId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(responseAsJson), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    [\n         |        [\"Email/import\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"created\": {\n         |                    \"C42\": {\n         |                        \"id\": \"" + messageId + "\",\n         |                        \"blobId\": \"" + messageId + "\",\n         |                        \"threadId\": \"" + messageId + "\",\n         |                        \"size\": 836\n         |                    }\n         |                }\n         |            }, \"c1\"],\n         |        [\"Email/get\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"notFound\": [],\n         |                \"list\": [\n         |                    {\n         |                        \"id\": \"" + messageId + "\",\n         |                        \"htmlBody\": [\n         |                            {\n         |                                \"charset\": \"utf-8\",\n         |                                \"size\": 39,\n         |                                \"partId\": \"2\",\n         |                                \"blobId\": \"" + messageId + "_2\",\n         |                                \"type\": \"text/html\"\n         |                            }\n         |                        ],\n         |                        \"size\": 836,\n         |                        \"keywords\": {},\n         |                        \"subject\": \"MultiAttachment\",\n         |                        \"mailboxIds\": {\n         |                            \"" + mailboxId.serialize() + "\": true\n         |                        },\n         |                        \"receivedAt\": \"" + receivedAtString + "\",\n         |                        \"bodyValues\": {\n         |                            \"2\": {\n         |                                \"value\": \"<p>Send<br/>concerted from html</p>\\r\\n\\r\\n\",\n         |                                \"isEncodingProblem\": false,\n         |                                \"isTruncated\": false\n         |                            }\n         |                        }\n         |                    }\n         |                ]\n         |            }, \"c2\"]\n         |    ]")));
    }

    public static /* synthetic */ void importShouldSucceedWhenNoKeyword$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldSucceedWhenNoKeyword(server);
    }

    @Test
    default public void importShouldSucceedWhenNoKeyword(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"],\n              |    [\"Email/get\",\n              |     {\n              |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |       \"ids\": [\"#C42\"],\n              |       \"properties\": [\"keywords\", \"mailboxIds\", \"receivedAt\", \"subject\", \"size\", \"bodyValues\", \"htmlBody\"],\n              |       \"fetchHTMLBodyValues\": true\n              |     },\n              |     \"c2\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsLookupResult responseAsJson = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42");
        String messageId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(responseAsJson), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    [\n         |        [\"Email/import\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"created\": {\n         |                    \"C42\": {\n         |                        \"id\": \"" + messageId + "\",\n         |                        \"blobId\": \"" + messageId + "\",\n         |                        \"threadId\": \"" + messageId + "\",\n         |                        \"size\": 836\n         |                    }\n         |                }\n         |            }, \"c1\"],\n         |        [\"Email/get\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"notFound\": [],\n         |                \"list\": [\n         |                    {\n         |                        \"id\": \"" + messageId + "\",\n         |                        \"htmlBody\": [\n         |                            {\n         |                                \"charset\": \"utf-8\",\n         |                                \"size\": 39,\n         |                                \"partId\": \"2\",\n         |                                \"blobId\": \"" + messageId + "_2\",\n         |                                \"type\": \"text/html\"\n         |                            }\n         |                        ],\n         |                        \"size\": 836,\n         |                        \"keywords\": {},\n         |                        \"subject\": \"MultiAttachment\",\n         |                        \"mailboxIds\": {\n         |                            \"" + mailboxId.serialize() + "\": true\n         |                        },\n         |                        \"receivedAt\": \"" + receivedAtString + "\",\n         |                        \"bodyValues\": {\n         |                            \"2\": {\n         |                                \"value\": \"<p>Send<br/>concerted from html</p>\\r\\n\\r\\n\",\n         |                                \"isEncodingProblem\": false,\n         |                                \"isTruncated\": false\n         |                            }\n         |                        }\n         |                    }\n         |                ]\n         |            }, \"c2\"]\n         |    ]")));
    }

    public static /* synthetic */ void importShouldSucceedWhenNoReceivedAt$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldSucceedWhenNoReceivedAt(server);
    }

    @Test
    default public void importShouldSucceedWhenNoReceivedAt(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             }\n              |           }\n              |         }\n              |      },\n              |      \"c1\"],\n              |    [\"Email/get\",\n              |     {\n              |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |       \"ids\": [\"#C42\"],\n              |       \"properties\": [\"keywords\", \"mailboxIds\", \"receivedAt\", \"subject\", \"size\", \"bodyValues\", \"htmlBody\"],\n              |       \"fetchHTMLBodyValues\": true\n              |     },\n              |     \"c2\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsLookupResult responseAsJson = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42");
        String messageId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(responseAsJson), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    [\n         |        [\"Email/import\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"created\": {\n         |                    \"C42\": {\n         |                        \"id\": \"" + messageId + "\",\n         |                        \"blobId\": \"" + messageId + "\",\n         |                        \"threadId\": \"" + messageId + "\",\n         |                        \"size\": 836\n         |                    }\n         |                }\n         |            }, \"c1\"],\n         |        [\"Email/get\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"notFound\": [],\n         |                \"list\": [\n         |                    {\n         |                        \"id\": \"" + messageId + "\",\n         |                        \"htmlBody\": [\n         |                            {\n         |                                \"charset\": \"utf-8\",\n         |                                \"size\": 39,\n         |                                \"partId\": \"2\",\n         |                                \"blobId\": \"" + messageId + "_2\",\n         |                                \"type\": \"text/html\"\n         |                            }\n         |                        ],\n         |                        \"size\": 836,\n         |                        \"keywords\": {},\n         |                        \"subject\": \"MultiAttachment\",\n         |                        \"mailboxIds\": {\n         |                            \"" + mailboxId.serialize() + "\": true\n         |                        },\n         |                        \"receivedAt\": \"${json-unit.ignore}\",\n         |                        \"bodyValues\": {\n         |                            \"2\": {\n         |                                \"value\": \"<p>Send<br/>concerted from html</p>\\r\\n\\r\\n\",\n         |                                \"isEncodingProblem\": false,\n         |                                \"isTruncated\": false\n         |                            }\n         |                        }\n         |                    }\n         |                ]\n         |            }, \"c2\"]\n         |    ]")));
    }

    public static /* synthetic */ void importShouldEnforceQuotas$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldEnforceQuotas(server);
    }

    @Test
    default public void importShouldEnforceQuotas(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        quotaProbe.setMaxMessageCount(quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB())), QuotaCountLimit.count((long)0L));
        MailboxId id1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:apache:james:params:jmap:mail:shares\"],\n         |  \"methodCalls\": [[\"Email/import\", {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |        \"emails\": {\n         |           \"C42\": {\n         |             \"blobId\": \"" + blobId + "\",\n         |             \"mailboxIds\": {\n         |               \"" + id1.serialize() + "\": true\n         |             },\n         |             \"keywords\": {\n         |               \"toto\": true\n         |             },\n         |             \"receivedAt\": \"" + receivedAtString + "\"\n         |           }\n         |         }\n         |      }, \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState", "methodResponses[0][1].oldState"}).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\"Email/import\", {\n           |\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\"notCreated\": {\n           |\t\t\t\t\"C42\": {\n           |\t\t\t\t\t\"type\": \"overQuota\",\n           |\t\t\t\t\t\"description\": \"You have too many messages in #private&bob@domain.tld\"\n           |\t\t\t\t}\n           |\t\t\t}\n           |\t\t}, \"c1\"]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void importShouldAddTheMailsInTheMailbox$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldAddTheMailsInTheMailbox(server);
    }

    @Test
    default public void importShouldAddTheMailsInTheMailbox(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse1 = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String uploadResponse2 = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/html.eml")).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId1 = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse1)), "blobId").get()).value();
        String blobId2 = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse2)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId1 + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           },\n              |           \"C43\": {\n              |             \"blobId\": \"" + blobId2 + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"],\n              |    [\"Email/get\",\n              |     {\n              |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |       \"ids\": [\"#C42\", \"#C43\"],\n              |       \"properties\": [\"subject\"],\n              |       \"fetchHTMLBodyValues\": true\n              |     },\n              |     \"c2\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String messageId1 = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42")), "id").get()).value();
        String messageId2 = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C43")), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n         |        [\n         |            \"Email/import\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"created\": {\n         |                    \"C42\": {\n         |                        \"id\": \"" + messageId1 + "\",\n         |                        \"blobId\": \"" + messageId1 + "\",\n         |                        \"threadId\": \"" + messageId1 + "\",\n         |                        \"size\": 836\n         |                    },\n         |                    \"C43\": {\n         |                        \"id\": \"" + messageId2 + "\",\n         |                        \"blobId\": \"" + messageId2 + "\",\n         |                        \"threadId\": \"" + messageId1 + "\",\n         |                        \"size\": 2727\n         |                    }\n         |                }\n         |            },\n         |            \"c1\"\n         |        ],\n         |        [\n         |            \"Email/get\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"notFound\": [],\n         |                \"list\": [\n         |                    {\n         |                        \"subject\": \"MultiAttachment\",\n         |                        \"id\": \"" + messageId1 + "\"\n         |                    },\n         |                    {\n         |                        \"subject\": \"MultiAttachment\",\n         |                        \"id\": \"" + messageId2 + "\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c2\"\n         |        ]\n         |    ]")));
    }

    public static /* synthetic */ void importShouldDisplayOldAndNewState$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldDisplayOldAndNewState(server);
    }

    @Test
    default public void importShouldDisplayOldAndNewState(GuiceJamesServer server) {
        String oldState = this.retrieveEmailState();
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String newState = this.retrieveEmailState();
        String importOldState = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "oldState").get()).value();
        String importNewState = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "newState").get()).value();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(importOldState).isEqualTo(oldState);
            softly.assertThat(importNewState).isEqualTo(newState);
        });
    }

    public static /* synthetic */ String retrieveEmailState$(EmailImportContract $this) {
        return $this.retrieveEmailState();
    }

    default public String retrieveEmailState() {
        return (String)((Validatable)RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |  \"urn:ietf:params:jmap:core\",\n         |  \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |    [\"Email/get\", {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\":[]\n         |    }, \"c1\"]\n         |  ]\n         |}"))).post()).then().extract().jsonPath().get("methodResponses[0][1].state");
    }

    public static /* synthetic */ void importShouldFailWhenMailboxNotOwned$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldFailWhenMailboxNotOwned(server);
    }

    @Test
    default public void importShouldFailWhenMailboxNotOwned(GuiceJamesServer server) {
        MailboxPath alicePath = MailboxPath.inbox((Username)Fixture$.MODULE$.ALICE());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(alicePath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body("whatever").when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |    \"notCreated\":{\n           |      \"C42\":{\n           |        \"type\":\"notFound\",\n           |        \"description\":\"Mailbox " + mailboxId + " can not be found\"\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void importShouldSucceedWhenMailboxDelegated$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldSucceedWhenMailboxDelegated(server);
    }

    @Test
    default public void importShouldSucceedWhenMailboxDelegated(GuiceJamesServer server) {
        MailboxPath andrePath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andrePath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andrePath, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Insert, MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(ClassLoader.getSystemResourceAsStream("eml/alternative.eml")).when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsLookupResult responseAsJson = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42");
        String messageId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(responseAsJson), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n           |    \"created\":{\n           |      \"C42\":{\n           |        \"id\":\"" + messageId + "\",\n           |        \"blobId\":\"" + messageId + "\",\n           |        \"threadId\":\"" + messageId + "\",\n           |        \"size\":836\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void importShouldFailWhenBlobNotOwned$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldFailWhenBlobNotOwned(server);
    }

    @Test
    default public void importShouldFailWhenBlobNotOwned(GuiceJamesServer server) {
        MailboxPath andrePath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andrePath);
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId bobId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), andrePath, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        String blobId = messageId.serialize();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + bobId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |    \"notCreated\":{\n           |      \"C42\":{\n           |        \"type\":\"notFound\",\n           |        \"description\":\"Blob BlobId(" + blobId + ") could not be found\"\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void importShouldSucceedWhenBlobDelegated$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldSucceedWhenBlobDelegated(server);
    }

    @Test
    default public void importShouldSucceedWhenBlobDelegated(GuiceJamesServer server) {
        MailboxPath andrePath = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andrePath);
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId bobId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        String blobId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), andrePath, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andrePath, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Insert, MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + bobId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsLookupResult responseAsJson = JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "created")), "C42");
        String messageId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(responseAsJson), "id").get()).value();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n           |    \"created\":{\n           |      \"C42\":{\n           |        \"id\":\"" + messageId + "\",\n           |        \"blobId\":\"" + messageId + "\",\n           |        \"threadId\":\"" + messageId + "\",\n           |        \"size\":85\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void importShouldFailWhenNoMailboxes$(EmailImportContract $this) {
        $this.importShouldFailWhenNoMailboxes();
    }

    @Test
    default public void importShouldFailWhenNoMailboxes() {
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body("whatever").when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {},\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |    \"notCreated\":{\n           |      \"C42\":{\n           |        \"type\":\"invalidArguments\",\n           |        \"description\":\"Email/import so far only supports a single mailboxId\"\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void importShouldFailWhenTooManyMailboxes$(EmailImportContract $this) {
        $this.importShouldFailWhenTooManyMailboxes();
    }

    @Test
    default public void importShouldFailWhenTooManyMailboxes() {
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String uploadResponse = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body("whatever").when().post("/upload/" + Fixture$.MODULE$.ACCOUNT_ID(), new Object[0])).then().statusCode(201).extract().body().asString();
        String blobId = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(uploadResponse)), "blobId").get()).value();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + this.randomMailboxId().serialize() + "\": true,\n              |               \"" + this.randomMailboxId().serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState", "methodResponses[1][1].state"}).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"Email/import\",\n           |  {\n           |    \"accountId\":\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |    \"notCreated\":{\n           |      \"C42\":{\n           |        \"type\":\"invalidArguments\",\n           |        \"description\":\"Email/import so far only supports a single mailboxId\"\n           |      }\n           |    }\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void importShouldFailWhenBlobNotFound$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldFailWhenBlobNotFound(server);
    }

    @Test
    default public void importShouldFailWhenBlobNotFound(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String blobId = this.randomMessageId().serialize();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].oldState", "methodResponses[0][1].newState"}).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"accountId\":\"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n           |  \"notCreated\":{\n           |    \"C42\":{\n           |      \"type\":\"notFound\",\n           |      \"description\":\"Blob BlobId(" + blobId + ") could not be found\"\n           |    }\n           |  }\n           |}")));
    }

    public static /* synthetic */ void importShouldFailWhenInvalidAccountId$(EmailImportContract $this, GuiceJamesServer server) {
        $this.importShouldFailWhenInvalidAccountId(server);
    }

    @Test
    default public void importShouldFailWhenInvalidAccountId(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ZonedDateTime receivedAt = ZonedDateTime.now().minusDays(1L);
        String blobId = this.randomMessageId().serialize();
        String receivedAtString = new UTCDate(receivedAt).asUTC().format(this.org$apache$james$jmap$rfc8621$contract$EmailImportContract$$UTC_DATE_FORMAT());
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n              |  \"methodCalls\": [\n              |    [\"Email/import\",\n              |      {\n              |        \"accountId\": \"bad\",\n              |        \"emails\": {\n              |           \"C42\": {\n              |             \"blobId\": \"" + blobId + "\",\n              |             \"mailboxIds\": {\n              |               \"" + mailboxId.serialize() + "\": true\n              |             },\n              |             \"keywords\": {\n              |               \"toto\": true\n              |             },\n              |             \"receivedAt\": \"" + receivedAtString + "\"\n              |           }\n              |         }\n              |      },\n              |      \"c1\"]\n              |  ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)"[\"error\",{\"type\":\"accountNotFound\"},\"c1\"]");
    }

    public static void $init$(EmailImportContract $this) {
    }
}

