/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import jakarta.mail.Flags;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.JmapRequests$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsLookupResult$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005UfaB\u0010!!\u0003\r\t!\f\u0005\u0006i\u0001!\t!\u000e\u0005\ts\u0001A)\u0019!C\u0005u!A1\t\u0001EC\u0002\u0013%A\t\u0003\u0005N\u0001!\u0015\r\u0011\"\u0003E\u0011\u0015q\u0005A\"\u0001P\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015I\b\u0001\"\u0001{\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u00191\u00111\u0005\u0001\u0001\u0003KAq!a\n\u0010\t\u0003\tI\u0003\u0003\u0004o\u001f\u0011\u0005\u0011q\u0006\u0005\u0007k>!\t!!\u000e\t\u000f\u0005\rq\u0002\"\u0001\u0002<!9\u00111B\b\u0005\u0002\u0005\u0005\u0003bBA$\u001f\u0011\u0005\u0011\u0011\n\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!1\u0011q\u0010\u0001\u0005\u0002UBq!a!\u0001\t\u0003\t)\tC\u0004\u0002\f\u0002!I!!$\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\nQR)\\1jY\u000eC\u0017M\\4fg6+G\u000f[8e\u0007>tGO]1di*\u0011\u0011EI\u0001\tG>tGO]1di*\u00111\u0005J\u0001\be\u001a\u001c\u0007H\u000e\u001a2\u0015\t)c%\u0001\u0003k[\u0006\u0004(BA\u0014)\u0003\u0015Q\u0017-\\3t\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u00051\u0004CA\u00188\u0013\tA\u0004G\u0001\u0003V]&$\u0018!F:m_^\u0004\u0016mY3e!>dG.\u00138uKJ4\u0018\r\\\u000b\u0002wA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005i&lWMC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u0017\r\fG.\u001c7z\u0003^\f\u0017\u000e^\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005G>\u0014XM\u0003\u0002KU\u0005Q\u0011m^1ji&d\u0017\u000e^=\n\u00051;%\u0001E\"p]\u0012LG/[8o\r\u0006\u001cGo\u001c:z\u0003U\tw/Y5u\u0003Rlun\u001d;UK:\u001cVmY8oIN\fAb\u001d;bi\u00164\u0015m\u0019;pef,\u0012\u0001\u0015\t\u0003#fs!AU,\u000e\u0003MS!\u0001V+\u0002\r\rD\u0017M\\4f\u0015\t1F%A\u0002ba&L!\u0001W*\u0002\u000bM#\u0018\r^3\n\u0005i[&a\u0002$bGR|'/\u001f\u0006\u00031N\u000bQa]3u+B$\"A\u000e0\t\u000b}3\u0001\u0019\u00011\u0002\rM,'O^3s!\t\t'-D\u0001'\u0013\t\u0019gE\u0001\tHk&\u001cWMS1nKN\u001cVM\u001d<fe\"\u0012a!\u001a\t\u0003M2l\u0011a\u001a\u0006\u0003-\"T!!\u001b6\u0002\u000f),\b/\u001b;fe*\u00111NK\u0001\u0006UVt\u0017\u000e^\u0005\u0003[\u001e\u0014!BQ3g_J,W)Y2i\u0003\u0019*W.Y5m\u0007\"\fgnZ3t'\"|W\u000f\u001c3SKR,(O\\\"sK\u0006$X\rZ\"iC:<Wm\u001d\u000b\u0003mADQaX\u0004A\u0002\u0001D#a\u0002:\u0011\u0005\u0019\u001c\u0018B\u0001;h\u0005\u0011!Vm\u001d;\u0002e\u0015l\u0017-\u001b7DQ\u0006tw-Z:TQ>,H\u000e\u001a*fiV\u0014h.\u00169eCR,Gm\u00115b]\u001e,7o\u00165f]\u0006#GM\u00127bON$\"AN<\t\u000b}C\u0001\u0019\u00011)\u0005!\u0011\u0018AP:i_VdGMR1jY^KG\u000f[\"b]:|GoQ1mGVd\u0017\r^3DQ\u0006tw-Z:XQ\u0016t7+\u001b8hY\u0016\u001c\u0005.\u00198hK&\u001bHk\\8MCJ<W\r\u0006\u00027w\")q,\u0003a\u0001A\"\u0012\u0011B]\u0001#g\"|W\u000f\u001c3SKR,(O\\+qI\u0006$X\rZ,iK:lUm]:bO\u0016luN^3\u0015\u0005Yz\b\"B0\u000b\u0001\u0004\u0001\u0007F\u0001\u0006s\u0003U*W.Y5m\u0007\"\fgnZ3t'\"|W\u000f\u001c3SKR,(O\\+qI\u0006$X\rZ\"iC:<Wm],iK:\u0014V-\\8wK\u001ac\u0017mZ:\u0015\u0007Y\n9\u0001C\u0003`\u0017\u0001\u0007\u0001\r\u000b\u0002\fe\u0006AS-\\1jY\u000eC\u0017M\\4fgNCw.\u001e7e%\u0016$XO\u001d8EKN$(o\\=fI\u000eC\u0017M\\4fgR\u0019a'a\u0004\t\u000b}c\u0001\u0019\u00011)\u00051\u0011\u0018\u0001K3nC&d7\t[1oO\u0016\u001c8\u000b[8vY\u0012\u0014V\r^;s]\u0006cG\u000eV=qK>37\t[1oO\u0016\u001cHc\u0001\u001c\u0002\u0018!)q,\u0004a\u0001A\"\u0012QB]\u0001IK6\f\u0017\u000e\\\"iC:<Wm]*i_VdGMT8u%\u0016$XO\u001d8EkBd\u0017nY1uK\u0012LEm]!dGJ|7o]\"sK\u0006$X\rZ+qI\u0006$X\rZ(s\t\u0016\u001cHO]8zK\u0012$2ANA\u0010\u0011\u0015yf\u00021\u0001aQ\tq!O\u0001\bEK2,w-\u0019;j_:$Vm\u001d;\u0014\u0005=q\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0002,A\u0019\u0011QF\b\u000e\u0003\u0001!2ANA\u0019\u0011\u0015y\u0016\u00031\u0001aQ\t\t\"\u000fF\u00027\u0003oAQa\u0018\nA\u0002\u0001D#A\u0005:\u0015\u0007Y\ni\u0004C\u0003`'\u0001\u0007\u0001\r\u000b\u0002\u0014eR\u0019a'a\u0011\t\u000b}#\u0002\u0019\u00011)\u0005Q\u0011\u0018\u0001R3nC&d7\t[1oO\u0016\u001c8\u000b[8vY\u0012tu\u000e\u001e*fiV\u0014h.\u00169eCR,Gm\u00115b]\u001e,7o\u00165f]6K7o]5oONC\u0017M]3t\u0007\u0006\u0004\u0018MY5mSRLHc\u0001\u001c\u0002L!)q,\u0006a\u0001A\"\u0012QC\u001d\u0015\u0004\u001f\u0005E\u0003c\u00014\u0002T%\u0019\u0011QK4\u0003\r9+7\u000f^3e\u00039*W.Y5m\u0007\"\fgnZ3t'\"|W\u000f\u001c3SKR,(O\u001c%bg6{'/Z\"iC:<Wm],iK:$&/^3\u0015\u0007Y\nY\u0006C\u0003`-\u0001\u0007\u0001\r\u000b\u0002\u0017e\u0006\u0011S.\u0019=DQ\u0006tw-Z:TQ>,H\u000e\u001a\"f)\u0006\\WM\\%oi>\f5mY8v]R$2ANA2\u0011\u0015yv\u00031\u0001aQ\t9\"/A\u0019f[\u0006LGn\u00115b]\u001e,7o\u00155pk2$'+\u001a;ve:tun\u00115b]\u001e,7o\u00165f]:{g*Z<feN#\u0018\r^3\u0015\u0007Y\nY\u0007C\u0003`1\u0001\u0007\u0001\r\u000b\u0002\u0019e\u0006\u0011T-\\1jY\u000eC\u0017M\\4fgNCw.\u001e7e%\u0016$XO\u001d8ES\u001a4WM]3oiN#\u0018\r^3UQ\u0006tw\n\u001c3Ti\u0006$X\rF\u00027\u0003gBQaX\rA\u0002\u0001D#!\u0007:\u0002W\u0015l\u0017-\u001b7DQ\u0006tw-Z:TQ>,H\u000eZ#wK:$X/\u00197msJ+G/\u001e:o\u001d>\u001c\u0005.\u00198hKN$2ANA>\u0011\u0015y&\u00041\u0001aQ\tQ\"/A\u0016f[\u0006LGn\u00115b]\u001e,7o\u00155pk2$g)Y5m/\",g.Q2d_VtG/\u00133O_R4u.\u001e8eQ\tY\"/A\u0014f[\u0006LGn\u00115b]\u001e,7o\u00155pk2$g)Y5m/\",gn\u0015;bi\u0016tu\u000e\u001e$pk:$Gc\u0001\u001c\u0002\b\")q\f\ba\u0001A\"\u0012AD]\u0001\u0011o\u0006LGOR8s\u001d\u0016DHo\u0015;bi\u0016$\u0002\"a$\u0002\u0016\u0006]\u0015q\u0015\t\u0004%\u0006E\u0015bAAJ'\n)1\u000b^1uK\")q,\ba\u0001A\"9\u0011\u0011T\u000fA\u0002\u0005m\u0015!C1dG>,h\u000e^%e!\u0011\ti*a)\u000e\u0005\u0005}%bAAQ+\u0006)Qn\u001c3fY&!\u0011QUAP\u0005%\t5mY8v]RLE\rC\u0004\u0002*v\u0001\r!a$\u0002\u0019%t\u0017\u000e^5bYN#\u0018\r^3\u0002=]\f\u0017\u000e\u001e$pe:+\u0007\u0010^*uCR,w+\u001b;i\t\u0016dWmZ1uS>tG\u0003CAH\u0003_\u000b\t,a-\t\u000b}s\u0002\u0019\u00011\t\u000f\u0005ee\u00041\u0001\u0002\u001c\"9\u0011\u0011\u0016\u0010A\u0002\u0005=\u0005")
public interface EmailChangesMethodContract {
    public static /* synthetic */ Duration org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$slowPacedPollInterval$(EmailChangesMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$slowPacedPollInterval();
    }

    default public Duration org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$slowPacedPollInterval() {
        return Duration.ofMillis(100L);
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$calmlyAwait$(EmailChangesMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$calmlyAwait();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$calmlyAwait() {
        return Awaitility.with().pollInterval(this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$slowPacedPollInterval()).and().with().pollDelay(this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$slowPacedPollInterval()).await();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds$(EmailChangesMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds() {
        return this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$calmlyAwait().atMost(10L, TimeUnit.SECONDS);
    }

    public State.Factory stateFactory();

    public static /* synthetic */ void setUp$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addDomain("domain-alias.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void emailChangesShouldReturnCreatedChanges$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldReturnCreatedChanges(server);
    }

    @Test
    default public void emailChangesShouldReturnCreatedChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Email/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + State.INITIAL.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"created\": [\"" + messageId.serialize() + "\"],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void emailChangesShouldReturnUpdatedChangesWhenAddFlags$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldReturnUpdatedChangesWhenAddFlags(server);
    }

    @Test
    default public void emailChangesShouldReturnUpdatedChangesWhenAddFlags(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        State oldState = this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        JmapRequests$.MODULE$.markEmailAsSeen(messageId);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Email/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"created\": [],\n             |        \"updated\": [\"" + messageId.serialize() + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void shouldFailWithCannotCalculateChangesWhenSingleChangeIsTooLarge$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.shouldFailWithCannotCalculateChangesWhenSingleChangeIsTooLarge(server);
    }

    @Test
    default public void shouldFailWithCannotCalculateChangesWhenSingleChangeIsTooLarge(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId1 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        MessageId messageId2 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        MessageId messageId3 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        MessageId messageId4 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        MessageId messageId5 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        MessageId messageId6 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        State state6 = this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        String updateEmail = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |  [\"Email/set\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"update\": {\n         |        \"" + messageId1.serialize() + "\":{\n         |          \"keywords/$flagged\": true\n         |        },\n         |        \"" + messageId2.serialize() + "\":{\n         |          \"keywords/$flagged\": true\n         |        },\n         |        \"" + messageId3.serialize() + "\":{\n         |          \"keywords/$flagged\": true\n         |        },\n         |        \"" + messageId4.serialize() + "\":{\n         |          \"keywords/$flagged\": true\n         |        },\n         |        \"" + messageId5.serialize() + "\":{\n         |          \"keywords/$flagged\": true\n         |        },\n         |        \"" + messageId6.serialize() + "\":{\n         |          \"keywords/$flagged\": true\n         |        }\n         |      }\n         |    },\n         |    \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(updateEmail).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"sinceState\": \"" + state6.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n             |  \"error\",\n             |  {\n             |    \"type\": \"cannotCalculateChanges\",\n             |    \"description\": \"Current change collector limit 5 is exceeded by a single change, hence we cannot calculate changes.\"\n             |  },\n             |  \"c1\"\n             |]")));
        });
    }

    public static /* synthetic */ void shouldReturnUpdatedWhenMessageMove$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.shouldReturnUpdatedWhenMessageMove(server);
    }

    @Test
    default public void shouldReturnUpdatedWhenMessageMove(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        MailboxId mailboxId2 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2"));
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        State oldState = this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        String updateEmail = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |  [\"Email/set\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"update\": {\n         |        \"" + messageId.serialize() + "\":{\n         |          \"mailboxIds\": {\n         |            \"" + mailboxId2.serialize() + "\": true\n         |          }\n         |        }\n         |      }\n         |    },\n         |    \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(updateEmail).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |  \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |  \"oldState\": \"" + oldState.getValue() + "\",\n             |  \"hasMoreChanges\": false,\n             |  \"created\": [],\n             |  \"updated\": [\"" + messageId.serialize() + "\"],\n             |  \"destroyed\": []\n             |}")));
        });
    }

    public static /* synthetic */ void emailChangesShouldReturnUpdatedChangesWhenRemoveFlags$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldReturnUpdatedChangesWhenRemoveFlags(server);
    }

    @Test
    default public void emailChangesShouldReturnUpdatedChangesWhenRemoveFlags(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().withFlags(new Flags(Flags.Flag.SEEN)).build("header: value\r\n\r\nbody")).getMessageId();
        State oldState = this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        JmapRequests$.MODULE$.markEmailAsNotSeen(messageId);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Email/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"created\": [],\n             |        \"updated\": [\"" + messageId.serialize() + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void emailChangesShouldReturnDestroyedChanges$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldReturnDestroyedChanges(server);
    }

    @Test
    default public void emailChangesShouldReturnDestroyedChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        State oldState = this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        JmapRequests$.MODULE$.destroyEmail(messageId);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Email/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"created\": [],\n             |        \"updated\": [],\n             |        \"destroyed\": [\"" + messageId.serialize() + "\"]\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void emailChangesShouldReturnAllTypeOfChanges$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldReturnAllTypeOfChanges(server);
    }

    @Test
    default public void emailChangesShouldReturnAllTypeOfChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        MailboxPath path1 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path1);
        MailboxPath path2 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2");
        mailboxProbe.createMailbox(path2);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId1 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path2, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        State state1 = this.waitForNextState(server, accountId, State.INITIAL);
        MessageId messageId2 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path2, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        State oldState = this.waitForNextState(server, accountId, state1);
        MessageId messageId3 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path1, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        JmapRequests$.MODULE$.markEmailAsSeen(messageId1);
        JmapRequests$.MODULE$.destroyEmail(messageId2);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Email/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"created\": [\"" + messageId3.serialize() + "\"],\n             |        \"updated\": [\"" + messageId1.serialize() + "\"],\n             |        \"destroyed\": [\"" + messageId2.serialize() + "\"]\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void emailChangesShouldNotReturnDuplicatedIdsAccrossCreatedUpdatedOrDestroyed$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldNotReturnDuplicatedIdsAccrossCreatedUpdatedOrDestroyed(server);
    }

    @Test
    default public void emailChangesShouldNotReturnDuplicatedIdsAccrossCreatedUpdatedOrDestroyed(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId1 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        MessageId messageId2 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        MessageId messageId3 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        JmapRequests$.MODULE$.markEmailAsSeen(messageId2);
        JmapRequests$.MODULE$.destroyEmail(messageId3);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Email/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + State.INITIAL.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"created\": [\"" + messageId1.serialize() + "\", \"" + messageId2.serialize() + "\"],\n             |        \"updated\": [\"" + messageId2.serialize() + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void emailChangesShouldReturnHasMoreChangesWhenTrue$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldReturnHasMoreChangesWhenTrue(server);
    }

    @Test
    default public void emailChangesShouldReturnHasMoreChangesWhenTrue(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        String messageId1 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageId2 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageId3 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageId4 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageId5 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Email/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + State.INITIAL.getValue() + "\",\n             |        \"hasMoreChanges\": true,\n             |        \"created\": [\"" + messageId1 + "\", \"" + messageId2 + "\", \"" + messageId3 + "\", \"" + messageId4 + "\", \"" + messageId5 + "\"],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void maxChangesShouldBeTakenIntoAccount$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.maxChangesShouldBeTakenIntoAccount(server);
    }

    @Test
    default public void maxChangesShouldBeTakenIntoAccount(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        String messageId1 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageId2 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageId3 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageId4 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageId5 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageId6 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + State.INITIAL.getValue() + "\",\n         |      \"maxChanges\": 38\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Email/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + State.INITIAL.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"created\": [\"" + messageId1 + "\", \"" + messageId2 + "\", \"" + messageId3 + "\", \"" + messageId4 + "\", \"" + messageId5 + "\", \"" + messageId6 + "\"],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void emailChangesShouldReturnNoChangesWhenNoNewerState$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldReturnNoChangesWhenNoNewerState(server);
    }

    @Test
    default public void emailChangesShouldReturnNoChangesWhenNoNewerState(GuiceJamesServer server) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Email/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + State.INITIAL.getValue() + "\",\n             |        \"newState\": \"" + State.INITIAL.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"created\": [],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void emailChangesShouldReturnDifferentStateThanOldState$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldReturnDifferentStateThanOldState(server);
    }

    @Test
    default public void emailChangesShouldReturnDifferentStateThanOldState(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            String newState = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "newState").get()).value();
            Assertions.assertThat((String)State.INITIAL.getValue().toString()).isNotEqualTo((Object)newState);
        });
    }

    public static /* synthetic */ void emailChangesShouldEventuallyReturnNoChanges$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldEventuallyReturnNoChanges(server);
    }

    @Test
    default public void emailChangesShouldEventuallyReturnNoChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message));
        this.waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), State.INITIAL);
        String request1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response1 = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request1).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String newState = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response1)), "methodResponses")), 0)), 1)), "newState").get()).value();
        String request2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + newState + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response2 = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request2).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response2).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |      [ \"Email/changes\", {\n           |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |        \"oldState\": \"" + newState + "\",\n           |        \"newState\": \"" + newState + "\",\n           |        \"hasMoreChanges\": false,\n           |        \"created\": [],\n           |        \"updated\": [],\n           |        \"destroyed\": []\n           |      }, \"c1\"]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void emailChangesShouldFailWhenAccountIdNotFound$(EmailChangesMethodContract $this) {
        $this.emailChangesShouldFailWhenAccountIdNotFound();
    }

    @Test
    default public void emailChangesShouldFailWhenAccountIdNotFound() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"bad\",\n         |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"accountNotFound\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void emailChangesShouldFailWhenStateNotFound$(EmailChangesMethodContract $this, GuiceJamesServer server) {
        $this.emailChangesShouldFailWhenStateNotFound(server);
    }

    @Test
    default public void emailChangesShouldFailWhenStateNotFound(GuiceJamesServer server) {
        String state = this.stateFactory().generate().getValue().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Email/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + state + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |  \"methodResponses\": [[\n           |    \"error\", {\n           |      \"type\": \"cannotCalculateChanges\",\n           |      \"description\": \"State '" + state + "' could not be found\"\n           |    }, \"c1\"]\n           |  ]\n           |}")));
    }

    private State waitForNextState(GuiceJamesServer server, AccountId accountId, State initialState) {
        JmapGuiceProbe jmapGuiceProbe = (JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class);
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> Assertions.assertThat((Object)jmapGuiceProbe.getLatestEmailState(accountId)).isNotEqualTo((Object)initialState));
        return jmapGuiceProbe.getLatestEmailState(accountId);
    }

    public static /* synthetic */ State org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$waitForNextStateWithDelegation$(EmailChangesMethodContract $this, GuiceJamesServer server, AccountId accountId, State initialState) {
        return $this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$waitForNextStateWithDelegation(server, accountId, initialState);
    }

    default public State org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$waitForNextStateWithDelegation(GuiceJamesServer server, AccountId accountId, State initialState) {
        JmapGuiceProbe jmapGuiceProbe = (JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class);
        this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> Assertions.assertThat((Object)jmapGuiceProbe.getLatestEmailStateWithDelegation(accountId)).isNotEqualTo((Object)initialState));
        return jmapGuiceProbe.getLatestEmailStateWithDelegation(accountId);
    }

    public static void $init$(EmailChangesMethodContract $this) {
    }

    @Nested
    public class DelegationTest {
        @Test
        public void emailChangesShouldReturnCreatedChanges(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            mailboxProbe.createMailbox(path);
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
            MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Email/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$DelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Email/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + State.INITIAL.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"created\": [\"" + messageId.serialize() + "\"],\n               |        \"updated\": [],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        @Test
        public void emailChangesShouldReturnUpdatedChangesWhenAddFlags(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            mailboxProbe.createMailbox(path);
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
            MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
            State oldState = this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$DelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            JmapRequests$.MODULE$.markEmailAsSeen(messageId);
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Email/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldState.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$DelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Email/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + oldState.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"created\": [],\n               |        \"updated\": [\"" + messageId.serialize() + "\"],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        @Test
        public void emailChangesShouldReturnUpdatedChangesWhenRemoveFlags(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            mailboxProbe.createMailbox(path);
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().withFlags(new Flags(Flags.Flag.SEEN)).build("header: value\r\n\r\nbody")).getMessageId();
            State oldState = this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$DelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            JmapRequests$.MODULE$.markEmailAsNotSeen(messageId);
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Email/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldState.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$DelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Email/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + oldState.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"created\": [],\n               |        \"updated\": [\"" + messageId.serialize() + "\"],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        @Test
        public void emailChangesShouldReturnDestroyedChanges(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            mailboxProbe.createMailbox(path);
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
            MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
            State oldState = this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$DelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            JmapRequests$.MODULE$.destroyEmail(messageId);
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Email/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldState.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$DelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Email/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + oldState.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"created\": [],\n               |        \"updated\": [],\n               |        \"destroyed\": [\"" + messageId.serialize() + "\"]\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        @Test
        public void emailChangesShouldNotReturnUpdatedChangesWhenMissingSharesCapability(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            mailboxProbe.createMailbox(path);
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
            mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message));
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n           |  \"methodCalls\": [[\n           |    \"Email/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$DelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Email/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + State.INITIAL.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"created\": [],\n               |        \"updated\": [],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        public /* synthetic */ EmailChangesMethodContract org$apache$james$jmap$rfc8621$contract$EmailChangesMethodContract$DelegationTest$$$outer() {
            return EmailChangesMethodContract.this;
        }

        public DelegationTest() {
            if (EmailChangesMethodContract.this == null) {
                throw null;
            }
        }
    }
}

