/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.response.Validatable;
import io.restassured.specification.RequestSpecification;
import jakarta.mail.internet.SharedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.DownloadContract$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055v!B\u0012%\u0011\u0003\td!B\u001a%\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%\tA\u0010\u0005\u0007\u000f\u0006\u0001\u000b\u0011B \u0007\u000fM\"\u0003\u0013aA\u0001\u0011\")\u0011*\u0002C\u0001\u0015\")a*\u0002C\u0001\u001f\")\u0011-\u0002D\u0001E\")1.\u0002C\u0001Y\")!/\u0002C\u0001g\")a/\u0002C\u0001o\")!0\u0002C\u0001w\")a0\u0002C\u0001\u007f\"9\u0011QA\u0003\u0005\u0002\u0005\u001d\u0001bBA\u0007\u000b\u0011\u0005\u0011q\u0002\u0005\b\u0003+)A\u0011AA\f\u0011\u001d\ti\"\u0002C\u0001\u0003?Aq!!\n\u0006\t\u0003\t9\u0003C\u0004\u0002.\u0015!\t!a\f\t\u000f\u0005UR\u0001\"\u0001\u00028!9\u0011QH\u0003\u0005\u0002\u0005}\u0002bBA#\u000b\u0011\u0005\u0011q\t\u0005\b\u0003\u001b*A\u0011AA(\u0011\u001d\t)&\u0002C\u0001\u0003/Bq!!\u0018\u0006\t\u0003\ty\u0006C\u0004\u0002f\u0015!\t!a\u001a\t\u000f\u00055T\u0001\"\u0001\u0002p!9\u0011QO\u0003\u0005\u0002\u0005]\u0004bBA?\u000b\u0011\u0005\u0011q\u0010\u0005\b\u0003\u000b+A\u0011AAD\u0011\u001d\ti)\u0002C\u0001\u0003\u001fCq!!&\u0006\t\u0003\t9\nC\u0004\u0002\u001e\u0016!\t!a(\t\u000f\u0005\u0015V\u0001\"\u0001\u0002(\u0006\u0001Bi\\<oY>\fGmQ8oiJ\f7\r\u001e\u0006\u0003K\u0019\n\u0001bY8oiJ\f7\r\u001e\u0006\u0003O!\nqA\u001d4dqY\u0012\u0014G\u0003\u0002*U\u0005!!.\\1q\u0015\tYC&A\u0003kC6,7O\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001\u0001\t\u0003e\u0005i\u0011\u0001\n\u0002\u0011\t><h\u000e\\8bI\u000e{g\u000e\u001e:bGR\u001c\"!A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011'A\u0005bG\u000e|WO\u001c;JIV\tq\b\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006!A.\u00198h\u0015\u0005!\u0015\u0001\u00026bm\u0006L!AR!\u0003\rM#(/\u001b8h\u0003)\t7mY8v]RLE\rI\n\u0003\u000bU\na\u0001J5oSR$C#A&\u0011\u0005Yb\u0015BA'8\u0005\u0011)f.\u001b;\u0002\u000bM,G/\u00169\u0015\u0005-\u0003\u0006\"B)\b\u0001\u0004\u0011\u0016AB:feZ,'\u000f\u0005\u0002T)6\t!&\u0003\u0002VU\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u000f]\u0003\"\u0001W0\u000e\u0003eS!AW.\u0002\u0007\u0005\u0004\u0018N\u0003\u0002];\u00069!.\u001e9ji\u0016\u0014(B\u00010/\u0003\u0015QWO\\5u\u0013\t\u0001\u0017L\u0001\u0006CK\u001a|'/Z#bG\"\fqB]1oI>lW*Z:tC\u001e,\u0017\nZ\u000b\u0002GB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\u0006[>$W\r\u001c\u0006\u0003Q*\nq!\\1jY\n|\u00070\u0003\u0002kK\nIQ*Z:tC\u001e,\u0017\nZ\u0001\u0010I><h\u000e\\8bI6+7o]1hKR\u00111*\u001c\u0005\u0006#&\u0001\rA\u0015\u0015\u0003\u0013=\u0004\"\u0001\u00179\n\u0005EL&\u0001\u0002+fgR\f\u0011\u0004Z8x]2|\u0017\rZ'bS2\u0014w\u000e_!ui\u0006\u001c\u0007.\\3oiR\u00111\n\u001e\u0005\u0006#*\u0001\rA\u0015\u0015\u0003\u0015=\f1\u0006Z8x]2|\u0017\rZ'fgN\fw-Z*i_VdGMR1jY^CWM\\+oCV$\b.\u001a8uS\u001aLW\r\u001a\u000b\u0003\u0017bDQ!U\u0006A\u0002IC#aC8\u0002[\u0011|wO\u001c7pC\u0012lUm]:bO\u0016\u001c\u0006n\\;mIN+8mY3fI^CWM\\!eI\u0016$'+[4ii\u0006\u001bE\n\u0006\u0002Ly\")\u0011\u000b\u0004a\u0001%\"\u0012Ab\\\u0001(I><h\u000e\\8bI&twm\u0014;iKJ\u0004Vm\u001c9mK6+7o]1hKNCw.\u001e7e\r\u0006LG\u000eF\u0002L\u0003\u0003AQ!U\u0007A\u0002IC#!D8\u0002I\u0011|wO\u001c7pC\u0012LgnZ%o\u001fRDWM]!dG>,h\u000e^:TQ>,H\u000e\u001a$bS2$2aSA\u0005\u0011\u0015\tf\u00021\u0001SQ\tqq.\u0001\u0016e_^tGn\\1e!\u0006\u0014Ho\u00155pk2$7+^2dK\u0016$w\u000b[3o\u0003\u0012$W\r\u001a*jO\"$\u0018i\u0011'\u0015\u0007-\u000b\t\u0002C\u0003R\u001f\u0001\u0007!\u000b\u000b\u0002\u0010_\u0006YCm\\<oY>\fG-\u001b8h\u001fRDWM\u001d)f_BdW-T3tg\u0006<W\rU1siNCw.\u001e7e\r\u0006LG\u000eF\u0002L\u00033AQ!\u0015\tA\u0002IC#\u0001E8\u0002\u0019\u0011|wO\u001c7pC\u0012\u0004\u0016M\u001d;\u0015\u0007-\u000b\t\u0003C\u0003R#\u0001\u0007!\u000b\u000b\u0002\u0012_\u0006ySo]3s\u0007\u0006t7\u000b]3dS\u001aL8i\u001c8uK:$H+\u001f9f/\",g\u000eR8x]2|\u0017\rZ5oO6+7o]1hKR\u00191*!\u000b\t\u000bE\u0013\u0002\u0019\u0001*)\u0005Iy\u0017\u0001L;tKJ\u001c\u0015M\\*qK\u000eLg-_\"p]R,g\u000e\u001e+za\u0016<\u0006.\u001a8E_^tGn\\1eS:<\u0007+\u0019:u)\rY\u0015\u0011\u0007\u0005\u0006#N\u0001\rA\u0015\u0015\u0003'=\fq\u0007Z8x]2|\u0017\r\u001a)beR\u001c\u0006n\\;mI\u0012K7oY1sI:\u000bW.Z,iK:tu\u000e^*vaBd\u0017.\u001a3CsRCWm\u00117jK:$HcA&\u0002:!)\u0011\u000b\u0006a\u0001%\"\u0012Ac\\\u0001&kN,'oQ1o'B,7-\u001b4z\u001d\u0006lWm\u00165f]\u0012{wO\u001c7pC\u0012Lgn\u001a)beR$2aSA!\u0011\u0015\tV\u00031\u0001SQ\t)r.\u0001\u001ee_^tGn\\1e\u001b\u0016\u001c8/Y4f'\"|W\u000f\u001c3ESN\u001c\u0017M\u001d3OC6,w\u000b[3o\u001d>$8+\u001e9qY&,GMQ=UQ\u0016\u001cE.[3oiR\u00191*!\u0013\t\u000bE3\u0002\u0019\u0001*)\u0005Yy\u0017\u0001K;tKJ\u001c\u0015M\\*qK\u000eLg-\u001f(b[\u0016<\u0006.\u001a8E_^tGn\\1eS:<W*Z:tC\u001e,GcA&\u0002R!)\u0011k\u0006a\u0001%\"\u0012qc\\\u0001\u0018I><h\u000e\\8bI:{G/\u0012=jgRLgn\u001a)beR$2aSA-\u0011\u0015\t\u0006\u00041\u0001SQ\tAr.A\ne_^tGn\\1e\u0013:4\u0018\r\\5e!\u0006\u0014H\u000fF\u0002L\u0003CBQ!U\rA\u0002IC#!G8\u0002+\u0011|wO\u001c7pC\u0012<\u0016\u000e\u001e5J]Z\fG.\u001b3JIR\u00191*!\u001b\t\u000bES\u0002\u0019\u0001*)\u0005iy\u0017A\u00063po:dw.\u00193XSRDgj\u001c;G_VtG-\u00133\u0015\u0007-\u000b\t\bC\u0003R7\u0001\u0007!\u000b\u000b\u0002\u001c_\u0006yBm\\<oY>\fG\rU1si^CWM\\'fgN\fw-\u001a(pi\u001a{WO\u001c3\u0015\u0007-\u000bI\bC\u0003R9\u0001\u0007!\u000b\u000b\u0002\u001d_\u0006IBm\\<oY>\fG\rU1si^CWM\\'vYRL\u0007/\u0019:u)\rY\u0015\u0011\u0011\u0005\u0006#v\u0001\rA\u0015\u0015\u0003;=\f\u0011\u0005Z8x]2|\u0017\r\u001a)beR<\u0006.\u001a8U_>lUo\u00195V]\u0012,'o]2pe\u0016$2aSAE\u0011\u0015\tf\u00041\u0001SQ\tqr.\u0001\u0019e_^tGn\\1e\u001b\u0016\u001c8/Y4f'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3XQ\u0016tG)\u001a7fO\u0006$X\rZ!dG>,h\u000e\u001e\u000b\u0004\u0017\u0006E\u0005\"B) \u0001\u0004\u0011\u0006FA\u0010p\u0003A\"wn\u001e8m_\u0006$W*Z:tC\u001e,7\u000b[8vY\u00124\u0015-\u001b7XQ\u0016tgj\u001c;EK2,w-\u0019;fI\u0006\u001b7m\\;oiR\u00191*!'\t\u000bE\u0003\u0003\u0019\u0001*)\u0005\u0001z\u0017\u0001\u000e3po:dw.\u00193QCJ$X*Z:tC\u001e,7\u000b[8vY\u0012\u001cVoY2fK\u0012<\u0006.\u001a8EK2,w-\u0019;fI\u0006\u001b7m\\;oiR\u00191*!)\t\u000bE\u000b\u0003\u0019\u0001*)\u0005\u0005z\u0017A\n3po:dw.\u00193TQ>,H\u000e\u001a$bS2<\u0006.\u001a8F[\u0006LG\u000eU1si&sg/\u00197jIR\u00191*!+\t\u000bE\u0013\u0003\u0019\u0001*)\u0005\tz\u0007")
public interface DownloadContract {
    public static String accountId() {
        return DownloadContract$.MODULE$.accountId();
    }

    public static /* synthetic */ void setUp$(DownloadContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.CEDRIC().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public MessageId randomMessageId();

    public static /* synthetic */ void downloadMessage$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessage(server);
    }

    @Test
    default public void downloadMessage(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).contentType("message/rfc822").header("cache-control", "private, immutable, max-age=31536000").extract().body().asString();
        String expectedResponse = IOUtils.toString((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadMailboxAttachment$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMailboxAttachment(server);
    }

    @Test
    default public void downloadMailboxAttachment(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        AttachmentId attachmentId = ((MessageAttachmentMetadata)((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageRetrieveAppendResult(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageAttachments().get(1)).getAttachmentId();
        String response = ((Validatable)((RequestSpecification)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).log().all()).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + attachmentId.getId(), new Object[0])).then().statusCode(200).contentType("application/vnd.ms-publisher; name=\"text2\"").extract().body().asString();
        Assertions.assertThat((String)response).isEqualTo("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDHs8bT4T/8QymbsiAjlD1MwNIXJr/WET6+9MmuTSIYWWU94csDn9WVMzRhaAbpfnSqIx8TdUtrN/ZzX2JetPSar/bU9nXAWeiC/jPFQ1qKH4GeDrYXRLKu4T8782OrGH8Jyror97TlNXhPrjdRLEB4bQqmmZhb3HwcD8a9XzfZqlm7GRWLo1WQMGt/NpQLC7jMf4fA6/+kjzsTspxwdgL74GJqPfOXOiwgLHX8CZ6/5RyTqhT6pD3MktSNWaz/zIHPNEqf5BY9CBM1TFR5w+6MDHo0gmiIsXFEJTPnfhBvHDhSjB1RI0KxUClyYrJ4fBlUVeKfnawoVcu7YvCqF4F5 quynhnn@linagora\n");
    }

    public static /* synthetic */ void downloadMessageShouldFailWhenUnauthentified$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldFailWhenUnauthentified(server);
    }

    @Test
    default public void downloadMessageShouldFailWhenUnauthentified(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().auth().none().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(401).header("WWW-Authenticate", "Basic realm=\"simple\", Bearer realm=\"JWT\"").body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)401)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
    }

    public static /* synthetic */ void downloadMessageShouldSucceedWhenAddedRightACL$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldSucceedWhenAddedRightACL(server);
    }

    @Test
    default public void downloadMessageShouldSucceedWhenAddedRightACL(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read, MailboxACL.Right.Lookup}));
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).contentType("message/rfc822").extract().body().asString();
        String expectedResponse = IOUtils.toString((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadingOtherPeopleMessageShouldFail$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadingOtherPeopleMessageShouldFail(server);
    }

    @Test
    default public void downloadingOtherPeopleMessageShouldFail(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadingInOtherAccountsShouldFail$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadingInOtherAccountsShouldFail(server);
    }

    @Test
    default public void downloadingInOtherAccountsShouldFail(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ALICE_ACCOUNT_ID() + "/" + messageId.serialize(), new Object[0])).then().statusCode(403).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"You cannot download in others accounts"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartShouldSucceedWhenAddedRightACL$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartShouldSucceedWhenAddedRightACL(server);
    }

    @Test
    default public void downloadPartShouldSucceedWhenAddedRightACL(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read, MailboxACL.Right.Lookup}));
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).contentType("text/plain").extract().body().asString();
        String expectedResponse = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-----BEGIN RSA PRIVATE KEY-----\n        |MIIEogIBAAKCAQEAx7PG0+E//EMpm7IgI5Q9TMDSFya/1hE+vvTJrk0iGFllPeHL\n        |A5/VlTM0YWgG6X50qiMfE3VLazf2c19iXrT0mq/21PZ1wFnogv4zxUNaih+Bng62\n        |F0SyruE/O/Njqxh/Ccq6K/e05TV4T643USxAeG0KppmYW9x8HA/GvV832apZuxkV\n        |i6NVkDBrfzaUCwu4zH+HwOv/pI87E7KccHYC++Biaj3\n        |"));
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadingOtherPeopleMessagePartShouldFail$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadingOtherPeopleMessagePartShouldFail(server);
    }

    @Test
    default public void downloadingOtherPeopleMessagePartShouldFail(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPart(server);
    }

    @Test
    default public void downloadPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).contentType("text/plain").extract().body().asString();
        String expectedResponse = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-----BEGIN RSA PRIVATE KEY-----\n        |MIIEogIBAAKCAQEAx7PG0+E//EMpm7IgI5Q9TMDSFya/1hE+vvTJrk0iGFllPeHL\n        |A5/VlTM0YWgG6X50qiMfE3VLazf2c19iXrT0mq/21PZ1wFnogv4zxUNaih+Bng62\n        |F0SyruE/O/Njqxh/Ccq6K/e05TV4T643USxAeG0KppmYW9x8HA/GvV832apZuxkV\n        |i6NVkDBrfzaUCwu4zH+HwOv/pI87E7KccHYC++Biaj3\n        |"));
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void userCanSpecifyContentTypeWhenDownloadingMessage$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyContentTypeWhenDownloadingMessage(server);
    }

    @Test
    default public void userCanSpecifyContentTypeWhenDownloadingMessage(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("type", new Object[]{"text/plain"}).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).contentType("text/plain");
    }

    public static /* synthetic */ void userCanSpecifyContentTypeWhenDownloadingPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyContentTypeWhenDownloadingPart(server);
    }

    @Test
    default public void userCanSpecifyContentTypeWhenDownloadingPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("type", new Object[]{"text/markdown"}).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).contentType("text/markdown");
    }

    public static /* synthetic */ void downloadPartShouldDiscardNameWhenNotSuppliedByTheClient$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartShouldDiscardNameWhenNotSuppliedByTheClient(server);
    }

    @Test
    default public void downloadPartShouldDiscardNameWhenNotSuppliedByTheClient(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String contentDisposition = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).extract().header("Content-Disposition");
        Assertions.assertThat((String)contentDisposition).isNullOrEmpty();
    }

    public static /* synthetic */ void userCanSpecifyNameWhenDownloadingPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyNameWhenDownloadingPart(server);
    }

    @Test
    default public void userCanSpecifyNameWhenDownloadingPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("name", new Object[]{"gabouzomeuh.txt"}).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).header("Content-Disposition", Matchers.containsString((String)"filename=\"gabouzomeuh.txt\""));
    }

    public static /* synthetic */ void downloadMessageShouldDiscardNameWhenNotSuppliedByTheClient$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldDiscardNameWhenNotSuppliedByTheClient(server);
    }

    @Test
    default public void downloadMessageShouldDiscardNameWhenNotSuppliedByTheClient(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        String contentDisposition = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).extract().header("Content-Disposition");
        Assertions.assertThat((String)contentDisposition).isNullOrEmpty();
    }

    public static /* synthetic */ void userCanSpecifyNameWhenDownloadingMessage$(DownloadContract $this, GuiceJamesServer server) {
        $this.userCanSpecifyNameWhenDownloadingMessage(server);
    }

    @Test
    default public void userCanSpecifyNameWhenDownloadingMessage(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).queryParam("name", new Object[]{"gabouzomeuh.eml"}).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).header("Content-Disposition", Matchers.containsString((String)"filename=\"gabouzomeuh.eml\""));
    }

    public static /* synthetic */ void downloadNotExistingPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadNotExistingPart(server);
    }

    @Test
    default public void downloadNotExistingPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_333", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadInvalidPart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadInvalidPart(server);
    }

    @Test
    default public void downloadInvalidPart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_invalid", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadWithInvalidId$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadWithInvalidId(server);
    }

    @Test
    default public void downloadWithInvalidId(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/invalid", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadWithNotFoundId$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadWithNotFoundId(server);
    }

    @Test
    default public void downloadWithNotFoundId(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + this.randomMessageId().serialize(), new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartWhenMessageNotFound$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartWhenMessageNotFound(server);
    }

    @Test
    default public void downloadPartWhenMessageNotFound(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + this.randomMessageId().serialize() + "_3", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartWhenMultipart$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartWhenMultipart(server);
    }

    @Test
    default public void downloadPartWhenMultipart(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml")));
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + this.randomMessageId().serialize() + "_2", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartWhenTooMuchUnderscore$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartWhenTooMuchUnderscore(server);
    }

    @Test
    default public void downloadPartWhenTooMuchUnderscore(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageId.serialize() + "_3_3", new Object[0])).then().statusCode(404).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)404)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"The resource could not be found"), new Object[0]);
    }

    public static /* synthetic */ void downloadMessageShouldSucceedWhenDelegatedAccount$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldSucceedWhenDelegatedAccount(server);
    }

    @Test
    default public void downloadMessageShouldSucceedWhenDelegatedAccount(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "/" + messageId.serialize(), new Object[0])).then().statusCode(200).contentType("message/rfc822").extract().body().asString();
        String expectedResponse = IOUtils.toString((InputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadMessageShouldFailWhenNotDelegatedAccount$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadMessageShouldFailWhenNotDelegatedAccount(server);
    }

    @Test
    default public void downloadMessageShouldFailWhenNotDelegatedAccount(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.CEDRIC());
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "/" + messageId.serialize(), new Object[0])).then().statusCode(403).body("status", Matchers.equalTo((Object)BoxesRunTime.boxToInteger((int)403)), new Object[0]).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]).body("detail", Matchers.equalTo((Object)"You cannot download in others accounts"), new Object[0]);
    }

    public static /* synthetic */ void downloadPartMessageShouldSucceedWhenDelegatedAccount$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadPartMessageShouldSucceedWhenDelegatedAccount(server);
    }

    @Test
    default public void downloadPartMessageShouldSucceedWhenDelegatedAccount(GuiceJamesServer server) {
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), path, MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/multipart_simple.eml"))).getMessageId();
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String response = ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "/" + messageId.serialize() + "_3", new Object[0])).then().statusCode(200).contentType("text/plain").extract().body().asString();
        String expectedResponse = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-----BEGIN RSA PRIVATE KEY-----\n        |MIIEogIBAAKCAQEAx7PG0+E//EMpm7IgI5Q9TMDSFya/1hE+vvTJrk0iGFllPeHL\n        |A5/VlTM0YWgG6X50qiMfE3VLazf2c19iXrT0mq/21PZ1wFnogv4zxUNaih+Bng62\n        |F0SyruE/O/Njqxh/Ccq6K/e05TV4T643USxAeG0KppmYW9x8HA/GvV832apZuxkV\n        |i6NVkDBrfzaUCwu4zH+HwOv/pI87E7KccHYC++Biaj3\n        |"));
        Assertions.assertThat((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))).hasContent(expectedResponse);
    }

    public static /* synthetic */ void downloadShouldFailWhenEmailPartInvalid$(DownloadContract $this, GuiceJamesServer server) {
        $this.downloadShouldFailWhenEmailPartInvalid(server);
    }

    @Test
    default public void downloadShouldFailWhenEmailPartInvalid(GuiceJamesServer server) {
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MailboxPath path = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(path);
        String messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId().serialize();
        String messageAndInvalidPart = messageId + "_";
        ((Validatable)RestAssured.given().basePath("").header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/download/" + DownloadContract$.MODULE$.accountId() + "/" + messageAndInvalidPart, new Object[0])).then().statusCode(404).body(Matchers.containsString((String)"The resource could not be found"), new Matcher[0]);
    }

    public static void $init$(DownloadContract $this) {
    }
}

