/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.util.Collection;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.delegation.DelegationId$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.DelegatedAccountSetContract$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.probe.DelegationProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-<Qa\u0004\t\t\u0002u1Qa\b\t\t\u0002\u0001BQaJ\u0001\u0005\u0002!Bq!K\u0001C\u0002\u0013\u0005!\u0006\u0003\u00047\u0003\u0001\u0006Ia\u000b\u0004\b?A\u0001\n1!\u00018\u0011\u0015AT\u0001\"\u0001:\u0011\u0015iT\u0001\"\u0001?\u0011\u0015\u0001V\u0001\"\u0001R\u0011\u00159V\u0001\"\u0001Y\u0011\u0015YV\u0001\"\u0001]\u0011\u0015yV\u0001\"\u0001a\u0011\u0015\u0019W\u0001\"\u0001:\u0011\u0015)W\u0001\"\u0001g\u0011\u0015IW\u0001\"\u0001:\u0003m!U\r\\3hCR,G-Q2d_VtGoU3u\u0007>tGO]1di*\u0011\u0011CE\u0001\tG>tGO]1di*\u00111\u0003F\u0001\be\u001a\u001c\u0007H\u000e\u001a2\u0015\t)b#\u0001\u0003k[\u0006\u0004(BA\f\u0019\u0003\u0015Q\u0017-\\3t\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001A\u0011a$A\u0007\u0002!\tYB)\u001a7fO\u0006$X\rZ!dG>,h\u000e^*fi\u000e{g\u000e\u001e:bGR\u001c\"!A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ$\u0001\bC\u001f\n{\u0016iQ\"P+:#v,\u0013#\u0016\u0003-\u0002\"\u0001L\u001a\u000f\u00055\n\u0004C\u0001\u0018$\u001b\u0005y#B\u0001\u0019\u001d\u0003\u0019a$o\\8u}%\u0011!gI\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023G\u0005y!i\u0014\"`\u0003\u000e\u001bu*\u0016(U?&#\u0005e\u0005\u0002\u0006C\u00051A%\u001b8ji\u0012\"\u0012A\u000f\t\u0003EmJ!\u0001P\u0012\u0003\tUs\u0017\u000e^\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003u}BQ\u0001Q\u0004A\u0002\u0005\u000baa]3sm\u0016\u0014\bC\u0001\"D\u001b\u00051\u0012B\u0001#\u0017\u0005A9U/[2f\u0015\u0006lWm]*feZ,'\u000f\u000b\u0002\b\rB\u0011qIT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0004CBL'BA&M\u0003\u001dQW\u000f]5uKJT!!\u0014\u000e\u0002\u000b),h.\u001b;\n\u0005=C%A\u0003\"fM>\u0014X-R1dQ\u0006!C-\u001a7fO\u0006$X\rZ!dG>,h\u000e\u001e#fgR\u0014x._*i_VdGmU;dG\u0016,G\r\u0006\u0002;%\")\u0001\t\u0003a\u0001\u0003\"\u0012\u0001\u0002\u0016\t\u0003\u000fVK!A\u0016%\u0003\tQ+7\u000f^\u0001)[&DX\rZ\"bg\u0016\u001c\u0006n\\;mI\u0012+7\u000f\u001e:ps>sG.\u001f*fcV,7\u000f^3e\u000b:$(/\u001f\u000b\u0003ueCQ\u0001Q\u0005A\u0002\u0005C#!\u0003+\u0002\u0001\u0012,G.Z4bi\u0016$\u0017iY2pk:$H)Z:ue>L8\u000b[8vY\u00124\u0015-\u001b7XQ\u0016tW*[:tS:<G)\u001a7fO\u0006$\u0018n\u001c8DCB\f'-\u001b7jif$\"AO/\t\u000b\u0001S\u0001\u0019A!)\u0005)!\u0016!\u000b3fY\u0016<\u0017\r^3e\u0003\u000e\u001cw.\u001e8u\t\u0016\u001cHO]8z'\"|W\u000f\u001c3CK&#W-\u001c9pi\u0016tG\u000f\u0006\u0002;C\")\u0001i\u0003a\u0001\u0003\"\u00121\u0002V\u00017g\"|W\u000f\u001c3SKR,(O\u001c(pi\u001a{WO\u001c3XQ\u0016tGK]=U_\u0006\u001b7-Z:t\u001d>tG)\u001a7fO\u0006$X\rZ!dG>,h\u000e\u001e\u0015\u0003\u0019Q\u000b\u0001FY8c\u0007\u0006twJ\u001c7z\u001b\u0006t\u0017mZ3ISN\u0004&/[7bef\f5mY8v]R\u001cV\r\u001e;j]\u001e$\"AO4\t\u000b\u0001k\u0001\u0019A!)\u00055!\u0016A\b3fgR\u0014x._*i_VdGMR1jY^CWM\\%om\u0006d\u0017\u000eZ%eQ\tqA\u000b")
public interface DelegatedAccountSetContract {
    public static String BOB_ACCOUNT_ID() {
        return DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID();
    }

    public static /* synthetic */ void setUp$(DelegatedAccountSetContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD()).addUser(Fixture$.MODULE$.CEDRIC().asString(), "secret");
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void delegatedAccountDestroyShouldSucceed$(DelegatedAccountSetContract $this, GuiceJamesServer server) {
        $this.delegatedAccountDestroyShouldSucceed(server);
    }

    @Test
    default public void delegatedAccountDestroyShouldSucceed(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String andreToBobDelegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB()).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"DelegatedAccount/set\", {\n         |\t\t\t\t\"accountId\": \"" + DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |\t\t\t\t\"destroy\": [\"" + andreToBobDelegationId + "\"]\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"DelegatedAccount/set\",\n           |            {\n           |                \"accountId\": \"" + DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n           |                \"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |                \"destroyed\": [\"" + andreToBobDelegationId + "\"]\n           |            },\n           |            \"0\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(((DelegationProbe)server.getProbe(DelegationProbe.class)).getDelegatedUsers(Fixture$.MODULE$.BOB())).asJavaCollection()).isEmpty();
    }

    public static /* synthetic */ void mixedCaseShouldDestroyOnlyRequestedEntry$(DelegatedAccountSetContract $this, GuiceJamesServer server) {
        $this.mixedCaseShouldDestroyOnlyRequestedEntry(server);
    }

    @Test
    default public void mixedCaseShouldDestroyOnlyRequestedEntry(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.CEDRIC(), Fixture$.MODULE$.BOB());
        String andreToBobDelegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB()).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"DelegatedAccount/set\", {\n         |\t\t\t\t\"accountId\": \"" + DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |\t\t\t\t\"destroy\": [\"" + andreToBobDelegationId + "\"]\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"DelegatedAccount/set\",\n           |            {\n           |                \"accountId\": \"" + DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n           |                \"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |                \"destroyed\": [\"" + andreToBobDelegationId + "\"]\n           |            },\n           |            \"0\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(((DelegationProbe)server.getProbe(DelegationProbe.class)).getDelegatedUsers(Fixture$.MODULE$.BOB())).asJavaCollection()).containsExactly((Object[])new Username[]{Fixture$.MODULE$.CEDRIC()});
    }

    public static /* synthetic */ void delegatedAccountDestroyShouldFailWhenMissingDelegationCapability$(DelegatedAccountSetContract $this, GuiceJamesServer server) {
        $this.delegatedAccountDestroyShouldFailWhenMissingDelegationCapability(server);
    }

    @Test
    default public void delegatedAccountDestroyShouldFailWhenMissingDelegationCapability(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String delegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB()).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"DelegatedAccount/set\", {\n         |\t\t\t\t\"accountId\": \"" + DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |\t\t\t\t\"destroy\": [\"" + delegationId + "\"]\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"error\",\n           |\t\t\t{\n           |\t\t\t\t\"type\": \"unknownMethod\",\n           |\t\t\t\t\"description\": \"Missing capability(ies): urn:apache:james:params:jmap:delegation\"\n           |\t\t\t},\n           |\t\t\t\"0\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void delegatedAccountDestroyShouldBeIdempotent$(DelegatedAccountSetContract $this, GuiceJamesServer server) {
        $this.delegatedAccountDestroyShouldBeIdempotent(server);
    }

    @Test
    default public void delegatedAccountDestroyShouldBeIdempotent(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String andreToBobDelegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB()).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"DelegatedAccount/set\", {\n         |\t\t\t\t\"accountId\": \"" + DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |\t\t\t\t\"destroy\": [\"" + andreToBobDelegationId + "\", \"" + andreToBobDelegationId + "\"]\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"DelegatedAccount/set\",\n           |            {\n           |                \"accountId\": \"" + DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n           |                \"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |                \"destroyed\": [\"" + andreToBobDelegationId + "\", \"" + andreToBobDelegationId + "\"]\n           |            },\n           |            \"0\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void shouldReturnNotFoundWhenTryToAccessNonDelegatedAccount$(DelegatedAccountSetContract $this) {
        $this.shouldReturnNotFoundWhenTryToAccessNonDelegatedAccount();
    }

    @Test
    default public void shouldReturnNotFoundWhenTryToAccessNonDelegatedAccount() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"DelegatedAccount/set\", {\n         |\t\t\t\t\"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |\t\t\t\t\"destroy\": [\"any\"]\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"type\": \"accountNotFound\"\n           |}")));
    }

    public static /* synthetic */ void bobCanOnlyManageHisPrimaryAccountSetting$(DelegatedAccountSetContract $this, GuiceJamesServer server) {
        $this.bobCanOnlyManageHisPrimaryAccountSetting(server);
    }

    @Test
    default public void bobCanOnlyManageHisPrimaryAccountSetting(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"DelegatedAccount/set\", {\n         |\t\t\t\t\"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |\t\t\t\t\"destroy\": [\"any\"]\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |\t\"error\",\n           |\t{\n           |\t\t\"type\": \"forbidden\",\n           |\t\t\"description\": \"Access to other accounts settings is forbidden\"\n           |\t},\n           |\t\"0\"\n           |]")));
    }

    public static /* synthetic */ void destroyShouldFailWhenInvalidId$(DelegatedAccountSetContract $this) {
        $this.destroyShouldFailWhenInvalidId();
    }

    @Test
    default public void destroyShouldFailWhenInvalidId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"DelegatedAccount/set\", {\n         |\t\t\t\t\"accountId\": \"" + DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |\t\t\t\t\"destroy\": [\"invalid\"]\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |\t\"DelegatedAccount/set\",\n           |\t{\n           |\t\t\"accountId\": \"" + DelegatedAccountSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n           |\t\t\"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\"notDestroyed\": {\n           |\t\t\t\"invalid\": {\n           |\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\"description\": \"invalid is not a DelegationId: Invalid UUID string: invalid\"\n           |\t\t\t}\n           |\t\t}\n           |\t},\n           |\t\"0\"\n           |]")));
    }

    public static void $init$(DelegatedAccountSetContract $this) {
    }
}

