/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3.webadmin;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.pop3server.mailbox.task.MetaDataFixInconsistenciesService;
import org.apache.james.pop3server.mailbox.task.MetaDataFixInconsistenciesTask;
import org.apache.james.task.Task;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import spark.Request;

public class Pop3MetaDataFixInconsistenciesTaskRegistration
extends TaskFromRequestRegistry.TaskRegistration {
    private static final TaskRegistrationKey REGISTRATION_KEY = TaskRegistrationKey.of((String)"fixPop3Inconsistencies");

    @Inject
    public Pop3MetaDataFixInconsistenciesTaskRegistration(MetaDataFixInconsistenciesService fixInconsistenciesService) {
        super(REGISTRATION_KEY, request -> Pop3MetaDataFixInconsistenciesTaskRegistration.fixInconsistencies(fixInconsistenciesService, request));
    }

    private static Task fixInconsistencies(MetaDataFixInconsistenciesService fixInconsistenciesService, Request request) {
        MetaDataFixInconsistenciesService.RunningOptions runningOptions = Pop3MetaDataFixInconsistenciesTaskRegistration.getMessagesPerSecond(request).map(MetaDataFixInconsistenciesService.RunningOptions::withMessageRatePerSecond).orElse(MetaDataFixInconsistenciesService.RunningOptions.DEFAULT);
        return new MetaDataFixInconsistenciesTask(fixInconsistenciesService, runningOptions);
    }

    private static Optional<Integer> getMessagesPerSecond(Request req) {
        try {
            return Optional.ofNullable(req.queryParams("messagesPerSecond")).map(Integer::parseInt).map(msgPerSeconds -> {
                Preconditions.checkArgument((msgPerSeconds > 0 ? 1 : 0) != 0, (Object)"'messagesPerSecond' must be strictly positive");
                return msgPerSeconds;
            });
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'messagesPerSecond' must be numeric");
        }
    }
}

