/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.vault;

class ExportRequest {
    private final String userExportFrom;
    private final String sharee;
    private final String matchingQuery;

    static Builder.RequireSharee userExportFrom(String userExportFrom) {
        return sharee -> query -> new ExportRequest(userExportFrom, sharee, query);
    }

    private ExportRequest(String userExportFrom, String sharee, String matchingQuery) {
        this.userExportFrom = userExportFrom;
        this.sharee = sharee;
        this.matchingQuery = matchingQuery;
    }

    String getUserExportFrom() {
        return this.userExportFrom;
    }

    String getSharee() {
        return this.sharee;
    }

    String getMatchingQuery() {
        return this.matchingQuery;
    }

    public static class Builder {

        @FunctionalInterface
        public static interface RequireMatchingQuery {
            public ExportRequest query(String var1);
        }

        @FunctionalInterface
        public static interface RequireSharee {
            public RequireMatchingQuery exportTo(String var1);
        }
    }
}

