/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.vault;

import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import org.apache.james.webadmin.integration.vault.ExportRequest;
import org.hamcrest.Matchers;

class DeletedMessagesVaultRequests {
    DeletedMessagesVaultRequests() {
    }

    static void exportVaultContent(RequestSpecification webAdminApi, ExportRequest exportRequest) {
        String taskId = (String)((Response)webAdminApi.with().queryParam("action", new Object[]{"export"}).queryParam("exportTo", new Object[]{exportRequest.getSharee()}).body(exportRequest.getMatchingQuery()).post("/deletedMessages/users/" + exportRequest.getUserExportFrom(), new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)webAdminApi.with().get("/tasks/" + taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }

    static void restoreMessagesForUserWithQuery(RequestSpecification webAdminApi, String user, String criteria) {
        String taskId = (String)((Response)webAdminApi.with().body(criteria).post("/deletedMessages/users/" + user + "?action=restore", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)webAdminApi.given().get("/tasks/" + taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }

    static void purgeVault(RequestSpecification webAdminApi) {
        String taskId = (String)((Response)webAdminApi.with().queryParam("scope", new Object[]{"expired"}).delete("/deletedMessages", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)webAdminApi.with().get("/tasks/" + taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }

    static void deleteFromVault(RequestSpecification webAdminApi, String user, String messageId) {
        String taskId = (String)((Response)webAdminApi.with().delete("/deletedMessages/users/" + user + "/messages/" + messageId, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)webAdminApi.with().get("/tasks/" + taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }
}

