/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.vault;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import io.restassured.RestAssured;
import io.restassured.config.ParamConfig;
import io.restassured.http.ContentType;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.JmapRFCCommonRequests;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.backup.ZipAssert;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.probe.MailboxProbe;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.TestIMAPClient;
import org.apache.james.utils.UpdatableTickingClock;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.integration.vault.DeletedMessagesVaultRequests;
import org.apache.james.webadmin.integration.vault.ExportRequest;
import org.assertj.core.api.Assertions;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public abstract class DeletedMessageVaultIntegrationTest {
    private static final ZonedDateTime NOW = ZonedDateTime.now();
    private static final ZonedDateTime TWO_MONTH_AFTER_ONE_YEAR_EXPIRATION = NOW.plusYears(1L).plusMonths(2L);
    private static final String FIRST_SUBJECT = "first subject";
    private static final String SECOND_SUBJECT = "second subject";
    private static final String HOMER = "homer@domain.tld";
    private static final String BART = "bart@domain.tld";
    private static final String JACK = "jack@domain.tld";
    private static final String PASSWORD = "password";
    private static final String BOB_PASSWORD = "bobPassword";
    private static final ConditionFactory WAIT_TWO_MINUTES = JMAPTestingConstants.calmlyAwait.atMost(Durations.TWO_MINUTES);
    private static final String SUBJECT = "This mail will be restored from the vault!!";
    private static final String MAILBOX_NAME = "toBeDeleted";
    private static final String MATCH_ALL_QUERY = "{\"combinator\": \"and\",\"criteria\": []}";
    private static final ExportRequest EXPORT_ALL_HOMER_MESSAGES_TO_BART = ExportRequest.userExportFrom("homer@domain.tld").exportTo("bart@domain.tld").query("{\"combinator\": \"and\",\"criteria\": []}");
    private static final ExportRequest EXPORT_ALL_JACK_MESSAGES_TO_HOMER = ExportRequest.userExportFrom("jack@domain.tld").exportTo("homer@domain.tld").query("{\"combinator\": \"and\",\"criteria\": []}");
    private TestIMAPClient testIMAPClient;
    private RequestSpecification webAdminApi;
    private MailboxId otherMailboxId;
    private JmapRFCCommonRequests.UserCredential homerCredential;
    private JmapRFCCommonRequests.UserCredential bartCredential;
    private JmapRFCCommonRequests.UserCredential jackCredential;

    @BeforeEach
    void setup(GuiceJamesServer jmapServer) throws Throwable {
        MailboxProbe mailboxProbe = (MailboxProbe)jmapServer.getProbe(MailboxProbeImpl.class);
        DataProbe dataProbe = (DataProbe)jmapServer.getProbe(DataProbeImpl.class);
        Port jmapPort = ((JmapGuiceProbe)jmapServer.getProbe(JmapGuiceProbe.class)).getJmapPort();
        RestAssured.requestSpecification = JMAPTestingConstants.jmapRequestSpecBuilder.setPort(jmapPort.getValue()).addHeader(JmapRFCCommonRequests.ACCEPT_JMAP_RFC_HEADER.getName(), JmapRFCCommonRequests.ACCEPT_JMAP_RFC_HEADER.getValue()).build();
        RestAssured.defaultParser = Parser.JSON;
        dataProbe.addDomain("domain.tld");
        dataProbe.addUser(HOMER, PASSWORD);
        dataProbe.addUser(BART, BOB_PASSWORD);
        dataProbe.addUser(JACK, PASSWORD);
        mailboxProbe.createMailbox("#private", HOMER, "INBOX");
        this.otherMailboxId = mailboxProbe.createMailbox("#private", HOMER, MAILBOX_NAME);
        this.homerCredential = JmapRFCCommonRequests.getUserCredential((String)HOMER, (String)PASSWORD);
        this.bartCredential = JmapRFCCommonRequests.getUserCredential((String)BART, (String)BOB_PASSWORD);
        this.jackCredential = JmapRFCCommonRequests.getUserCredential((String)JACK, (String)PASSWORD);
        this.testIMAPClient = new TestIMAPClient();
        this.webAdminApi = WebAdminUtils.spec((Port)((WebAdminGuiceProbe)jmapServer.getProbe(WebAdminGuiceProbe.class)).getWebAdminPort()).config(WebAdminUtils.defaultConfig().paramConfig(new ParamConfig().replaceAllParameters()));
    }

    @AfterEach
    void tearDown() throws IOException {
        this.testIMAPClient.close();
    }

    protected abstract void awaitSearchUpToDate();

    @Tag(value="BasicFeature")
    @Test
    void vaultEndpointShouldRestoreJmapDeletedEmail() {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        Assertions.assertThat((String)JmapRFCCommonRequests.getMessageContent((JmapRFCCommonRequests.UserCredential)this.homerCredential, (String)messageId).getString("methodResponses[0][1].list[0].subject")).isEqualTo(SUBJECT);
    }

    @Tag(value="BasicFeature")
    @Test
    void vaultEndpointShouldRestoreImapDeletedEmail(GuiceJamesServer jmapServer) throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)jmapServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login(HOMER, PASSWORD).select("INBOX").setFlagsForAllMessagesInMailbox("\\Deleted");
        this.testIMAPClient.expunge();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        Assertions.assertThat((String)JmapRFCCommonRequests.getMessageContent((JmapRFCCommonRequests.UserCredential)this.homerCredential, (String)messageId).getString("methodResponses[0][1].list[0].subject")).isEqualTo(SUBJECT);
    }

    @Tag(value="BasicFeature")
    @Test
    void vaultEndpointShouldRestoreImapDeletedMailbox(GuiceJamesServer jmapServer) throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)jmapServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login(HOMER, PASSWORD).select("INBOX");
        this.testIMAPClient.moveFirstMessage(MAILBOX_NAME);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsInMailbox((JmapRFCCommonRequests.UserCredential)this.homerCredential, (String)this.otherMailboxId.serialize())).hasSize(1));
        this.testIMAPClient.delete(MAILBOX_NAME);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        Thread.sleep(1000L);
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        Assertions.assertThat((String)JmapRFCCommonRequests.getMessageContent((JmapRFCCommonRequests.UserCredential)this.homerCredential, (String)messageId).getString("methodResponses[0][1].list[0].subject")).isEqualTo(SUBJECT);
    }

    @Test
    void restoreShouldCreateRestoreMessagesMailbox() {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        Assertions.assertThat((boolean)this.homerHasMailboxWithRole(Role.RESTORED_MESSAGES)).isTrue();
    }

    @Test
    void postShouldRestoreMatchingMessages() {
        this.bartSendMessageToHomerWithSubject("aaaaa");
        this.bartSendMessageToHomerWithSubject("bbbbb");
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(2));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        String query = "{  \"combinator\": \"and\",  \"criteria\": [    {      \"fieldName\": \"subject\",      \"operator\": \"equals\",      \"value\": \"aaaaa\"    }  ]}";
        DeletedMessagesVaultRequests.restoreMessagesForUserWithQuery(this.webAdminApi, HOMER, query);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        Assertions.assertThat((String)JmapRFCCommonRequests.getMessageContent((JmapRFCCommonRequests.UserCredential)this.homerCredential, (String)messageId).getString("methodResponses[0][1].list[0].subject")).isEqualTo("aaaaa");
    }

    @Test
    void postShouldNotRestoreWhenNoMatchingMessages() throws Exception {
        this.bartSendMessageToHomerWithSubject("aaaaa");
        this.bartSendMessageToHomerWithSubject("bbbbb");
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(2));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        String query = "{  \"combinator\": \"and\",  \"criteria\": [    {      \"fieldName\": \"subject\",      \"operator\": \"equals\",      \"value\": \"ccccc\"    }  ]}";
        DeletedMessagesVaultRequests.restoreMessagesForUserWithQuery(this.webAdminApi, HOMER, query);
        Thread.sleep(Durations.FIVE_SECONDS.toMillis());
        Assertions.assertThat((int)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).size()).isEqualTo(0);
    }

    @Test
    void postShouldRestoreMatchingMessagesWhenQueryLimit() {
        this.bartSendMessageToHomerWithSubject("aaaa");
        this.bartSendMessageToHomerWithSubject("aaaa");
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(2));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        String query = "{  \"combinator\": \"and\",  \"limit\": 1,  \"criteria\": [    {      \"fieldName\": \"subject\",      \"operator\": \"equals\",      \"value\": \"aaaa\"    }  ]}";
        DeletedMessagesVaultRequests.restoreMessagesForUserWithQuery(this.webAdminApi, HOMER, query);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
    }

    @Test
    void imapMovedMessageShouldNotEndUpInTheVault(GuiceJamesServer jmapServer) throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)jmapServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login(HOMER, PASSWORD).select("INBOX");
        this.testIMAPClient.moveFirstMessage(MAILBOX_NAME);
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        Assertions.assertThat((int)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).size()).isEqualTo(1);
    }

    @Test
    void jmapMovedMessageShouldNotEndUpInTheVault() {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.homerMovesTheMailInAnotherMailbox(messageId);
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        Assertions.assertThat((int)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).size()).isEqualTo(1);
    }

    @Test
    void restoreShouldNotImpactOtherUsers() {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        this.bartDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.bartCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.bartCredential)).hasSize(0));
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        Assertions.assertThat((int)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.bartCredential).size()).isEqualTo(0);
    }

    @Test
    void restoredMessagesShouldNotBeRemovedFromTheVault() {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(2));
    }

    @Test
    void vaultEndpointShouldNotRestoreItemsWhenTheVaultIsEmpty() {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.restoreAllMessagesOfHomer();
        this.awaitSearchUpToDate();
        Assertions.assertThat((int)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).size()).isEqualTo(1);
    }

    @Test
    void vaultEndpointShouldNotRestoreMessageForSharee() {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.bartCredential)).hasSize(1));
        String messageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.homerMovesTheMailInAnotherMailbox(messageId);
        this.homerSharesHisMailboxWithBart();
        this.bartDeletesMessages((List<String>)ImmutableList.of((Object)messageId));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        this.restoreMessagesFor(BART);
        this.awaitSearchUpToDate();
        Assertions.assertThat((int)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.bartCredential).size()).isEqualTo(1);
    }

    @Test
    void vaultEndpointShouldRestoreMessageForSharer() {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.homerMovesTheMailInAnotherMailbox(messageId);
        this.homerSharesHisMailboxWithBart();
        this.bartDeletesMessages((List<String>)ImmutableList.of((Object)messageId));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        this.restoreAllMessagesOfHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String newMessageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        Assertions.assertThat((String)JmapRFCCommonRequests.getMessageContent((JmapRFCCommonRequests.UserCredential)this.homerCredential, (String)newMessageId).getString("methodResponses[0][1].list[0].subject")).isEqualTo(SUBJECT);
    }

    @Tag(value="BasicFeature")
    @Test
    void vaultExportShouldExportZipContainsVaultMessagesToShareeWhenJmapDeleteMessage() throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageIdOfHomer = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasEntriesSize(1).allSatisfies(entry -> ZipAssert.EntryChecks.hasName((String)(messageIdOfHomer + ".eml")));
        }
    }

    @Tag(value="BasicFeature")
    @Test
    void vaultExportShouldExportZipContainsVaultMessagesToShareeWhenImapDeleteMessage(GuiceJamesServer jmapServer) throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageIdOfHomer = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)jmapServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login(HOMER, PASSWORD).select("INBOX").setFlagsForAllMessagesInMailbox("\\Deleted");
        this.testIMAPClient.expunge();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasEntriesSize(1).allSatisfies(entry -> ZipAssert.EntryChecks.hasName((String)(messageIdOfHomer + ".eml")));
        }
    }

    @Tag(value="BasicFeature")
    @Test
    public void vaultExportShouldExportZipContainsVaultMessagesToShareeWhenImapDeletedMailbox(GuiceJamesServer jmapServer) throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageIdOfHomer = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)jmapServer.getProbe(ImapGuiceProbe.class)).getImapPort()).login(HOMER, PASSWORD).select("INBOX");
        this.testIMAPClient.moveFirstMessage(MAILBOX_NAME);
        this.testIMAPClient.delete(MAILBOX_NAME);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasEntriesSize(1).allSatisfies(entry -> ZipAssert.EntryChecks.hasName((String)(messageIdOfHomer + ".eml")));
        }
    }

    @Test
    void vaultExportShouldExportZipContainsOnlyMatchedMessages() throws Exception {
        this.bartSendMessageToHomerWithSubject(FIRST_SUBJECT);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String firstMessageIdOfHomer = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.bartSendMessageToHomerWithSubject(SECOND_SUBJECT);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(2));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        ExportRequest exportRequest = ExportRequest.userExportFrom(HOMER).exportTo(BART).query("{\n    \"fieldName\": \"subject\",\n    \"operator\": \"equals\",\n    \"value\": \"%s\"\n}\n".formatted(FIRST_SUBJECT));
        String fileLocation = this.exportAndGetFileLocationFromLastMail(exportRequest, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.containsOnlyEntriesMatching(new ZipAssert.EntryChecks[]{ZipAssert.EntryChecks.hasName((String)(firstMessageIdOfHomer + ".eml"))});
        }
    }

    @Test
    void vaultExportShouldExportEmptyZipWhenQueryDoesntMatch() throws Exception {
        this.bartSendMessageToHomerWithSubject(FIRST_SUBJECT);
        this.bartSendMessageToHomerWithSubject(SECOND_SUBJECT);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(2));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        ExportRequest exportRequest = ExportRequest.userExportFrom(HOMER).exportTo(BART).query("{  \"fieldName\": \"subject\",  \"operator\": \"equals\",  \"value\": \"non matching\"}");
        String fileLocation = this.exportAndGetFileLocationFromLastMail(exportRequest, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasNoEntry();
        }
    }

    @Test
    void vaultExportShouldExportEmptyZipWhenVaultIsEmpty() throws Exception {
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasNoEntry();
        }
    }

    @Test
    void vaultExportShouldResponseIdempotentSideEffect() throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        String fileLocationFirstExport = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        String fileLocationSecondExport = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocationFirstExport));){
            zipAssert.hasSameContentWith((InputStream)new FileInputStream(fileLocationSecondExport));
        }
    }

    @Test
    void vaultPurgeShouldMakeExportProduceEmptyZipWhenAllMessagesAreExpired(UpdatableTickingClock clock) throws Exception {
        this.bartSendMessageToHomer();
        this.bartSendMessageToHomer();
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(3));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        clock.setInstant(TWO_MONTH_AFTER_ONE_YEAR_EXPIRATION.toInstant());
        DeletedMessagesVaultRequests.purgeVault(this.webAdminApi);
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasNoEntry();
        }
    }

    @Test
    void vaultPurgeShouldMakeExportProduceAZipWhenOneMessageIsNotExpired(UpdatableTickingClock clock) throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageIdOfNotExpiredMessage = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        clock.setInstant(TWO_MONTH_AFTER_ONE_YEAR_EXPIRATION.toInstant());
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        DeletedMessagesVaultRequests.purgeVault(this.webAdminApi);
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasEntriesSize(1).allSatisfies(entry -> ZipAssert.EntryChecks.hasName((String)(messageIdOfNotExpiredMessage + ".eml")));
        }
    }

    @Test
    void vaultPurgeShouldMakeExportProduceZipWhenAllMessagesAreNotExpired() throws Exception {
        this.bartSendMessageToHomer();
        this.bartSendMessageToHomer();
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(3));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        DeletedMessagesVaultRequests.purgeVault(this.webAdminApi);
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasEntriesSize(3);
        }
    }

    @Test
    void vaultPurgeShouldNotAppendMessageToTheUserMailbox(UpdatableTickingClock clock) {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        clock.setInstant(TWO_MONTH_AFTER_ONE_YEAR_EXPIRATION.toInstant());
        DeletedMessagesVaultRequests.purgeVault(this.webAdminApi);
        Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0);
    }

    @Test
    void vaultDeleteShouldDeleteMessageThenExportWithNoEntry() throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageIdOfHomer = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        DeletedMessagesVaultRequests.deleteFromVault(this.webAdminApi, HOMER, messageIdOfHomer);
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasNoEntry();
        }
    }

    @Test
    void vaultDeleteShouldNotDeleteEmptyVaultThenExportNoEntry() throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageIdOfHomer = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        DeletedMessagesVaultRequests.deleteFromVault(this.webAdminApi, HOMER, messageIdOfHomer);
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasNoEntry();
        }
    }

    @Test
    void vaultDeleteShouldNotDeleteNotMatchedMessageInVaultThenExportAnEntry() throws Exception {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageIdOfHomer = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.bartCredential)).hasSize(1));
        String messageIdOfBart = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.bartCredential).get(0);
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        DeletedMessagesVaultRequests.deleteFromVault(this.webAdminApi, HOMER, messageIdOfBart);
        String fileLocation = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_HOMER_MESSAGES_TO_BART, this.bartCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocation));){
            zipAssert.hasEntriesSize(1).allSatisfies(entry -> ZipAssert.EntryChecks.hasName((String)(messageIdOfHomer + ".eml")));
        }
    }

    @Test
    void vaultDeleteShouldNotAppendMessageToTheUserMailbox() {
        this.bartSendMessageToHomer();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String messageIdOfHomer = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.homerDeletesMessages(JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        DeletedMessagesVaultRequests.deleteFromVault(this.webAdminApi, HOMER, messageIdOfHomer);
        Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0);
    }

    @Test
    void vaultDeleteShouldDeleteAllMessagesHavingSameBlobContent() throws Exception {
        this.bartSendMessageToHomerAndJack();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String homerInboxMessageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.homerDeletesMessages((List<String>)ImmutableList.of((Object)homerInboxMessageId));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        String jackInboxMessageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.jackCredential).get(0);
        this.jackDeletesMessages((List<String>)ImmutableList.of((Object)jackInboxMessageId));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.jackCredential)).hasSize(0));
        DeletedMessagesVaultRequests.deleteFromVault(this.webAdminApi, HOMER, homerInboxMessageId);
        String fileLocationOfBartMessages = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_JACK_MESSAGES_TO_HOMER, this.homerCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocationOfBartMessages));){
            zipAssert.hasNoEntry();
        }
    }

    @Test
    void vaultDeleteShouldNotDeleteAllMessagesHavingSameBlobContentWhenMessageNotDeletedWithinTheSameMonth(UpdatableTickingClock clock) throws Exception {
        this.bartSendMessageToHomerAndJack();
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(1));
        String homerInboxMessageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential).get(0);
        this.homerDeletesMessages((List<String>)ImmutableList.of((Object)homerInboxMessageId));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.homerCredential)).hasSize(0));
        clock.setInstant(NOW.plusYears(1L).toInstant());
        String jackInboxMessageId = (String)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.jackCredential).get(0);
        this.jackDeletesMessages((List<String>)ImmutableList.of((Object)jackInboxMessageId));
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.jackCredential)).hasSize(0));
        DeletedMessagesVaultRequests.deleteFromVault(this.webAdminApi, HOMER, homerInboxMessageId);
        String fileLocationOfBartMessages = this.exportAndGetFileLocationFromLastMail(EXPORT_ALL_JACK_MESSAGES_TO_HOMER, this.homerCredential);
        try (ZipAssert zipAssert = ZipAssert.assertThatZip((InputStream)new FileInputStream(fileLocationOfBartMessages));){
            zipAssert.hasEntriesSize(1).allSatisfies(entry -> ZipAssert.EntryChecks.hasName((String)(jackInboxMessageId + ".eml")));
        }
    }

    private String exportAndGetFileLocationFromLastMail(ExportRequest exportRequest, JmapRFCCommonRequests.UserCredential shareeCredential) {
        int currentNumberOfMessages = JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)shareeCredential).size();
        DeletedMessagesVaultRequests.exportVaultContent(this.webAdminApi, exportRequest);
        WAIT_TWO_MINUTES.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)shareeCredential)).hasSize(currentNumberOfMessages + 1));
        String exportingMessageId = JmapRFCCommonRequests.getLatestMessageId((JmapRFCCommonRequests.UserCredential)shareeCredential, (Role)Role.INBOX);
        return this.exportedFileLocationFromMailHeader(exportingMessageId, shareeCredential);
    }

    private String exportedFileLocationFromMailHeader(String messageId, JmapRFCCommonRequests.UserCredential userCredential) {
        List headers = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(userCredential.username().asString(), userCredential.password()).body("{\n    \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n    \"methodCalls\": [\n        [\"Email/get\", {\n            \"accountId\": \"%s\",\n            \"ids\": [\"%s\"],\n            \"properties\":[\"bodyStructure\"],\n            \"bodyProperties\":[\"name\", \"type\",\"headers\"]\n        }, \"c2\"]\n    ]\n}\n".formatted(userCredential.accountId(), messageId)).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().path("methodResponses[0][1].list[0].bodyStructure.headers", new String[0]);
        return ((String)headers.stream().filter(header -> ((String)header.get("name")).equals("corresponding-file")).findFirst().orElseThrow(() -> new RuntimeException("No corresponding-file header found")).get("value")).trim();
    }

    private void homerSharesHisMailboxWithBart() {
        RestAssured.with().auth().basic(this.homerCredential.username().asString(), this.homerCredential.password()).body("    {\n        \"using\": [ \"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\" ],\n        \"methodCalls\": [\n            [\n                \"Mailbox/set\",\n                {\n                    \"accountId\": \"%s\",\n                    \"update\": {\n                        \"%s\": {\n                            \"sharedWith\": {\n                                \"%s\":[\"r\", \"l\", \"w\", \"t\"]\n                            }\n                        }\n                    }\n                },\n                \"c1\"\n            ]\n        ]\n    }\n".formatted(this.homerCredential.accountId(), this.otherMailboxId.serialize(), BART)).post("/jmap", new Object[0]);
    }

    private void bartSendMessageToHomer() {
        this.bartSendMessageToHomerWithSubject(SUBJECT);
    }

    private void bartSendMessageToHomerAndJack() {
        String outboxId = JmapRFCCommonRequests.getOutboxId((JmapRFCCommonRequests.UserCredential)this.bartCredential);
        String requestBody = "{    \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],    \"methodCalls\": [        [\"Email/set\", {            \"accountId\": \"" + this.bartCredential.accountId() + "\",            \"create\": {                \"e1526\": {                    \"mailboxIds\": { \"" + outboxId + "\": true },                    \"subject\": \"This mail will be restored from the vault!!\",                    \"htmlBody\": [{                        \"partId\": \"a49d\",                        \"type\": \"text/html\"                    }],                    \"bodyValues\": {                        \"a49d\": {                            \"value\": \"Test <b>body</b>, HTML version\"                        }                    },                    \"to\": [{                        \"email\": \"homer@domain.tld\"                    }, {                        \"email\": \"jack@domain.tld\"                    }],                    \"from\": [{                        \"email\": \"bart@domain.tld\"                    }]                }            }        }, \"c1\"],        [\"Email/get\", {            \"accountId\": \"" + this.bartCredential.accountId() + "\",            \"ids\": [\"#e1526\"],            \"properties\": [\"sentAt\"]        }, \"c2\"],        [\"EmailSubmission/set\", {            \"accountId\": \"" + this.bartCredential.accountId() + "\",            \"create\": {                \"k1490\": {                    \"emailId\": \"#e1526\",                    \"envelope\": {                        \"mailFrom\": {\"email\": \"bart@domain.tld\"},                        \"rcptTo\": [{                            \"email\": \"homer@domain.tld\"                        }, {                            \"email\": \"jack@domain.tld\"                        }]                    }                }            }        }, \"c3\"]    ]}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(this.bartCredential.username().asString(), this.bartCredential.password()).body(requestBody).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("methodResponses[2][1].created", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    private void bartSendMessageToHomerWithSubject(String subject) {
        String outboxId = JmapRFCCommonRequests.getOutboxId((JmapRFCCommonRequests.UserCredential)this.bartCredential);
        String requestBody = "{    \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],    \"methodCalls\": [        [\"Email/set\", {            \"accountId\": \"" + this.bartCredential.accountId() + "\",            \"create\": {                \"e1526\": {                    \"mailboxIds\": { \"" + outboxId + "\": true },                    \"subject\": \"" + subject + "\",                    \"htmlBody\": [{                        \"partId\": \"a49d\",                        \"type\": \"text/html\"                    }],                    \"bodyValues\": {                        \"a49d\": {                            \"value\": \"Test <b>body</b>, HTML version\"                        }                    },                    \"to\": [{\"email\": \"homer@domain.tld\"}],                    \"from\": [{\"email\": \"bart@domain.tld\"}]                }            }        }, \"c1\"],        [\"Email/get\", {            \"accountId\": \"" + this.bartCredential.accountId() + "\",            \"ids\": [\"#e1526\"],            \"properties\": [\"sentAt\"]        }, \"c2\"],        [\"EmailSubmission/set\", {            \"accountId\": \"" + this.bartCredential.accountId() + "\",            \"create\": {                \"k1490\": {                    \"emailId\": \"#e1526\",                    \"envelope\": {                        \"mailFrom\": {\"email\": \"bart@domain.tld\"},                        \"rcptTo\": [{\"email\": \"homer@domain.tld\"}]                    }                }            }        }, \"c3\"]    ]}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(this.bartCredential.username().asString(), this.bartCredential.password()).body(requestBody).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("methodResponses[2][1].created", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    private void homerDeletesMessages(List<String> idsToDestroy) {
        JmapRFCCommonRequests.deleteMessages((JmapRFCCommonRequests.UserCredential)this.homerCredential, idsToDestroy);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void bartDeletesMessages(List<String> idsToDestroy) {
        JmapRFCCommonRequests.deleteMessages((JmapRFCCommonRequests.UserCredential)this.bartCredential, idsToDestroy);
    }

    private void jackDeletesMessages(List<String> idsToDestroy) {
        JmapRFCCommonRequests.deleteMessages((JmapRFCCommonRequests.UserCredential)this.jackCredential, idsToDestroy);
    }

    private void restoreAllMessagesOfHomer() {
        this.restoreMessagesFor(HOMER);
    }

    private void restoreMessagesFor(String user) {
        DeletedMessagesVaultRequests.restoreMessagesForUserWithQuery(this.webAdminApi, user, MATCH_ALL_QUERY);
    }

    private void homerMovesTheMailInAnotherMailbox(String messageId) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic(this.homerCredential.username().asString(), this.homerCredential.password()).body("{\n    \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n    \"methodCalls\": [\n        [\"Email/set\", {\n            \"accountId\": \"%s\",\n            \"update\": {\n                \"%s\":{\n                    \"mailboxIds\": { \"%s\" : true}\n                }\n            }\n        }, \"c1\"]]\n}".formatted(this.homerCredential.accountId(), messageId, this.otherMailboxId.serialize())).when().post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
    }

    private boolean homerHasMailboxWithRole(Role role) {
        return JmapRFCCommonRequests.getAllMailboxesIds((JmapRFCCommonRequests.UserCredential)this.homerCredential).stream().filter(mailbox -> mailbox.get("role") != null).anyMatch(mailbox -> ((String)mailbox.get("role")).equals(role.serialize()) && ((String)mailbox.get("name")).equals(role.getDefaultMailbox()));
    }

    public static class ClockExtension
    implements GuiceModuleTestExtension {
        private UpdatableTickingClock clock;

        public void beforeEach(ExtensionContext extensionContext) {
            this.clock = new UpdatableTickingClock(NOW.toInstant());
        }

        public Module getModule() {
            return binder -> binder.bind(Clock.class).toInstance((Object)this.clock);
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return parameterContext.getParameter().getType() == UpdatableTickingClock.class;
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return this.clock;
        }
    }
}

