/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import com.google.common.hash.Hashing;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.nio.charset.StandardCharsets;
import java.util.stream.IntStream;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

public abstract class QuotaSearchIntegrationTest {
    private RequestSpecification webAdminApi;
    private Port jmapPort;

    protected abstract void awaitSearchUpToDate() throws Exception;

    @BeforeEach
    void setUp(GuiceJamesServer jmapServer) throws Exception {
        DataProbe dataProbe = (DataProbe)jmapServer.getProbe(DataProbeImpl.class);
        dataProbe.addDomain("domain.tld");
        dataProbe.addUser(JMAPTestingConstants.BOB.asString(), "123456");
        dataProbe.addUser(JMAPTestingConstants.CEDRIC.asString(), "456789");
        this.jmapPort = ((JmapGuiceProbe)jmapServer.getProbe(JmapGuiceProbe.class)).getJmapPort();
        RestAssured.requestSpecification = JMAPTestingConstants.jmapRequestSpecBuilder.setPort(this.jmapPort.getValue()).build();
        this.webAdminApi = WebAdminUtils.spec((Port)((WebAdminGuiceProbe)jmapServer.getProbe(WebAdminGuiceProbe.class)).getWebAdminPort());
    }

    @Tag(value="BasicFeature")
    @Test
    public void quotaSearchShouldPlayWellWithDelegation(GuiceJamesServer server) throws Exception {
        this.webAdminApi.body("20").put("/quota/users/" + JMAPTestingConstants.BOB.asString() + "/count", new Object[0]);
        this.webAdminApi.body("20").put("/quota/users/" + JMAPTestingConstants.CEDRIC.asString() + "/count", new Object[0]);
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)JMAPTestingConstants.CEDRIC));
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(MailboxPath.inbox((Username)JMAPTestingConstants.CEDRIC), JMAPTestingConstants.BOB.asString(), MailboxACL.FULL_RIGHTS);
        String accountId = Hashing.sha256().hashString((CharSequence)JMAPTestingConstants.BOB.asString(), StandardCharsets.UTF_8).toString();
        String requestBody = "{  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],  \"methodCalls\": [    [\"Email/set\",       {         \"accountId\": \"" + accountId + "\",         \"create\": {           \"aaaaaa\":{              \"mailboxIds\": {\"" + mailboxId.serialize() + "\": true}           }         }       },      \"c1\"   ] ]}";
        IntStream.range(0, 19).forEach(i -> RestAssured.given().auth().basic(JMAPTestingConstants.BOB.asString(), "123456").contentType(ContentType.JSON).accept("application/json; jmapVersion=rfc-8621").body(requestBody).post("/jmap", new Object[0]));
        this.awaitSearchUpToDate();
        ((ValidatableResponse)((Response)this.webAdminApi.param("minOccupationRatio", new Object[]{0.9}).when().get("/quota/users", new Object[0])).then()).body("username", Matchers.containsInAnyOrder((Object[])new String[]{JMAPTestingConstants.CEDRIC.asString()}), new Object[0]);
    }
}

