/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.util.List;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.JmapRFCCommonRequests;
import org.apache.james.mailbox.probe.MailboxProbe;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.integration.TestFixture;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

public abstract class ForwardIntegrationTest {
    private SMTPMessageSender messageSender;
    private RequestSpecification webAdminApi;
    private Port jmapPort;

    @BeforeEach
    void setUp(GuiceJamesServer jmapServer) throws Exception {
        MailboxProbe mailboxProbe = (MailboxProbe)jmapServer.getProbe(MailboxProbeImpl.class);
        this.messageSender = new SMTPMessageSender("domain.tld");
        DataProbe dataProbe = (DataProbe)jmapServer.getProbe(DataProbeImpl.class);
        dataProbe.addDomain("domain.tld");
        dataProbe.addUser(JMAPTestingConstants.BOB.asString(), "123456");
        dataProbe.addUser(JMAPTestingConstants.ALICE.asString(), "789123");
        dataProbe.addUser(JMAPTestingConstants.CEDRIC.asString(), "456789");
        mailboxProbe.createMailbox("#private", JMAPTestingConstants.ALICE.asString(), "INBOX");
        mailboxProbe.createMailbox("#private", JMAPTestingConstants.CEDRIC.asString(), "INBOX");
        this.jmapPort = ((JmapGuiceProbe)jmapServer.getProbe(JmapGuiceProbe.class)).getJmapPort();
        RestAssured.requestSpecification = JMAPTestingConstants.jmapRequestSpecBuilder.setPort(this.jmapPort.getValue()).addHeader(JmapRFCCommonRequests.ACCEPT_JMAP_RFC_HEADER.getName(), JmapRFCCommonRequests.ACCEPT_JMAP_RFC_HEADER.getValue()).build();
        this.webAdminApi = WebAdminUtils.spec((Port)((WebAdminGuiceProbe)jmapServer.getProbe(WebAdminGuiceProbe.class)).getWebAdminPort());
    }

    @AfterEach
    void tearDown() throws IOException {
        this.messageSender.close();
    }

    @Tag(value="BasicFeature")
    @Test
    void messageShouldBeForwardedWhenDefinedInRESTAPI() {
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString()), new Object[0]);
        this.cedricSendAnEmailToAlice();
        JmapRFCCommonRequests.UserCredential bobCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.BOB, (String)"123456");
        TestFixture.WAIT_THIRTY_SECONDS.untilAsserted(() -> AssertionsForInterfaceTypes.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)bobCredential)).hasSize(1));
    }

    @Test
    void messageShouldBeForwardedWhenBaseRecipientWhenInDestination() {
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString()), new Object[0]);
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.ALICE.asString()), new Object[0]);
        this.cedricSendAnEmailToAlice();
        JmapRFCCommonRequests.UserCredential bobCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.BOB, (String)"123456");
        TestFixture.WAIT_THIRTY_SECONDS.untilAsserted(() -> AssertionsForInterfaceTypes.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)bobCredential)).hasSize(1));
        JmapRFCCommonRequests.UserCredential aliceCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.BOB, (String)"123456");
        TestFixture.WAIT_THIRTY_SECONDS.untilAsserted(() -> AssertionsForInterfaceTypes.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)aliceCredential)).hasSize(1));
    }

    @Test
    void smtpMessageShouldBeForwardedWhenBaseRecipientWhenInDestination(GuiceJamesServer jmapServer) throws Exception {
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString()), new Object[0]);
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.ALICE.asString()), new Object[0]);
        this.messageSender.connect("127.0.0.1", ((SmtpGuiceProbe)jmapServer.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessage("cedric@other.com", JMAPTestingConstants.ALICE.asString());
        JmapRFCCommonRequests.UserCredential bobCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.BOB, (String)"123456");
        TestFixture.WAIT_THIRTY_SECONDS.untilAsserted(() -> AssertionsForInterfaceTypes.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)bobCredential)).hasSize(1));
        JmapRFCCommonRequests.UserCredential aliceCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.BOB, (String)"123456");
        TestFixture.WAIT_THIRTY_SECONDS.untilAsserted(() -> AssertionsForInterfaceTypes.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)aliceCredential)).hasSize(1));
    }

    @Test
    void recursiveForwardShouldWork() {
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.CEDRIC.asString()), new Object[0]);
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.CEDRIC.asString(), JMAPTestingConstants.BOB.asString()), new Object[0]);
        this.cedricSendAnEmailToAlice();
        JmapRFCCommonRequests.UserCredential bobCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.BOB, (String)"123456");
        TestFixture.WAIT_THIRTY_SECONDS.untilAsserted(() -> AssertionsForInterfaceTypes.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)bobCredential)).hasSize(1));
    }

    @Test
    void recursiveWithRecipientCopyForwardShouldWork() {
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.ALICE.asString()), new Object[0]);
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString()), new Object[0]);
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.BOB.asString(), JMAPTestingConstants.CEDRIC.asString()), new Object[0]);
        this.cedricSendAnEmailToAlice();
        JmapRFCCommonRequests.UserCredential aliceCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.ALICE, (String)"789123");
        TestFixture.WAIT_THIRTY_SECONDS.untilAsserted(() -> AssertionsForInterfaceTypes.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)aliceCredential)).hasSize(1));
    }

    @Test
    void baseRecipientShouldNotReceiveEmailOnDefaultForward() {
        this.webAdminApi.put(String.format("/address/forwards/%s/targets/%s", JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString()), new Object[0]);
        this.cedricSendAnEmailToAlice();
        JmapRFCCommonRequests.UserCredential bobCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.BOB, (String)"123456");
        TestFixture.WAIT_THIRTY_SECONDS.untilAsserted(() -> AssertionsForInterfaceTypes.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)bobCredential)).hasSize(1));
        JmapRFCCommonRequests.UserCredential aliceCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.ALICE, (String)"789123");
        AssertionsForInterfaceTypes.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)aliceCredential)).hasSize(0);
    }

    private void cedricSendAnEmailToAlice() {
        JmapRFCCommonRequests.UserCredential cedricCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.CEDRIC, (String)"456789");
        String cedricOutboxId = JmapRFCCommonRequests.getOutboxId((JmapRFCCommonRequests.UserCredential)cedricCredential);
        String request = "{    \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],    \"methodCalls\": [        [\"Email/set\", {            \"accountId\": \"" + cedricCredential.accountId() + "\",            \"create\": {                \"e1526\": {                    \"mailboxIds\": { \"" + cedricOutboxId + "\": true },                    \"subject\": \"subject\",                    \"htmlBody\": [{                        \"partId\": \"a49d\",                        \"type\": \"text/html\"                    }],                    \"bodyValues\": {                        \"a49d\": {                            \"value\": \"Test <b>body</b>, HTML version\"                        }                    },                    \"to\": [{\"email\": \"" + JMAPTestingConstants.ALICE.asString() + "\"}],                    \"from\": [{\"email\": \"" + JMAPTestingConstants.CEDRIC.asString() + "\"}]                }            }        }, \"c1\"],        [\"EmailSubmission/set\", {             \"accountId\": \"" + cedricCredential.accountId() + "\",             \"create\": {                 \"k1490\": {                     \"emailId\": \"#e1526\",                     \"envelope\": {                         \"mailFrom\": {\"email\": \"" + JMAPTestingConstants.CEDRIC.asString() + "\"},                         \"rcptTo\": [{\"email\": \"" + JMAPTestingConstants.ALICE.asString() + "\"}]                     }                 }             }         }, \"c3\"]    ]}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(cedricCredential.username().asString(), cedricCredential.password()).body(request).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("methodResponses[0][1].created.e1526", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }
}

