/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.net.imap.AuthenticatingIMAPClient;
import org.apache.commons.net.imap.IMAPClient;
import org.apache.commons.net.io.CRLFLineReader;
import org.apache.james.core.Username;
import org.assertj.core.api.Assertions;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.ExternalResource;

public class TestIMAPClient
extends ExternalResource
implements Closeable,
AfterEachCallback {
    private static final Pattern EXAMINE_EXISTS = Pattern.compile("^\\* (\\d+) EXISTS$");
    private static final int MESSAGE_NUMBER_MATCHING_GROUP = 1;
    public static final String INBOX = "INBOX";
    private final IMAPClient imapClient;

    @VisibleForTesting
    TestIMAPClient(Utf8IMAPSClient imapClient) {
        this.imapClient = imapClient;
    }

    public TestIMAPClient() {
        this(new Utf8IMAPSClient());
    }

    public TestIMAPClient(IMAPClient imapClient) {
        this.imapClient = imapClient;
    }

    public TestIMAPClient connect(String host, int port) throws IOException {
        this.imapClient.connect(host, port);
        return this;
    }

    public String capability() throws IOException {
        this.imapClient.capability();
        return this.imapClient.getReplyString();
    }

    public TestIMAPClient disconnect() throws IOException {
        this.imapClient.disconnect();
        return this;
    }

    public TestIMAPClient login(String user, String password) throws IOException {
        boolean login = this.imapClient.login(user, password);
        if (!login) {
            throw new IOException("Login failed");
        }
        return this;
    }

    public TestIMAPClient authenticatePlain(String user, String password) throws Exception {
        Preconditions.checkArgument((boolean)(this.imapClient instanceof AuthenticatingIMAPClient));
        boolean authenticatePlain = ((AuthenticatingIMAPClient)this.imapClient).authenticate(AuthenticatingIMAPClient.AUTH_METHOD.PLAIN, user, password);
        if (!authenticatePlain) {
            throw new Exception("Login failed");
        }
        return this;
    }

    public TestIMAPClient rawLogin(String user, String password) throws IOException {
        this.imapClient.sendCommand("LOGIN " + user + " " + password);
        if (this.imapClient.getReplyString().contains("NO LOGIN failed.")) {
            throw new IOException("Login failed");
        }
        return this;
    }

    public List<String> list() throws IOException {
        this.imapClient.list("", "*");
        return ImmutableList.copyOf((Object[])this.imapClient.getReplyStrings());
    }

    public TestIMAPClient login(Username user, String password) throws IOException {
        return this.login(user.asString(), password);
    }

    public TestIMAPClient select(String mailbox) throws IOException {
        this.imapClient.select(mailbox);
        return this;
    }

    public TestIMAPClient create(String mailbox) throws IOException {
        if (!this.imapClient.create(mailbox)) {
            throw new RuntimeException(this.imapClient.getReplyString());
        }
        return this;
    }

    public TestIMAPClient append(String mailboxName, String message) throws IOException {
        String noFlags = null;
        String noDateTime = null;
        if (!this.imapClient.append(mailboxName, noFlags, noDateTime, message)) {
            throw new RuntimeException(this.imapClient.getReplyString());
        }
        return this;
    }

    public TestIMAPClient delete(String mailbox) throws IOException {
        this.imapClient.delete(mailbox);
        return this;
    }

    public boolean hasAMessage() throws IOException {
        this.imapClient.fetch("1", "UID");
        return this.imapClient.getReplyString().contains("OK FETCH completed");
    }

    public TestIMAPClient awaitMessage(ConditionFactory conditionFactory) {
        conditionFactory.until(this::hasAMessage);
        return this;
    }

    public TestIMAPClient awaitMessageCount(ConditionFactory conditionFactory, int messageCount) {
        conditionFactory.untilAsserted(() -> {
            this.imapClient.fetch("1:*", "UID");
            Assertions.assertThat((long)this.countFetchedEntries()).isEqualTo((long)messageCount);
        });
        return this;
    }

    private long countFetchedEntries() {
        return Splitter.on((String)"\n").trimResults().splitToStream((CharSequence)this.imapClient.getReplyString()).filter(s -> s.startsWith("*")).count();
    }

    public TestIMAPClient awaitNoMessage(ConditionFactory conditionFactory) {
        conditionFactory.until(this::userDoesNotReceiveMessage);
        return this;
    }

    public boolean hasAMessageWithFlags(String flags) throws IOException {
        this.imapClient.fetch("1:1", "ALL");
        String replyString = this.imapClient.getReplyString();
        return this.isCompletedWithFlags(flags, replyString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    boolean isCompletedWithFlags(String flags, String replyString) {
        if (!replyString.contains("OK FETCH completed")) return false;
        if (!Splitter.on((String)" ").splitToStream((CharSequence)flags).allMatch(replyString::contains)) return false;
        return true;
    }

    public boolean userGetNotifiedForNewMessagesWhenSelectingMailbox(int numOfNewMessage) {
        return this.imapClient.getReplyString().contains("OK [UNSEEN " + numOfNewMessage + "]");
    }

    public boolean userDoesNotReceiveMessage() throws IOException {
        this.imapClient.fetch("1:1", "ALL");
        return this.imapClient.getReplyString().contains("BAD FETCH failed. Invalid messageset");
    }

    public String readFirstMessage() throws IOException {
        return this.readFirstMessageInMailbox("(BODY[])");
    }

    public String readFirstMessageHeaders() throws IOException {
        return this.readFirstMessageInMailbox("(RFC822.HEADER)");
    }

    public String setFlagsForAllMessagesInMailbox(String flag) throws IOException {
        this.imapClient.store("1:*", "+FLAGS", flag);
        return this.imapClient.getReplyString();
    }

    public String copyAllMessagesInMailboxTo(String mailboxName) throws IOException {
        this.imapClient.copy("1:*", mailboxName);
        return this.imapClient.getReplyString();
    }

    public String readFirstMessageInMailbox(String parameters) throws IOException {
        this.imapClient.fetch("1:1", parameters);
        return this.imapClient.getReplyString();
    }

    public boolean userGetNotifiedForNewMessages(int numberOfMessages) throws IOException {
        this.imapClient.noop();
        String replyString = this.imapClient.getReplyString();
        List parts = Splitter.on((char)'\n').trimResults().omitEmptyStrings().splitToList((CharSequence)replyString);
        return parts.size() == 3 && ((String)parts.get(2)).contains("OK NOOP completed.") && parts.contains("* " + numberOfMessages + " EXISTS") && parts.contains("* " + numberOfMessages + " RECENT");
    }

    public boolean userGetNotifiedForDeletion(int msn) throws IOException {
        this.imapClient.noop();
        String replyString = this.imapClient.getReplyString();
        List parts = Splitter.on((char)'\n').trimResults().omitEmptyStrings().splitToList((CharSequence)replyString);
        return parts.size() == 2 && ((String)parts.get(1)).contains("OK NOOP completed.") && parts.contains("* " + msn + " EXPUNGE");
    }

    @Override
    public void close() throws IOException {
        if (this.imapClient.isConnected()) {
            this.imapClient.disconnect();
        }
    }

    protected void after() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.after();
    }

    public void copyFirstMessage(String destMailbox) throws IOException {
        this.imapClient.copy("1", destMailbox);
    }

    public void moveFirstMessage(String destMailbox) throws IOException {
        this.imapClient.sendCommand("MOVE 1 " + destMailbox);
    }

    public void expunge() throws IOException {
        this.imapClient.expunge();
    }

    public String getQuotaRoot(String mailbox) throws IOException {
        this.imapClient.sendCommand("GETQUOTAROOT " + mailbox);
        return this.imapClient.getReplyString();
    }

    public String sendCommand(String command) throws IOException {
        this.imapClient.sendCommand(command);
        return this.imapClient.getReplyString();
    }

    public long getMessageCount(String mailboxName) throws IOException {
        this.imapClient.examine(mailboxName);
        return Stream.of(this.imapClient.getReplyStrings()).map(EXAMINE_EXISTS::matcher).filter(Matcher::matches).map(m -> m.group(1)).mapToLong(Long::valueOf).sum();
    }

    public static class Utf8IMAPSClient
    extends AuthenticatingIMAPClient {
        protected void _connectAction_() throws IOException {
            super._connectAction_();
            this._reader = new CRLFLineReader((Reader)new InputStreamReader(this._input_, StandardCharsets.UTF_8));
            this.__writer = new BufferedWriter(new OutputStreamWriter(this._output_, StandardCharsets.UTF_8));
        }
    }
}

