/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.junit;

import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class TemporaryFolderExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    private TemporaryFolder temporaryFolder;

    public void beforeEach(ExtensionContext context) throws Exception {
        this.temporaryFolder = new TemporaryFolder(Files.createTempDir());
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == TemporaryFolder.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.temporaryFolder;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        FileUtils.deleteDirectory((File)this.temporaryFolder.getTempDir());
    }

    public TemporaryFolder getTemporaryFolder() {
        return this.temporaryFolder;
    }

    public static class TemporaryFolder {
        private final File tempDir;
        private final String folderPath;

        public TemporaryFolder(File tempDir) {
            this.tempDir = tempDir;
            this.folderPath = tempDir.getPath() + "/";
        }

        public File getTempDir() {
            return this.tempDir;
        }

        public String getFolderPath() {
            return this.folderPath;
        }
    }
}

