/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.numeric;
import java.io.Serializable;
import java.time.Duration;
import org.apache.james.rate.limiter.api.AllowedQuantity$;
import org.apache.james.rate.limiter.api.Increment$;
import org.apache.james.rate.limiter.api.Rule;
import org.apache.james.rate.limiter.api.Rules;
import org.apache.james.transport.mailets.ConfigurationOps$;
import org.apache.james.transport.mailets.Count$;
import org.apache.james.transport.mailets.EntityType;
import org.apache.james.transport.mailets.Recipients$;
import org.apache.james.transport.mailets.Size$;
import org.apache.james.transport.mailets.TotalSize$;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Try$;
import shapeless._0;

public final class EntityType$ {
    public static final EntityType$ MODULE$ = new EntityType$();

    public <E extends Throwable, A> EntityType.EitherOps<E, A> EitherOps(Either<E, A> either) {
        return new EntityType.EitherOps<E, A>(either);
    }

    public Option<Rules> extractRules(EntityType entityType, Duration duration, MailetConfig mailetConfig) {
        Option option;
        EntityType entityType2 = entityType;
        if (Count$.MODULE$.equals(entityType2)) {
            option = ConfigurationOps$.MODULE$.OptionOps(mailetConfig).getOptionalLong("count");
        } else if (Recipients$.MODULE$.equals(entityType2)) {
            option = ConfigurationOps$.MODULE$.OptionOps(mailetConfig).getOptionalLong("recipients");
        } else if (Size$.MODULE$.equals(entityType2)) {
            option = ConfigurationOps$.MODULE$.SizeOps(mailetConfig).getOptionalSize("size").map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.asBytes()));
        } else if (TotalSize$.MODULE$.equals(entityType2)) {
            option = ConfigurationOps$.MODULE$.SizeOps(mailetConfig).getOptionalSize("totalSize").map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.asBytes()));
        } else {
            throw new MatchError((Object)entityType2);
        }
        return option.map((Function1 & Serializable)x$4 -> new Refined((Object)EntityType$.$anonfun$extractRules$3(entityType, BoxesRunTime.unboxToLong((Object)x$4)))).map((Function1 & Serializable)quantity -> EntityType$.$anonfun$extractRules$4(duration, (Long)((Refined)quantity).value()));
    }

    public Option<Refined<Object, numeric.Greater<_0>>> extractQuantity(EntityType entityType, Mail mail) {
        EntityType entityType2 = entityType;
        if (Count$.MODULE$.equals(entityType2)) {
            return new Some((Object)new Refined((Object)((Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)1))).value())));
        }
        if (Recipients$.MODULE$.equals(entityType2)) {
            return new Some(this.EitherOps(Increment$.MODULE$.validate(mail.getRecipients().size())).orThrow("invalid quantity for " + entityType.asString()));
        }
        if (Size$.MODULE$.equals(entityType2)) {
            return new Some(this.EitherOps(Increment$.MODULE$.validate((int)mail.getMessageSize())).orThrow("invalid quantity for " + entityType.asString()));
        }
        if (TotalSize$.MODULE$.equals(entityType2)) {
            return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.multiplyExact((int)mail.getMessageSize(), mail.getRecipients().size())).map((Function1 & Serializable)x$5 -> new Refined((Object)EntityType$.$anonfun$extractQuantity$2(entityType, BoxesRunTime.unboxToInt((Object)x$5)))).toOption();
        }
        throw new MatchError((Object)entityType2);
    }

    public static final /* synthetic */ Long $anonfun$extractRules$3(EntityType entityType$1, long x$4) {
        return (Long)MODULE$.EitherOps(AllowedQuantity$.MODULE$.validate(x$4)).orThrow("invalid quantity for " + entityType$1.asString()).value();
    }

    public static final /* synthetic */ Rules $anonfun$extractRules$4(Duration duration$1, Long quantity) {
        return new Rules((Seq<Rule>)new .colon.colon((Object)new Rule(quantity, duration$1), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ Integer $anonfun$extractQuantity$2(EntityType entityType$2, int x$5) {
        return (Integer)MODULE$.EitherOps(Increment$.MODULE$.validate(x$5)).orThrow("invalid quantity for " + entityType$2.asString()).value();
    }

    private EntityType$() {
    }
}

