/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox.task;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.pop3server.mailbox.task.MessageInconsistenciesEntry;
import org.apache.james.pop3server.mailbox.task.MetaDataFixInconsistenciesService;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class MetaDataFixInconsistenciesTask
implements Task {
    public static final TaskType TASK_TYPE = TaskType.of((String)"Pop3MetaDataFixInconsistenciesTask");
    private final MetaDataFixInconsistenciesService metaDataFixInconsistenciesService;
    private final MetaDataFixInconsistenciesService.Context context;
    private final MetaDataFixInconsistenciesService.RunningOptions runningOptions;

    @Inject
    public MetaDataFixInconsistenciesTask(MetaDataFixInconsistenciesService metaDataFixInconsistenciesService, MetaDataFixInconsistenciesService.RunningOptions runningOptions) {
        this.metaDataFixInconsistenciesService = metaDataFixInconsistenciesService;
        this.context = new MetaDataFixInconsistenciesService.Context();
        this.runningOptions = runningOptions;
    }

    public Task.Result run() throws InterruptedException {
        return (Task.Result)this.metaDataFixInconsistenciesService.fixInconsistencies(this.context, this.runningOptions).block();
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.context, this.runningOptions));
    }

    public MetaDataFixInconsistenciesService.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final MetaDataFixInconsistenciesService.RunningOptions runningOptions;
        private final long processedImapUidEntries;
        private final long processedPop3MetaDataStoreEntries;
        private final long stalePOP3Entries;
        private final long missingPOP3Entries;
        private final ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies;
        private final ImmutableList<MessageInconsistenciesEntry> errors;

        public static AdditionalInformation from(MetaDataFixInconsistenciesService.Context context, MetaDataFixInconsistenciesService.RunningOptions runningOptions) {
            MetaDataFixInconsistenciesService.Context.Snapshot snapshot = context.snapshot();
            return new AdditionalInformation(Clock.systemUTC().instant(), runningOptions, snapshot.getProcessedImapUidEntries(), snapshot.getProcessedPop3MetaDataStoreEntries(), snapshot.getStalePOP3Entries(), snapshot.getMissingPOP3Entries(), snapshot.getFixedInconsistencies(), snapshot.getErrors());
        }

        public AdditionalInformation(Instant timestamp, MetaDataFixInconsistenciesService.RunningOptions runningOptions, long processedImapUidEntries, long processedPop3MetaDataStoreEntries, long stalePOP3Entries, long missingPOP3Entries, ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies, ImmutableList<MessageInconsistenciesEntry> errors) {
            this.timestamp = timestamp;
            this.runningOptions = runningOptions;
            this.processedImapUidEntries = processedImapUidEntries;
            this.processedPop3MetaDataStoreEntries = processedPop3MetaDataStoreEntries;
            this.stalePOP3Entries = stalePOP3Entries;
            this.missingPOP3Entries = missingPOP3Entries;
            this.fixedInconsistencies = fixedInconsistencies;
            this.errors = errors;
        }

        public MetaDataFixInconsistenciesService.RunningOptions getRunningOptions() {
            return this.runningOptions;
        }

        public long getProcessedImapUidEntries() {
            return this.processedImapUidEntries;
        }

        public long getProcessedPop3MetaDataStoreEntries() {
            return this.processedPop3MetaDataStoreEntries;
        }

        public long getStalePOP3Entries() {
            return this.stalePOP3Entries;
        }

        public long getMissingPOP3Entries() {
            return this.missingPOP3Entries;
        }

        public ImmutableList<MessageInconsistenciesEntry> getFixedInconsistencies() {
            return this.fixedInconsistencies;
        }

        public ImmutableList<MessageInconsistenciesEntry> getErrors() {
            return this.errors;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

