/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox;

import jakarta.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.pop3server.mailbox.Pop3MetadataStore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PopulateMetadataStoreListener
implements EventListener.ReactiveGroupEventListener {
    static final Group GROUP = new PopulateMetadataStoreListenerGroup();
    private static final int CONCURRENCY = 5;
    private final Pop3MetadataStore metadataStore;

    @Inject
    public PopulateMetadataStoreListener(Pop3MetadataStore metadataStore) {
        this.metadataStore = metadataStore;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.Added || event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.MailboxDeletion;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.Added) {
            return this.handleAdded((MailboxEvents.Added)event);
        }
        if (event instanceof MailboxEvents.Expunged) {
            return this.handleExpunged((MailboxEvents.Expunged)event);
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            return this.handleMailboxDeletion((MailboxEvents.MailboxDeletion)event);
        }
        return Mono.empty();
    }

    private Publisher<Void> handleMailboxDeletion(MailboxEvents.MailboxDeletion mailboxDeletion) {
        return this.metadataStore.clear(mailboxDeletion.getMailboxId());
    }

    private Publisher<Void> handleExpunged(MailboxEvents.Expunged expunged) {
        return Flux.fromStream(expunged.getUids().stream().map(arg_0 -> ((MailboxEvents.Expunged)expunged).getMetaData(arg_0))).concatMap(message -> this.metadataStore.remove(expunged.getMailboxId(), message.getMessageId())).then();
    }

    private Mono<Void> handleAdded(MailboxEvents.Added added) {
        return Flux.fromStream(added.getUids().stream().map(arg_0 -> ((MailboxEvents.Added)added).getMetaData(arg_0))).flatMap(messageMetaData -> this.handleAdded(added, (MessageMetaData)messageMetaData), 5).then();
    }

    private Mono<Void> handleAdded(MailboxEvents.Added added, MessageMetaData messageMetaData) {
        return Mono.from(this.metadataStore.add(added.getMailboxId(), new Pop3MetadataStore.StatMetadata(messageMetaData.getMessageId(), messageMetaData.getSize())));
    }

    public static class PopulateMetadataStoreListenerGroup
    extends Group {
    }
}

