/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Optional;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.jmap.JMAPModule;
import org.apache.james.server.core.JamesServerResourceLoader;
import org.apache.james.server.core.MissingArgumentException;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.utils.PropertiesProvider;

public class MemoryJamesConfiguration
implements Configuration {
    private final Configuration.ConfigurationPath configurationPath;
    private final JamesDirectoriesProvider directories;
    private final UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation;
    private final boolean jmapEnabled;
    private final boolean dropListsEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public MemoryJamesConfiguration(Configuration.ConfigurationPath configurationPath, JamesDirectoriesProvider directories, UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation, boolean jmapEnabled, boolean dropListsEnabled) {
        this.configurationPath = configurationPath;
        this.directories = directories;
        this.usersRepositoryImplementation = usersRepositoryImplementation;
        this.jmapEnabled = jmapEnabled;
        this.dropListsEnabled = dropListsEnabled;
    }

    public Configuration.ConfigurationPath configurationPath() {
        return this.configurationPath;
    }

    public JamesDirectoriesProvider directories() {
        return this.directories;
    }

    public UsersRepositoryModuleChooser.Implementation getUsersRepositoryImplementation() {
        return this.usersRepositoryImplementation;
    }

    public boolean isJmapEnabled() {
        return this.jmapEnabled;
    }

    public boolean isDropListsEnabled() {
        return this.dropListsEnabled;
    }

    public static class Builder {
        private Optional<String> rootDirectory = Optional.empty();
        private Optional<Configuration.ConfigurationPath> configurationPath = Optional.empty();
        private Optional<UsersRepositoryModuleChooser.Implementation> usersRepositoryImplementation = Optional.empty();
        private Optional<Boolean> jmapEnabled = Optional.empty();
        private Optional<Boolean> dropListsEnabled = Optional.empty();

        private Builder() {
        }

        public Builder workingDirectory(String path) {
            this.rootDirectory = Optional.of(path);
            return this;
        }

        public Builder workingDirectory(File file) {
            this.rootDirectory = Optional.of(file.getAbsolutePath());
            return this;
        }

        public Builder useWorkingDirectoryEnvProperty() {
            this.rootDirectory = Optional.ofNullable(System.getProperty("working.directory"));
            if (!this.rootDirectory.isPresent()) {
                throw new MissingArgumentException("Server needs a working.directory env entry");
            }
            return this;
        }

        public Builder configurationPath(Configuration.ConfigurationPath path) {
            this.configurationPath = Optional.of(path);
            return this;
        }

        public Builder configurationFromClasspath() {
            this.configurationPath = Optional.of(new Configuration.ConfigurationPath("classpath:"));
            return this;
        }

        public Builder usersRepository(UsersRepositoryModuleChooser.Implementation implementation) {
            this.usersRepositoryImplementation = Optional.of(implementation);
            return this;
        }

        public Builder enableJMAP() {
            this.jmapEnabled = Optional.of(true);
            return this;
        }

        public Builder enableDropLists() {
            this.dropListsEnabled = Optional.of(true);
            return this;
        }

        public MemoryJamesConfiguration build() {
            Configuration.ConfigurationPath configurationPath = this.configurationPath.orElse(new Configuration.ConfigurationPath("file://conf/"));
            JamesServerResourceLoader directories = new JamesServerResourceLoader(this.rootDirectory.orElseThrow(() -> new MissingArgumentException("Server needs a working.directory env entry")));
            FileSystemImpl fileSystem = new FileSystemImpl((JamesDirectoriesProvider)directories);
            FileConfigurationProvider configurationProvider = new FileConfigurationProvider((FileSystem)fileSystem, (Configuration)Configuration.Basic.builder().configurationPath(configurationPath).workingDirectory(directories.getRootDirectory()).build());
            UsersRepositoryModuleChooser.Implementation usersRepositoryChoice = this.usersRepositoryImplementation.orElseGet(() -> UsersRepositoryModuleChooser.Implementation.parse((FileConfigurationProvider)configurationProvider));
            boolean jmapEnabled = this.jmapEnabled.orElseGet(() -> {
                PropertiesProvider propertiesProvider = new PropertiesProvider((FileSystem)fileSystem, configurationPath);
                try {
                    return JMAPModule.parseConfiguration((PropertiesProvider)propertiesProvider).isEnabled();
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            });
            boolean dropListsEnabled = this.dropListsEnabled.orElseGet(() -> {
                PropertiesProvider propertiesProvider = new PropertiesProvider((FileSystem)fileSystem, configurationPath);
                try {
                    return propertiesProvider.getConfiguration("droplists").getBoolean("enabled", false);
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            });
            return new MemoryJamesConfiguration(configurationPath, (JamesDirectoriesProvider)directories, usersRepositoryChoice, jmapEnabled, dropListsEnabled);
        }
    }
}

