/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.blob;

import jakarta.inject.Named;
import jakarta.mail.internet.MimeMessage;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryFactory;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.blob.BlobMailRepository;
import org.apache.james.mailrepository.blob.MailRepositoryBlobIdFactory;
import org.apache.james.server.blob.deduplication.BlobStoreFactory;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\u0005\u000b\u0001UA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u0003D\u0001\u0011\u0005A\tC\u0004L\u0001\t\u0007I\u0011\t'\t\r}\u0003\u0001\u0015!\u0003N\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015y\u0007\u0001\"\u0003q\u0005e\u0011En\u001c2NC&d'+\u001a9pg&$xN]=GC\u000e$xN]=\u000b\u0005-a\u0011\u0001\u00022m_\nT!!\u0004\b\u0002\u001d5\f\u0017\u000e\u001c:fa>\u001c\u0018\u000e^8ss*\u0011q\u0002E\u0001\u0006U\u0006lWm\u001d\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011b\u0004\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\r=\u0013'.Z2u!\ty\"%D\u0001!\u0015\t\tC\"A\u0002ba&L!a\t\u0011\u0003+5\u000b\u0017\u000e\u001c*fa>\u001c\u0018\u000e^8ss\u001a\u000b7\r^8ss\u0006a!\r\\8c'R|'/\u001a#b_B\u0011a%K\u0007\u0002O)\u0011\u0011\u0005\u000b\u0006\u0003\u00179I!AK\u0014\u0003\u0019\tcwNY*u_J,G)Q(\u0002\u001b\tdwNY%e\r\u0006\u001cGo\u001c:z!\ti\u0003G\u0004\u0002']%\u0011qfJ\u0001\u0007\u00052|'-\u00133\n\u0005E\u0012$a\u0002$bGR|'/\u001f\u0006\u0003_\u001d\n\u0011\u0003Z3gCVdGOQ;dW\u0016$h*Y7f!\t1S'\u0003\u00027O\tQ!)^2lKRt\u0015-\\3)\t\rA\u0004)\u0011\t\u0003syj\u0011A\u000f\u0006\u0003wq\na!\u001b8kK\u000e$(\"A\u001f\u0002\u000f)\f7.\u0019:uC&\u0011qH\u000f\u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0002\u0005\u0006iA-\u001a4bk2$()^2lKR\fa\u0001P5oSRtD\u0003B#H\u0011&\u0003\"A\u0012\u0001\u000e\u0003)AQ\u0001\n\u0003A\u0002\u0015BQa\u000b\u0003A\u00021BQa\r\u0003A\u0002QBC!\u0013\u001dA\u0003\u0006\u0019R.Y5m%\u0016\u0004xn]5u_JL8\t\\1tgV\tQ\n\r\u0002O;B\u0019q\nW.\u000f\u0005A3\u0006CA)U\u001b\u0005\u0011&BA*\u0015\u0003\u0019a$o\\8u})\tQ+A\u0003tG\u0006d\u0017-\u0003\u0002X)\u00061\u0001K]3eK\u001aL!!\u0017.\u0003\u000b\rc\u0017m]:\u000b\u0005]#\u0006C\u0001/^\u0019\u0001!\u0011B\u0018\u0004\u0002\u0002\u0003\u0005)\u0011\u00011\u0003\u0007}#\u0013'\u0001\u000bnC&d'+\u001a9pg&$xN]=DY\u0006\u001c8\u000fI\t\u0003C\u0016\u0004\"AY2\u000e\u0003QK!\u0001\u001a+\u0003\u000f9{G\u000f[5oOB\u0011qDZ\u0005\u0003O\u0002\u0012a\"T1jYJ+\u0007o\\:ji>\u0014\u00180\u0001\u0004de\u0016\fG/\u001a\u000b\u0003K*DQa[\u0004A\u00021\f1!\u001e:m!\tyR.\u0003\u0002oA\t\tR*Y5m%\u0016\u0004xn]5u_JLXK\u001d7\u0002+\t,\u0018\u000e\u001c3NS6,W*Z:tC\u001e,7\u000b^8sKR\u0019\u0011/a\u0001\u0011\t\u0019\u0012H\u000f`\u0005\u0003g\u001e\u0012Qa\u0015;pe\u0016\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\u0011%tG/\u001a:oKRT!!\u001f\u001f\u0002\t5\f\u0017\u000e\\\u0005\u0003wZ\u00141\"T5nK6+7o]1hKB\u0011Qp`\u0007\u0002}*\u0011\u0011\u0010K\u0005\u0004\u0003\u0003q(AE'j[\u0016lUm]:bO\u0016\u0004\u0016M\u001d;t\u0013\u0012DQa\u001b\u0005A\u00021\u0004")
public class BlobMailRepositoryFactory
implements MailRepositoryFactory {
    private final BlobStoreDAO blobStoreDao;
    private final BlobId.Factory blobIdFactory;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final Class<? extends MailRepository> mailRepositoryClass;

    public Class<? extends MailRepository> mailRepositoryClass() {
        return this.mailRepositoryClass;
    }

    public MailRepository create(MailRepositoryUrl url) {
        MailRepositoryUrl metadataUrl = url.subUrl("mailMetadata");
        MailRepositoryBlobIdFactory metadataIdFactory = new MailRepositoryBlobIdFactory(this.blobIdFactory, metadataUrl);
        BlobStore metadataBlobStore = BlobStoreFactory.builder().blobStoreDAO(this.blobStoreDao).blobIdFactory((BlobId.Factory)metadataIdFactory).bucket(this.defaultBucketName).passthrough();
        Store<MimeMessage, MimeMessagePartsId> mimeMessageStore = this.buildMimeMessageStore(url);
        return new BlobMailRepository(metadataBlobStore, metadataIdFactory, mimeMessageStore, metadataUrl);
    }

    private Store<MimeMessage, MimeMessagePartsId> buildMimeMessageStore(MailRepositoryUrl url) {
        MailRepositoryBlobIdFactory mimeMessageIdFactory = new MailRepositoryBlobIdFactory(this.blobIdFactory, url.subUrl("mimeMessagedata"));
        BlobStore mimeMessageBlobStore = BlobStoreFactory.builder().blobStoreDAO(this.blobStoreDao).blobIdFactory((BlobId.Factory)mimeMessageIdFactory).bucket(this.defaultBucketName).passthrough();
        Store mimeMessageStore = new MimeMessageStore.Factory(mimeMessageBlobStore).mimeMessageStore();
        return mimeMessageStore;
    }

    public BlobMailRepositoryFactory(BlobStoreDAO blobStoreDao, BlobId.Factory blobIdFactory, @Named(value="defaultBucket") BucketName defaultBucketName) {
        this.blobStoreDao = blobStoreDao;
        this.blobIdFactory = blobIdFactory;
        this.defaultBucketName = defaultBucketName;
        this.mailRepositoryClass = BlobMailRepository.class;
    }
}

