/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.blob;

import com.google.common.collect.ImmutableMap;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobPartsId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobType;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.blob.BlobMailRepository;
import org.apache.james.mailrepository.blob.BlobMailRepository$MailPartsId$;
import org.apache.james.mailrepository.blob.Header;
import org.apache.james.mailrepository.blob.MailMetadata;
import org.apache.james.mailrepository.blob.MailMetadata$;
import org.apache.james.mailrepository.blob.MailRepositoryBlobIdFactory;
import org.apache.james.mailrepository.blob.serializers$;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.AuditTrail;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.reactivestreams.Publisher;
import play.api.libs.json.Json$;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.util.function.Tuples;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StepperShape$;
import scala.collection.convert.StreamExtensions;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.jdk.StreamConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011mq!B\u001f?\u0011\u0003Ie!B&?\u0011\u0003a\u0005\"B*\u0002\t\u0003!vAB+\u0002\u0011\u0003qdK\u0002\u0004Y\u0003!\u0005a(\u0017\u0005\u0006'\u0012!\tA\u0019\u0005\tG\u0012\u0011\r\u0011\"\u0001?I\"1A\u000e\u0002Q\u0001\n\u00154A!\u001c\u0003\u0001]\"11\u000b\u0003C\u0001\u0003\u0017Dq!!5\t\t\u0003\n\u0019\u000eC\u0005\u0002f\u0012\t\t\u0011\"!\u0002h\"I\u00111\u001e\u0003\u0002\u0002\u0013\u0005\u0015Q\u001e\u0005\n\u0003s$\u0011\u0011!C\u0005\u0003w4Q\u0001W\u0001A}uD!\"a\b\u000f\u0005+\u0007I\u0011AA\u0011\u0011)\tIC\u0004B\tB\u0003%\u00111\u0005\u0005\b':!\tAPA\u0016\u0011\u001d\t\tD\u0004C!\u0003gAq!!\u0014\u000f\t\u0003\ty\u0005C\u0005\u0002\\9\t\t\u0011\"\u0001\u0002^!I\u0011\u0011\r\b\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003sr\u0011\u0011!C!\u0003wB\u0011\"a!\u000f\u0003\u0003%\t!!\"\t\u0013\u00055e\"!A\u0005\u0002\u0005=\u0005\"CAN\u001d\u0005\u0005I\u0011IAO\u0011%\tYKDA\u0001\n\u0003\ti\u000bC\u0005\u00028:\t\t\u0011\"\u0011\u0002:\"I\u0011Q\u0018\b\u0002\u0002\u0013\u0005\u0013q\u0018\u0005\n\u0003\u0003t\u0011\u0011!C!\u0003\u0007D\u0011\"!2\u000f\u0003\u0003%\t%a2\u0007\u000f\u0005u\u0018\u0001\u0001 \u0002\u0000\"Q!\u0011J\u0010\u0003\u0002\u0003\u0006IAa\u0013\t\u000fM{B\u0011\u0001 \u0003R!9!qK\u0010\u0005B\teca\u0002BC\u0003\u0001q$q\u0011\u0005\u000b\u0005\u0013\u001a#\u0011!Q\u0001\n\t=\u0005bB*$\t\u0003q$1\u0014\u0005\b\u0005C\u001bC\u0011\u0002BR\u0011\u001d\u0011yk\tC\u0005\u0005cCqAa7$\t\u0003\u0012iNB\u0003L}\u0001\u0011i\u000f\u0003\u0006\u0003v&\u0012)\u0019!C\u0001\u0005oD!Ba@*\u0005\u0003\u0005\u000b\u0011\u0002B}\u0011)\u0019\t!\u000bBC\u0002\u0013\u000511\u0001\u0005\u000b\u0007\u000bI#\u0011!Q\u0001\n\t-\u0003BCB\u0004S\t\u0015\r\u0011\"\u0001\u0004\n!Q11E\u0015\u0003\u0002\u0003\u0006Iaa\u0003\t\u0015\r\u0015\u0012F!b\u0001\n\u0003\u00199\u0003\u0003\u0006\u00040%\u0012\t\u0011)A\u0005\u0007SAaaU\u0015\u0005\u0002\rE\u0002bBB\u001fS\u0011\u00053q\b\u0005\b\u0007\u000bKC\u0011IBD\u0011\u001d\u0019Y*\u000bC!\u0007;Cqaa,*\t\u0013\u0019\t\fC\u0004\u00048&\"\te!/\t\u000f\r-\u0017\u0006\"\u0011\u0004N\"911Z\u0015\u0005\n\r\r\bbBB\u0000S\u0011\u0005C\u0011\u0001\u0005\n\t\u001fI#\u0019!C\u0005\t#A\u0001\u0002\"\u0007*A\u0003%A1C\u0001\u0013\u00052|'-T1jYJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002@\u0001\u0006!!\r\\8c\u0015\t\t%)\u0001\bnC&d'/\u001a9pg&$xN]=\u000b\u0005\r#\u0015!\u00026b[\u0016\u001c(BA#G\u0003\u0019\t\u0007/Y2iK*\tq)A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002K\u00035\taH\u0001\nCY>\u0014W*Y5m%\u0016\u0004xn]5u_JL8CA\u0001N!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!S\u0001\f\u001b\u0006LG\u000eU1siNLE\r\u0005\u0002X\t5\t\u0011AA\u0006NC&d\u0007+\u0019:ug&#7c\u0001\u0003N5B\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0003S>T\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b9\na1+\u001a:jC2L'0\u00192mKR\ta+\u0001\nN\u000bR\u000bE)\u0011+B?\ncuJQ0U3B+U#A3\u0011\u0005\u0019TW\"A4\u000b\u0005!L\u0017aA1qS*\u0011qHQ\u0005\u0003W\u001e\u0014\u0001B\u00117pERK\b/Z\u0001\u0014\u001b\u0016#\u0016\tR!U\u0003~\u0013Ej\u0014\"`)f\u0003V\t\t\u0002\b\r\u0006\u001cGo\u001c:z'\rAq.\u001e\t\u0003aNl\u0011!\u001d\u0006\u0003ez\u000bA\u0001\\1oO&\u0011A/\u001d\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007YL8P\u0004\u0002go&\u0011\u0001pZ\u0001\f\u00052|'\rU1siNLE-\u0003\u0002nu*\u0011\u0001p\u001a\t\u0003y:q!A\u0013\u0001\u0014\u000f9yg0a\u0001\u0002\nA\u0011am`\u0005\u0004\u0003\u00039'a\u0003\"m_\n\u0004\u0016M\u001d;t\u0013\u0012\u00042ATA\u0003\u0013\r\t9a\u0014\u0002\b!J|G-^2u!\u0011\tY!a\u0007\u000f\t\u00055\u0011q\u0003\b\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003%\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0016bAA\r\u001f\u00069\u0001/Y2lC\u001e,\u0017bA1\u0002\u001e)\u0019\u0011\u0011D(\u0002\u001d5,G/\u00193bi\u0006\u0014En\u001c2JIV\u0011\u00111\u0005\t\u0004M\u0006\u0015\u0012bAA\u0014O\n1!\t\\8c\u0013\u0012\fq\"\\3uC\u0012\fG/\u0019\"m_\nLE\r\t\u000b\u0005\u0003[\ty\u0003\u0005\u0002X\u001d!9\u0011qD\tA\u0002\u0005\r\u0012!B1t\u001b\u0006\u0004HCAA\u001b!\u001d\t9$!\u0013f\u0003Gi!!!\u000f\u000b\t\u0005m\u0012QH\u0001\bG>dG.Z2u\u0015\u0011\ty$!\u0011\u0002\r\r|W.\\8o\u0015\u0011\t\u0019%!\u0012\u0002\r\u001d|wn\u001a7f\u0015\t\t9%A\u0002d_6LA!a\u0013\u0002:\ta\u0011*\\7vi\u0006\u0014G.Z'ba\u0006IAo\\'bS2\\U-_\u000b\u0003\u0003#\u0002B!a\u0015\u0002X5\u0011\u0011Q\u000b\u0006\u0003Q\u0002KA!!\u0017\u0002V\t9Q*Y5m\u0017\u0016L\u0018\u0001B2paf$B!!\f\u0002`!I\u0011q\u0004\u000b\u0011\u0002\u0003\u0007\u00111E\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)G\u000b\u0003\u0002$\u0005\u001d4FAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Mt*\u0001\u0006b]:|G/\u0019;j_:LA!a\u001e\u0002n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\bE\u0002q\u0003\u007fJ1!!!r\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0011\t\u0004\u001d\u0006%\u0015bAAF\u001f\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011SAL!\rq\u00151S\u0005\u0004\u0003+{%aA!os\"I\u0011\u0011\u0014\r\u0002\u0002\u0003\u0007\u0011qQ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0005CBAQ\u0003O\u000b\t*\u0004\u0002\u0002$*\u0019\u0011QU(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002*\u0006\r&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a,\u00026B\u0019a*!-\n\u0007\u0005MvJA\u0004C_>dW-\u00198\t\u0013\u0005e%$!AA\u0002\u0005E\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!! \u0002<\"I\u0011\u0011T\u000e\u0002\u0002\u0003\u0007\u0011qQ\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qQ\u0001\ti>\u001cFO]5oOR\u0011\u0011QP\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\u0016\u0011\u001a\u0005\n\u00033s\u0012\u0011!a\u0001\u0003##\"!!4\u0011\u0007\u0005=\u0007\"D\u0001\u0005\u0003!9WM\\3sCR,G\u0003BA\u0017\u0003+Dq!a6\u000b\u0001\u0004\tI.A\u0002nCB\u0004r!a7\u0002b\u0016\f\u0019#\u0004\u0002\u0002^*\u0019\u0011q\u001c0\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\fiNA\u0002NCB\fQ!\u00199qYf$B!!\f\u0002j\"9\u0011qD\u0006A\u0002\u0005\r\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0003_\f)\u0010E\u0003O\u0003c\f\u0019#C\u0002\u0002t>\u0013aa\u00149uS>t\u0007\"CA|\u0019\u0005\u0005\t\u0019AA\u0017\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002_\nYQ*Y5m\u000b:\u001cw\u000eZ3s'\u0011yrN!\u0001\u0011\r\t\r!Q\u0005B\u0016\u001d\u0011\u0011)Aa\b\u000f\t\t\u001d!1\u0004\b\u0005\u0005\u0013\u0011IB\u0004\u0003\u0003\f\t]a\u0002\u0002B\u0007\u0005+qAAa\u0004\u0003\u00149!\u0011q\u0002B\t\u0013\u00059\u0015BA#G\u0013\t\u0019E)\u0003\u0002@\u0005&\u0011\u0001.[\u0005\u0004\u0005;9\u0017!B*u_J,\u0017\u0002\u0002B\u0011\u0005G\tA!S7qY*\u0019!QD4\n\t\t\u001d\"\u0011\u0006\u0002\b\u000b:\u001cw\u000eZ3s\u0015\u0011\u0011\tCa\t\u0011\u000f9\u0013iC!\r\u0003>%\u0019!qF(\u0003\rQ+\b\u000f\\33!\u0011\u0011\u0019D!\u000f\u000e\u0005\tU\"b\u0001B\u001c\t\u00061Q.Y5mKRLAAa\u000f\u00036\t!Q*Y5m!\u0011\u0011yD!\u0012\u000e\u0005\t\u0005#b\u0001B\"S\u0006!Q.Y5m\u0013\u0011\u00119E!\u0011\u0003%5KW.Z'fgN\fw-\u001a)beR\u001c\u0018\nZ\u0001\u000eE2|'-\u00133GC\u000e$xN]=\u0011\u0007)\u0013i%C\u0002\u0003Py\u00121$T1jYJ+\u0007o\\:ji>\u0014\u0018P\u00117pE&#g)Y2u_JLH\u0003\u0002B*\u0005+\u0002\"aV\u0010\t\u000f\t%\u0013\u00051\u0001\u0003L\u00051QM\\2pI\u0016$BAa\u0017\u0003\u0002B1!Q\fB2\u0005Oj!Aa\u0018\u000b\t\t\u0005\u0014Q\\\u0001\u0007gR\u0014X-Y7\n\t\t\u0015$q\f\u0002\u0007'R\u0014X-Y7\u0011\u000f\t%$qO3\u0003|5\u0011!1\u000e\u0006\u0005\u0005[\u0012y'A\u0003ukBdWM\u0003\u0003\u0003r\tM\u0014!\u00027b]\u001e\u001c$b\u0001B;\t\u000691m\\7n_:\u001c\u0018\u0002\u0002B=\u0005W\u0012A\u0001U1jeB!!1\u0001B?\u0013\u0011\u0011yH!\u000b\u0003\u0017Y\u000bG.^3U_N\u000bg/\u001a\u0005\b\u0005\u0007\u0013\u0003\u0019\u0001B\u0016\u00039i\u0017-\u001b7B]\u0012\u0004\u0016M\u001d;t\u0013\u0012\u00141\"T1jY\u0012+7m\u001c3feN!1e\u001cBE!\u0019\u0011\u0019Aa#\u0003,%!!Q\u0012B\u0015\u0005\u001d!UmY8eKJ\u0004BA!%\u0003\u0018:\u0019aMa%\n\u0007\tUu-\u0001\u0004CY>\u0014\u0017\nZ\u0005\u0004[\ne%b\u0001BKOR!!Q\u0014BP!\t96\u0005C\u0004\u0003J\u0015\u0002\rAa$\u0002\u0011I,\u0017\rZ'bS2$BA!\r\u0003&\"9!q\u0015\u0014A\u0002\t%\u0016\u0001D7bS2lU\r^1eCR\f\u0007c\u0001&\u0003,&\u0019!Q\u0016 \u0003\u00195\u000b\u0017\u000e\\'fi\u0006$\u0017\r^1\u00027I,GO]5fm\u0016\u0004VM\u001d*fG&\u0004\u0018.\u001a8u\u0011\u0016\fG-\u001a:t)\u0011\u0011\u0019L!/\u0011\t\tM\"QW\u0005\u0005\u0005o\u0013)DA\nQKJ\u0014VmY5qS\u0016tG\u000fS3bI\u0016\u00148\u000fC\u0004\u0003<\u001e\u0002\rA!0\u0002'A,'OU3dSBLWM\u001c;IK\u0006$WM]:\u0011\u0011\t}&q\u0019Bf\u0005\u001ftAA!1\u0003DB\u0019\u0011qB(\n\u0007\t\u0015w*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\u0014IMC\u0002\u0003F>\u0003BAa0\u0003N&!\u0011\u0011\u0011Be!\u0019\tYA!5\u0003V&!!1[A\u000f\u0005!IE/\u001a:bE2,\u0007c\u0001&\u0003X&\u0019!\u0011\u001c \u0003\r!+\u0017\rZ3s\u0003\u0019!WmY8eKR!!1\u0006Bp\u0011\u001d\u0011\t\u000f\u000ba\u0001\u0005G\fqa\u001d;sK\u0006l7\u000fE\u0004\u0002\\\u0006\u0005XM!:\u0011\t\t\u001d(\u0011\u001e\b\u0004M\nm\u0011\u0002\u0002Bv\u0005G\u00111c\u00117pg\u0016\f'\r\\3CsR,7k\\;sG\u0016\u001cB!K8\u0003pB!\u00111\u000bBy\u0013\u0011\u0011\u00190!\u0016\u0003\u001d5\u000b\u0017\u000e\u001c*fa>\u001c\u0018\u000e^8ss\u0006)R.Y5m\u001b\u0016$\u0018\rR1uC\ncwNY*u_J,WC\u0001B}!\r1'1`\u0005\u0004\u0005{<'!\u0003\"m_\n\u001cFo\u001c:f\u0003Yi\u0017-\u001b7NKR\fG)\u0019;b\u00052|'m\u0015;pe\u0016\u0004\u0013!G7bS2lU\r^1eCR\f'\t\\8c\u0013\u00124\u0015m\u0019;pef,\"Aa\u0013\u000255\f\u0017\u000e\\'fi\u0006$\u0017\r^1CY>\u0014\u0017\n\u001a$bGR|'/\u001f\u0011\u0002!5LW.Z'fgN\fw-Z*u_J,WCAB\u0006!\u001d17QBB\t\u0005{I1aa\u0004h\u0005\u0015\u0019Fo\u001c:f!\u0011\u0019\u0019ba\b\u000e\u0005\rU!\u0002BB\f\u00073\t\u0001\"\u001b8uKJtW\r\u001e\u0006\u0005\u0005\u0007\u001aYB\u0003\u0002\u0004\u001e\u00059!.Y6beR\f\u0017\u0002BB\u0011\u0007+\u00111\"T5nK6+7o]1hK\u0006\tR.[7f\u001b\u0016\u001c8/Y4f'R|'/\u001a\u0011\u0002\u0007U\u0014H.\u0006\u0002\u0004*A!\u00111KB\u0016\u0013\u0011\u0019i#!\u0016\u0003#5\u000b\u0017\u000e\u001c*fa>\u001c\u0018\u000e^8ssV\u0013H.\u0001\u0003ve2\u0004CCCB\u001a\u0007k\u00199d!\u000f\u0004<A\u0011!*\u000b\u0005\b\u0005k\u0014\u0004\u0019\u0001B}\u0011\u001d\u0019\tA\ra\u0001\u0005\u0017Bqaa\u00023\u0001\u0004\u0019Y\u0001C\u0004\u0004&I\u0002\ra!\u000b\u0002\u000bM$xN]3\u0015\t\u0005E3\u0011\t\u0005\b\u0007\u0007\u001a\u0004\u0019\u0001B\u0019\u0003\ti7\rK\u00034\u0007\u000f\u001a)\u0006E\u0003O\u0007\u0013\u001ai%C\u0002\u0004L=\u0013a\u0001\u001e5s_^\u001c\b\u0003BB(\u0007#j!a!\u0007\n\t\rM3\u0011\u0004\u0002\u0013\u001b\u0016\u001c8/Y4j]\u001e,\u0005pY3qi&|g.M\u0004\u001f\u0005\u0017\u001c9fa!2\u0013\r\u001aIf!\u0019\u0004z\r\rT\u0003BB.\u0007;*\"Aa3\u0005\u000f\r}\u0003A1\u0001\u0004j\t\tA+\u0003\u0003\u0004d\r\u0015\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0004h=\u000ba\u0001\u001e5s_^\u001c\u0018\u0003BB6\u0007c\u00022ATB7\u0013\r\u0019yg\u0014\u0002\b\u001d>$\b.\u001b8h!\u0011\u0019\u0019h!\u001e\u000f\u00079\u000b9\"\u0003\u0003\u0004x\u0005u!!\u0003+ie><\u0018M\u00197fc%\u001931PB?\u0007\u007f\u001a9GD\u0002O\u0007{J1aa\u001aPc\u0015\u0011cjTBA\u0005\u0015\u00198-\u00197bc\r13QJ\u0001\u0005g&TX\r\u0006\u0002\u0004\nB\u0019aja#\n\u0007\r5uJ\u0001\u0003M_:<\u0007&\u0002\u001b\u0004H\rE\u0015g\u0002\u0010\u0003L\u000eM5\u0011T\u0019\nG\re3\u0011MBK\u0007G\n\u0014bIB>\u0007{\u001a9ja\u001a2\u000b\truj!!2\u0007\u0019\u001ai%\u0001\u0003mSN$HCABP!\u0019\tYn!)\u0002R%!\u0011\u0011VAoQ\u0015)4qIBSc\u001dq\"1ZBT\u0007[\u000b\u0014bIB-\u0007C\u001aIka\u00192\u0013\r\u001aYh! \u0004,\u000e\u001d\u0014'\u0002\u0012O\u001f\u000e\u0005\u0015g\u0001\u0014\u0004N\u00059\"-\u001a7p]\u001e\u001cHk\\'bS2\u0014V\r]8tSR|'/\u001f\u000b\u0005\u0003_\u001b\u0019\fC\u0004\u00046Z\u0002\r!a\t\u0002\r\tdwNY%e\u0003!\u0011X\r\u001e:jKZ,G\u0003\u0002B\u0019\u0007wCqa!08\u0001\u0004\t\t&A\u0002lKfDSaNB$\u0007\u0003\ftA\bBf\u0007\u0007\u001cI-M\u0005$\u00073\u001a\tg!2\u0004dEJ1ea\u001f\u0004~\r\u001d7qM\u0019\u0006E9{5\u0011Q\u0019\u0004M\r5\u0013A\u0002:f[>4X\r\u0006\u0003\u0004P\u000eU\u0007c\u0001(\u0004R&\u001911[(\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007{C\u0004\u0019AA)Q\u0015A4qIBmc\u001dq\"1ZBn\u0007C\f\u0014bIB-\u0007C\u001aina\u00192\u0013\r\u001aYh! \u0004`\u000e\u001d\u0014'\u0002\u0012O\u001f\u000e\u0005\u0015g\u0001\u0014\u0004NQ!1Q]B~!\u0019\u00199oa>\u0004P6\u00111\u0011\u001e\u0006\u0005\u0007W\u001ci/A\u0005qk\nd\u0017n\u001d5fe*\u0019\u0001ka<\u000b\t\rE81_\u0001\u0005G>\u0014XM\u0003\u0002\u0004v\u00069!/Z1di>\u0014\u0018\u0002BB}\u0007S\u0014QaU'p]>Daa!@:\u0001\u0004Y\u0018AD7bS2lU\r^1eCR\f\u0017\nZ\u0001\ne\u0016lwN^3BY2$\"aa4)\u000bi\u001a9\u0005\"\u00022\u000fy\u0011Y\rb\u0002\u0005\u000eEJ1e!\u0017\u0004b\u0011%11M\u0019\nG\rm4Q\u0010C\u0006\u0007O\nTA\t(P\u0007\u0003\u000b4AJB'\u0003Ei\u0017-\u001b7NKR\fG-\u0019;b'R|'/Z\u000b\u0003\t'\u0001rAa:\u0005\u0016\t-20\u0003\u0003\u0005\u0018\t\r\"\u0001B%na2\f!#\\1jY6+G/\u00193bi\u0006\u001cFo\u001c:fA\u0001")
public class BlobMailRepository
implements MailRepository {
    private final BlobStore mailMetaDataBlobStore;
    private final MailRepositoryBlobIdFactory mailMetadataBlobIdFactory;
    private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;
    private final MailRepositoryUrl url;
    private final Store.Impl<Tuple2<Mail, MimeMessagePartsId>, MailPartsId> mailMetadataStore;

    public Publisher<Long> sizeReactive() {
        return super.sizeReactive();
    }

    public java.util.Iterator<MailKey> list(MailRepository.Condition condition) throws MessagingException {
        return super.list(condition);
    }

    public void remove(Collection<MailKey> keys) throws MessagingException {
        super.remove(keys);
    }

    public BlobStore mailMetaDataBlobStore() {
        return this.mailMetaDataBlobStore;
    }

    public MailRepositoryBlobIdFactory mailMetadataBlobIdFactory() {
        return this.mailMetadataBlobIdFactory;
    }

    public Store<MimeMessage, MimeMessagePartsId> mimeMessageStore() {
        return this.mimeMessageStore;
    }

    public MailRepositoryUrl url() {
        return this.url;
    }

    public MailKey store(Mail mc) throws MessagingException {
        return (MailKey)this.mimeMessageStore().save((Object)mc.getMessage()).flatMap(mimePartsId -> this.mailMetadataStore().save((Object)new Tuple2((Object)mc, mimePartsId))).doOnSuccess(x$3 -> AuditTrail.entry().protocol("mailrepository").action("store").parameters(() -> ImmutableMap.of((Object)"mailId", (Object)mc.getName(), (Object)"mimeMessageId", (Object)Option$.MODULE$.apply((Object)mc.getMessage()).flatMap((Function1 & Serializable)message -> Option$.MODULE$.apply((Object)message.getMessageID())).getOrElse((Function0 & Serializable)() -> ""), (Object)"sender", (Object)mc.getMaybeSender().asString(), (Object)"recipients", (Object)StringUtils.join((Object[])new Collection[]{mc.getRecipients()}))).log("BlobMailRepository stored mail.")).map(mailPartsId -> mailPartsId.toMailKey()).block();
    }

    public long size() throws MessagingException {
        return Predef$.MODULE$.Long2long((Long)Flux.from((Publisher)this.mailMetaDataBlobStore().listBlobs(this.mailMetaDataBlobStore().getDefaultBucketName())).filter(blobId -> this.belongsToMailRepository((BlobId)blobId)).count().block());
    }

    public java.util.Iterator<MailKey> list() throws MessagingException {
        return Flux.from((Publisher)this.mailMetaDataBlobStore().listBlobs(this.mailMetaDataBlobStore().getDefaultBucketName())).filter(blobId -> this.belongsToMailRepository((BlobId)blobId)).map(blobId -> new MailKey(blobId.asString())).toIterable().iterator();
    }

    private boolean belongsToMailRepository(BlobId blobId) {
        return blobId.asString().startsWith(this.url().getPath().asString());
    }

    public Mail retrieve(MailKey key) throws MessagingException {
        return (Mail)((Option)this.mailMetadataStore().read((BlobPartsId)BlobMailRepository$MailPartsId$.MODULE$.apply(this.mailMetadataBlobIdFactory().parse(key.asString()))).flatMap(x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Mail mail = (Mail)tuple2._1();
                MimeMessagePartsId mimeMessagePartsId = (MimeMessagePartsId)tuple2._2();
                return this.mimeMessageStore().read((Object)mimeMessagePartsId).map(mimeMessage -> {
                    mail.setMessage(mimeMessage);
                    return new Some((Object)mail);
                });
            }
            throw new MatchError((Object)tuple2);
        }).onErrorReturn((Object)None$.MODULE$).block()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void remove(MailKey key) throws MessagingException {
        MailPartsId mailMetadataId = BlobMailRepository$MailPartsId$.MODULE$.apply(this.mailMetadataBlobIdFactory().parse(key.asString()));
        SMono<BoxedUnit> qual$1 = this.remove(mailMetadataId);
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
    }

    private SMono<BoxedUnit> remove(MailPartsId mailMetadataId) {
        return SMono$.MODULE$.apply((Publisher)this.mailMetadataStore().read((BlobPartsId)mailMetadataId)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                MimeMessagePartsId mimeMessagePartsId = (MimeMessagePartsId)tuple2._2();
                return new Some((Object)mimeMessagePartsId);
            }
            throw new MatchError((Object)tuple2);
        }).onErrorRecover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x$4, Function1<A1, B1> function1) {
                A1 A1 = x$4;
                return (B1)None$.MODULE$;
            }

            public final boolean isDefinedAt(Throwable x$4) {
                Throwable throwable = x$4;
                return true;
            }
        }).flatMap((Function1 & Serializable)maybeMimeMessagePartsId -> SMono$.MODULE$.apply(this.mailMetadataStore().delete((BlobPartsId)mailMetadataId)).flatMap((Function1 & Serializable)x$6 -> {
            Void void_ = x$6;
            return SMono$.MODULE$.apply((Publisher)maybeMimeMessagePartsId.map((Function1 & Serializable)mimeMessagePartsId -> this.mimeMessageStore().delete(mimeMessagePartsId)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty())).map((Function1 & Serializable)x$5 -> {
                void_ = x$5;
                return BoxedUnit.UNIT;
            });
        }));
    }

    public void removeAll() throws MessagingException {
        Flux.from((Publisher)this.mailMetaDataBlobStore().listBlobs(this.mailMetaDataBlobStore().getDefaultBucketName())).flatMap(blobId -> this.remove(BlobMailRepository$MailPartsId$.MODULE$.apply((BlobId)blobId))).blockLast();
    }

    private Store.Impl<Tuple2<Mail, MimeMessagePartsId>, MailPartsId> mailMetadataStore() {
        return this.mailMetadataStore;
    }

    public BlobMailRepository(BlobStore mailMetaDataBlobStore, MailRepositoryBlobIdFactory mailMetadataBlobIdFactory, Store<MimeMessage, MimeMessagePartsId> mimeMessageStore, MailRepositoryUrl url) {
        this.mailMetaDataBlobStore = mailMetaDataBlobStore;
        this.mailMetadataBlobIdFactory = mailMetadataBlobIdFactory;
        this.mimeMessageStore = mimeMessageStore;
        this.url = url;
        this.mailMetadataStore = new Store.Impl((BlobPartsId.Factory)new MailPartsId.Factory(), (Store.Impl.Encoder)new MailEncoder(mailMetadataBlobIdFactory), (Store.Impl.Decoder)new MailDecoder(mailMetadataBlobIdFactory), mailMetaDataBlobStore, mailMetaDataBlobStore.getDefaultBucketName());
    }

    public static class MailDecoder
    implements Store.Impl.Decoder<Tuple2<Mail, MimeMessagePartsId>> {
        private final BlobId.Factory blobIdFactory;

        private Mail readMail(MailMetadata mailMetadata) {
            MailImpl.Builder builder = MailImpl.builder().name(mailMetadata.name()).sender((MaybeSender)mailMetadata.sender().map((Function1 & Serializable)sender -> MaybeSender.getMailSender((String)sender)).getOrElse((Function0 & Serializable)() -> MaybeSender.nullSender())).addRecipients(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)mailMetadata.recipients().map((Function1 & Serializable)x$2 -> new MailAddress(x$2))).asJavaCollection()).remoteAddr(mailMetadata.remoteAddr()).remoteHost(mailMetadata.remoteHost());
            mailMetadata.state().foreach((Function1 & Serializable)state -> builder.state(state));
            mailMetadata.errorMessage().foreach((Function1 & Serializable)errorMessage -> builder.errorMessage(errorMessage));
            mailMetadata.lastUpdated().map((Function1 & Serializable)x$1 -> Date.from(x$1)).foreach((Function1 & Serializable)lastUpdated -> builder.lastUpdated(lastUpdated));
            mailMetadata.attributes().foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return builder.addAttribute(new Attribute(AttributeName.of((String)name), AttributeValue.fromJsonString((String)value)));
                }
                throw new MatchError((Object)tuple2);
            });
            builder.addAllHeadersForRecipients(this.retrievePerRecipientHeaders(mailMetadata.perRecipientHeaders()));
            return builder.build();
        }

        private PerRecipientHeaders retrievePerRecipientHeaders(scala.collection.immutable.Map<String, Iterable<Header>> perRecipientHeaders) {
            PerRecipientHeaders result = new PerRecipientHeaders();
            perRecipientHeaders.foreach((Function1 & Serializable)x0$1 -> {
                MailDecoder.$anonfun$retrievePerRecipientHeaders$1(result, x0$1);
                return BoxedUnit.UNIT;
            });
            return result;
        }

        public Tuple2<Mail, MimeMessagePartsId> decode(Map<BlobType, Store.CloseableByteSource> streams) {
            Store.CloseableByteSource source = streams.get(BlobMailRepository$MailPartsId$.MODULE$.METADATA_BLOB_TYPE());
            MailMetadata value = (MailMetadata)Json$.MODULE$.fromJson(Json$.MODULE$.parse(source.openStream()), serializers$.MODULE$.mailMetadataFormat()).get();
            return new Tuple2((Object)this.readMail(value), (Object)value.mimePartsId(this.blobIdFactory));
        }

        public static final /* synthetic */ void $anonfun$retrievePerRecipientHeaders$2(PerRecipientHeaders result$1, String key$1, Header headers) {
            headers.values().foreach((Function1 & Serializable)header -> {
                PerRecipientHeaders.Header.Builder builder = PerRecipientHeaders.Header.builder().name(headers.key()).value(header);
                return result$1.addHeaderForRecipient(builder, new MailAddress(key$1));
            });
        }

        public static final /* synthetic */ void $anonfun$retrievePerRecipientHeaders$1(PerRecipientHeaders result$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Iterable value = (Iterable)tuple2._2();
                value.foreach((Function1 & Serializable)headers -> {
                    MailDecoder.$anonfun$retrievePerRecipientHeaders$2(result$1, key, headers);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public MailDecoder(BlobId.Factory blobIdFactory) {
            this.blobIdFactory = blobIdFactory;
        }
    }

    public static class MailEncoder
    implements Store.Impl.Encoder<Tuple2<Mail, MimeMessagePartsId>> {
        private final MailRepositoryBlobIdFactory blobIdFactory;

        public Stream<Pair<BlobType, Store.Impl.ValueToSave>> encode(Tuple2<Mail, MimeMessagePartsId> mailAndPartsId) {
            Tuple2<Mail, MimeMessagePartsId> tuple2 = mailAndPartsId;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Mail mail = (Mail)tuple2._1();
            MimeMessagePartsId partsIds = (MimeMessagePartsId)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mail, (Object)partsIds);
            Mail mail2 = (Mail)tuple22._1();
            MimeMessagePartsId partsIds2 = (MimeMessagePartsId)tuple22._2();
            MailMetadata mailMetadata = MailMetadata$.MODULE$.of(mail2, partsIds2);
            String payload = Json$.MODULE$.stringify(Json$.MODULE$.toJson((Object)mailMetadata, serializers$.MODULE$.mailMetadataFormat()));
            MailKey mailKey = MailKey.forMail((Mail)mail2);
            BlobId blobId = this.blobIdFactory.of(mailKey.asString());
            Store.Impl.ValueToSave save = (bucketName, blobStore) -> Mono.from((Publisher)blobStore.save(bucketName, (InputStream)new ByteArrayInputStream(payload.getBytes()), data -> SMono$.MODULE$.just((Object)Tuples.of((Object)blobId, (Object)data)).asJava(), BlobStore.StoragePolicy.SIZE_BASED));
            return (Stream)StreamConverters$.MODULE$.IterableHasSeqStream((IterableOnce)package$.MODULE$.LazyList().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Pair[]{Pair.of((Object)BlobMailRepository$MailPartsId$.MODULE$.METADATA_BLOB_TYPE(), (Object)save)}))).asJavaSeqStream(StreamExtensions.StreamShape$.MODULE$.anyStreamShape(), StepperShape$.MODULE$.baseStepperShape());
        }

        public MailEncoder(MailRepositoryBlobIdFactory blobIdFactory) {
            this.blobIdFactory = blobIdFactory;
        }
    }

    public static class MailPartsId
    implements BlobPartsId,
    Product,
    Serializable {
        private final BlobId metadataBlobId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public BlobId metadataBlobId() {
            return this.metadataBlobId;
        }

        public ImmutableMap<BlobType, BlobId> asMap() {
            return ImmutableMap.of((Object)BlobMailRepository$MailPartsId$.MODULE$.METADATA_BLOB_TYPE(), (Object)this.metadataBlobId());
        }

        public MailKey toMailKey() {
            return new MailKey(this.metadataBlobId().asString());
        }

        public MailPartsId copy(BlobId metadataBlobId) {
            return new MailPartsId(metadataBlobId);
        }

        public BlobId copy$default$1() {
            return this.metadataBlobId();
        }

        public String productPrefix() {
            return "MailPartsId";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.metadataBlobId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailPartsId;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "metadataBlobId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailPartsId)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailPartsId mailPartsId = (MailPartsId)x$1;
            BlobId blobId = this.metadataBlobId();
            BlobId blobId2 = mailPartsId.metadataBlobId();
            if (blobId == null) {
                if (blobId2 != null) {
                    return false;
                }
            } else if (!blobId.equals(blobId2)) return false;
            if (!mailPartsId.canEqual(this)) return false;
            return true;
        }

        public MailPartsId(BlobId metadataBlobId) {
            this.metadataBlobId = metadataBlobId;
            Product.$init$((Product)this);
        }
    }
}

