/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.james.mailets.configuration.SerializableAsXml;
import org.apache.james.transport.mailets.LocalDelivery;
import org.apache.james.transport.mailets.RemoteDelivery;
import org.apache.james.transport.mailets.RemoveMimeHeader;
import org.apache.james.transport.mailets.ToProcessor;
import org.apache.james.transport.matchers.All;
import org.apache.james.transport.matchers.RecipientIsLocal;
import org.apache.mailet.Mailet;
import org.apache.mailet.Matcher;

public class MailetConfiguration
implements SerializableAsXml {
    public static final MailetConfiguration BCC_STRIPPER = MailetConfiguration.builder().matcher(All.class).mailet(RemoveMimeHeader.class).addProperty("name", "bcc").build();
    public static final MailetConfiguration LOCAL_DELIVERY = MailetConfiguration.builder().matcher(RecipientIsLocal.class).mailet(LocalDelivery.class).build();
    public static final MailetConfiguration TO_TRANSPORT = MailetConfiguration.builder().matcher(All.class).mailet(ToProcessor.class).addProperty("processor", "transport").build();
    public static final MailetConfiguration TO_BOUNCE = MailetConfiguration.builder().matcher(All.class).mailet(ToProcessor.class).addProperty("processor", "bounces").build();
    private final Class<? extends Matcher> matcher;
    private final Optional<String> matcherCondition;
    private final Class<? extends Mailet> mailet;
    private final Map<String, String> properties;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder remoteDeliveryBuilder() {
        return MailetConfiguration.remoteDeliveryBuilderNoBounces().addProperty("bounceProcessor", "error");
    }

    public static Builder remoteDeliveryBuilderNoBounces() {
        return MailetConfiguration.builder().mailet(RemoteDelivery.class).addProperty("outgoingQueue", "outgoing").addProperty("delayTime", "5000, 100000, 500000").addProperty("maxRetries", "2").addProperty("maxDnsProblemRetries", "0").addProperty("deliveryThreads", "2").addProperty("sendpartial", "true");
    }

    private MailetConfiguration(Class<? extends Matcher> matcher, Optional<String> matcherCondition, Class<? extends Mailet> mailet, ImmutableMap<String, String> properties) {
        this.matcher = matcher;
        this.matcherCondition = matcherCondition;
        this.mailet = mailet;
        this.properties = properties;
    }

    public Class<? extends Matcher> getMatcher() {
        return this.matcher;
    }

    public Optional<String> getMatcherCondition() {
        return this.matcherCondition;
    }

    public Class<? extends Mailet> getMailet() {
        return this.mailet;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String serializeAsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<mailet match=\"").append(this.matcherWithCondition()).append("\" class=\"").append(this.getMailet().getCanonicalName()).append("\">\n");
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            builder.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">\n");
        }
        builder.append("</mailet>\n");
        return builder.toString();
    }

    @VisibleForTesting
    String matcherWithCondition() {
        StringBuilder match = new StringBuilder().append(this.matcher.getCanonicalName());
        this.matcherCondition.ifPresent(condition -> match.append("=").append((String)condition));
        return match.toString();
    }

    public static class Builder {
        private Class<? extends Matcher> matcher;
        private Optional<String> matcherCondition;
        private Class<? extends Mailet> mailet;
        private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private Builder() {
            this.matcherCondition = Optional.empty();
        }

        public Builder matcher(Class<? extends Matcher> matcher) {
            this.matcher = matcher;
            return this;
        }

        public Builder matcherCondition(String condition) {
            this.matcherCondition = Optional.ofNullable(condition);
            return this;
        }

        public Builder mailet(Class<? extends Mailet> mailet) {
            this.mailet = mailet;
            return this;
        }

        public Builder addProperty(String key, String value) {
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        public MailetConfiguration build() {
            Preconditions.checkState((this.matcher != null ? 1 : 0) != 0, (Object)"'matcher' is mandatory");
            Preconditions.checkState((this.mailet != null ? 1 : 0) != 0, (Object)"'mailet' is mandatory");
            return new MailetConfiguration(this.matcher, this.matcherCondition, this.mailet, (ImmutableMap<String, String>)this.properties.build());
        }
    }
}

