/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.github.fge.lambdas.Throwing;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.AttributeUtils;
import org.apache.james.transport.matchers.CacheSettings;
import org.apache.james.user.ldap.LDAPConnectionFactory;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class SenderHasLDAPAttribute
extends GenericMatcher {
    private final LDAPConnectionPool ldapConnectionPool;
    private final LdapRepositoryConfiguration configuration;
    private final Filter objectClassFilter;
    private final Optional<Filter> userExtraFilter;
    private String attributeName;
    private Optional<String> attributeValue;
    private String[] attributes;
    private Optional<Cache<String, Boolean>> cache;

    @Inject
    public SenderHasLDAPAttribute(LDAPConnectionPool ldapConnectionPool, LdapRepositoryConfiguration configuration) {
        this.configuration = configuration;
        this.ldapConnectionPool = ldapConnectionPool;
        this.userExtraFilter = Optional.ofNullable(configuration.getFilter()).map(Throwing.function(Filter::create).sneakyThrow());
        this.objectClassFilter = Filter.createEqualityFilter((String)"objectClass", (String)configuration.getUserObjectClass());
    }

    public SenderHasLDAPAttribute(LdapRepositoryConfiguration configuration) throws LDAPException {
        this(new LDAPConnectionFactory(configuration).getLdapConnectionPool(), configuration);
    }

    public void init() throws MessagingException {
        String condition = this.removeCacheSettings();
        int commaPosition = condition.indexOf(58);
        if (commaPosition == -1) {
            this.attributeName = condition;
            this.attributeValue = Optional.empty();
        } else {
            if (commaPosition == 0) {
                throw new MessagingException("Syntax Error. Missing attribute name.");
            }
            this.attributeName = condition.substring(0, commaPosition).trim();
            this.attributeValue = Optional.of(condition.substring(commaPosition + 1).trim());
        }
        this.attributes = (String[])ImmutableSet.builder().add((Object[])this.configuration.getReturnedAttributes()).add((Object)this.attributeName).build().toArray(String[]::new);
        this.cache = CacheSettings.parse(this.getCondition()).map(CacheSettings::createAssociatedCache);
    }

    private String removeCacheSettings() {
        int conditionEnd = this.getCondition().indexOf(63);
        if (conditionEnd == -1) {
            return this.getCondition().trim();
        }
        return this.getCondition().substring(0, conditionEnd).trim();
    }

    public Collection<MailAddress> match(Mail mail) {
        boolean matches = mail.getMaybeSender().asOptional().map(this::hasAttribute).orElse(false);
        if (matches) {
            return mail.getRecipients();
        }
        return ImmutableList.of();
    }

    private boolean hasAttribute(MailAddress rcpt) {
        Optional cacheAnswer = this.cache.flatMap(c -> Optional.ofNullable((Boolean)c.getIfPresent((Object)rcpt.asString())));
        if (cacheAnswer.isPresent()) {
            return (Boolean)cacheAnswer.get();
        }
        try {
            SearchResult searchResult = this.ldapConnectionPool.search(this.userBase(rcpt), SearchScope.SUB, this.createFilter(rcpt.asString(), this.configuration.getUserIdAttribute()), this.attributes);
            boolean answer = searchResult.getSearchEntries().stream().anyMatch(this::hasAttribute);
            this.cache.ifPresent(c -> c.put((Object)rcpt.asString(), (Object)answer));
            return answer;
        }
        catch (LDAPSearchException e) {
            throw new RuntimeException("Failed searching LDAP", e);
        }
    }

    private boolean hasAttribute(SearchResultEntry entry) {
        return this.attributeValue.map(value -> Optional.ofNullable(entry.getAttribute(this.attributeName)).map(attribute -> Arrays.stream(attribute.getValues())).orElse(Stream.empty()).map(ldapValue -> AttributeUtils.extractLdapAttributeValue(this.attributeName, ldapValue)).anyMatch(value::equals)).orElseGet(() -> entry.hasAttribute(this.attributeName));
    }

    private Filter createFilter(String retrievalName, String ldapUserRetrievalAttribute) {
        Filter specificUserFilter = Filter.createEqualityFilter((String)ldapUserRetrievalAttribute, (String)retrievalName);
        return this.userExtraFilter.map(extraFilter -> Filter.createANDFilter((Filter[])new Filter[]{this.objectClassFilter, specificUserFilter, extraFilter})).orElseGet(() -> Filter.createANDFilter((Filter[])new Filter[]{this.objectClassFilter, specificUserFilter}));
    }

    private String userBase(MailAddress mailAddress) {
        return this.userBase(mailAddress.getDomain());
    }

    private String userBase(Domain domain) {
        return (String)this.configuration.getPerDomainBaseDN().getOrDefault((Object)domain, (Object)this.configuration.getUserBase());
    }
}

