/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultEntry;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.james.core.MailAddress;
import org.apache.james.user.ldap.LDAPConnectionFactory;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class IsInLDAPGroup
extends GenericMatcher {
    private final LDAPConnectionPool ldapConnectionPool;
    private final LdapRepositoryConfiguration configuration;
    private String groupDN;

    @Inject
    public IsInLDAPGroup(LdapRepositoryConfiguration configuration) throws LDAPException {
        this.configuration = configuration;
        this.ldapConnectionPool = new LDAPConnectionFactory(this.configuration).getLdapConnectionPool();
    }

    public void init() {
        this.groupDN = this.getCondition();
    }

    public Collection<MailAddress> match(Mail mail) {
        return Sets.intersection((Set)ImmutableSet.copyOf((Collection)mail.getRecipients()), this.groupMembers());
    }

    private Set<MailAddress> groupMembers() {
        try {
            String[] attributes = new String[]{"member"};
            SearchResultEntry groupEntry = this.ldapConnectionPool.getEntry(this.groupDN, attributes);
            if (groupEntry == null) {
                return ImmutableSet.of();
            }
            return (Set)groupEntry.getAttributes().stream().filter(a -> a.getName().equals("member")).map(Attribute::getValue).map(Throwing.function(memberDn -> Optional.ofNullable(this.ldapConnectionPool.getEntry(memberDn, this.configuration.getReturnedAttributes())))).flatMap(Optional::stream).map(memberEntry -> memberEntry.getAttribute(this.configuration.getUserIdAttribute()).getValue()).map(Throwing.function(MailAddress::new)).collect(ImmutableSet.toImmutableSet());
        }
        catch (LDAPException e) {
            throw new RuntimeException("Failed searching LDAP", e);
        }
    }
}

