/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.util.DurationParser;

public record CacheSettings(Duration duration, int size) {
    public static Optional<CacheSettings> parse(String condition) {
        if (!condition.contains("?")) {
            return Optional.empty();
        }
        String cacheSettings = condition.substring(condition.indexOf(63) + 1);
        ImmutableMap cacheSettingMap = (ImmutableMap)Splitter.on((char)'&').trimResults().omitEmptyStrings().splitToStream((CharSequence)cacheSettings).map(CacheSettings::asPair).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
        boolean enabled = Optional.ofNullable((String)cacheSettingMap.get((Object)"cacheenabled")).map(Boolean::parseBoolean).orElse(true);
        int size = Optional.ofNullable((String)cacheSettingMap.get((Object)"cachesize")).map(Integer::parseInt).orElse(10000);
        Duration duration = Optional.ofNullable((String)cacheSettingMap.get((Object)"cacheduration")).map(DurationParser::parse).orElse(Duration.ofDays(1L));
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"size must be an integer greater than 0");
        if (!enabled) {
            return Optional.empty();
        }
        return Optional.of(new CacheSettings(duration, size));
    }

    private static Pair<String, String> asPair(String condition) {
        Preconditions.checkArgument((boolean)condition.contains("="), (Object)("Each pair of the cache setting must be of the form key=value. Got " + condition));
        int separatorPosition = condition.indexOf(61);
        String key = condition.substring(0, separatorPosition).toLowerCase(Locale.US);
        String value = condition.substring(separatorPosition + 1);
        return Pair.of((Object)key, (Object)value);
    }

    Cache<String, Boolean> createAssociatedCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(this.duration).maximumSize((long)this.size).build();
    }
}

