/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDNNameValuePair;
import java.util.Arrays;
import org.apache.james.transport.matchers.HasLDAPAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HasLDAPAttribute.class);

    static String extractLdapAttributeValue(String attributeName, String ldapValue) {
        if (ldapValue.contains(",")) {
            try {
                return Arrays.stream(new DN(ldapValue).getRDNs()).flatMap(rdn -> rdn.getNameValuePairs().stream()).filter(pair -> pair.getAttributeName().equals("cn")).findFirst().map(RDNNameValuePair::getAttributeValue).orElse(ldapValue);
            }
            catch (LDAPException e) {
                LOGGER.info("Non DN value '{}' for attribute {} contains coma", (Object)ldapValue, (Object)attributeName);
                return ldapValue;
            }
        }
        return ldapValue;
    }
}

