/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.ai.classic;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.james.ai.classic.TokenCollector;
import org.apache.james.ai.classic.TokenCounter;
import org.apache.james.ai.classic.TokenProbabilityStrength;

public class BayesianAnalyzer {
    private static final int MAX_INTERESTING_TOKENS = 15;
    private static final double INTERESTINGNESS_THRESHOLD = 0.46;
    static final double DEFAULT_TOKEN_PROBABILITY = 0.4;
    private Map<String, Integer> hamTokenCounts = new HashMap<String, Integer>();
    private Map<String, Integer> spamTokenCounts = new HashMap<String, Integer>();
    private int hamMessageCount = 0;
    private int spamMessageCount = 0;
    private Map<String, Double> corpus = new HashMap<String, Double>();

    public void setHamTokenCounts(Map<String, Integer> hamTokenCounts) {
        this.hamTokenCounts = hamTokenCounts;
    }

    public Map<String, Integer> getHamTokenCounts() {
        return this.hamTokenCounts;
    }

    public void setSpamTokenCounts(Map<String, Integer> spamTokenCounts) {
        this.spamTokenCounts = spamTokenCounts;
    }

    public Map<String, Integer> getSpamTokenCounts() {
        return this.spamTokenCounts;
    }

    public void setSpamMessageCount(int spamMessageCount) {
        this.spamMessageCount = spamMessageCount;
    }

    public int getSpamMessageCount() {
        return this.spamMessageCount;
    }

    public void setHamMessageCount(int hamMessageCount) {
        this.hamMessageCount = hamMessageCount;
    }

    public int getHamMessageCount() {
        return this.hamMessageCount;
    }

    public void clear() {
        this.corpus.clear();
        this.tokenCountsClear();
        this.hamMessageCount = 0;
        this.spamMessageCount = 0;
    }

    public void tokenCountsClear() {
        this.hamTokenCounts.clear();
        this.spamTokenCounts.clear();
    }

    public void setCorpus(Map<String, Double> corpus) {
        this.corpus = corpus;
    }

    public Map<String, Double> getCorpus() {
        return this.corpus;
    }

    public void buildCorpus() {
        HashSet<String> set = new HashSet<String>(this.hamTokenCounts.size() + this.spamTokenCounts.size());
        set.addAll(this.hamTokenCounts.keySet());
        set.addAll(this.spamTokenCounts.keySet());
        HashMap<String, Double> tempCorpus = new HashMap<String, Double>(set.size());
        for (String token : set) {
            tempCorpus.put(token, this.computeProbability(token));
        }
        this.setCorpus(tempCorpus);
    }

    public void addHam(Reader stream) throws IOException {
        this.addTokenOccurrences(stream, this.hamTokenCounts);
        ++this.hamMessageCount;
    }

    public void addSpam(Reader stream) throws IOException {
        this.addTokenOccurrences(stream, this.spamTokenCounts);
        ++this.spamMessageCount;
    }

    public double computeSpamProbability(Reader stream) throws IOException {
        Set<String> tokens = this.parse(stream);
        Map<String, Double> workCorpus = this.getCorpus();
        SortedSet<TokenProbabilityStrength> tokenProbabilityStrengths = this.getTokenProbabilityStrengths(tokens, workCorpus);
        return this.computeOverallProbability(tokenProbabilityStrengths, workCorpus);
    }

    private void addTokenOccurrences(Reader stream, Map<String, Integer> target) throws IOException {
        new TokenCounter(target).count(stream);
    }

    private Set<String> parse(Reader stream) throws IOException {
        HashSet<String> tokens = new HashSet<String>();
        new TokenCollector(tokens).collect(stream);
        return tokens;
    }

    private double computeProbability(String token) {
        double hamFactor = 0.0;
        double spamFactor = 0.0;
        boolean foundInHam = false;
        boolean foundInSpam = false;
        double minThreshold = 0.01;
        double maxThreshold = 0.99;
        if (this.hamTokenCounts.containsKey(token)) {
            foundInHam = true;
        }
        if (this.spamTokenCounts.containsKey(token)) {
            foundInSpam = true;
        }
        if (foundInHam) {
            hamFactor = 2.0 * this.hamTokenCounts.get(token).doubleValue();
            if (!foundInSpam) {
                double d = minThreshold = hamFactor > 20.0 ? 1.0E-4 : 2.0E-4;
            }
        }
        if (foundInSpam) {
            spamFactor = this.spamTokenCounts.get(token).doubleValue();
            if (!foundInHam) {
                double d = maxThreshold = spamFactor > 10.0 ? 0.9999 : 0.9998;
            }
        }
        if (hamFactor + spamFactor < 5.0) {
            return 0.4;
        }
        double spamFreq = Math.min(1.0, spamFactor / (double)this.spamMessageCount);
        double hamFreq = Math.min(1.0, hamFactor / (double)this.hamMessageCount);
        return Math.max(minThreshold, Math.min(maxThreshold, spamFreq / (hamFreq + spamFreq)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedSet<TokenProbabilityStrength> getTokenProbabilityStrengths(Set<String> tokens, Map<String, Double> workCorpus) {
        TreeSet<TokenProbabilityStrength> tokenProbabilityStrengths = new TreeSet<TokenProbabilityStrength>();
        for (String token : tokens) {
            TokenProbabilityStrength tps = new TokenProbabilityStrength();
            tps.token = token;
            if (workCorpus.containsKey(tps.token)) {
                tps.strength = Math.abs(0.5 - workCorpus.get(tps.token));
            } else {
                Double corpusProbability = 0.4;
                tps.strength = Math.abs(0.09999999999999998);
                boolean isTokenDegeneratedFound = false;
                Collection<String> degeneratedTokens = this.buildDegenerated(tps.token);
                for (String tokenDegenerated : degeneratedTokens) {
                    Double probabilityTemp;
                    double strengthDegenerated;
                    if (!workCorpus.containsKey(tokenDegenerated) || !((strengthDegenerated = Math.abs(0.5 - (probabilityTemp = workCorpus.get(tokenDegenerated)))) > tps.strength)) continue;
                    isTokenDegeneratedFound = true;
                    tps.strength = strengthDegenerated;
                    corpusProbability = probabilityTemp;
                }
                if (isTokenDegeneratedFound) {
                    Map<String, Double> map = workCorpus;
                    synchronized (map) {
                        workCorpus.put(tps.token, corpusProbability);
                    }
                }
            }
            tokenProbabilityStrengths.add(tps);
        }
        return tokenProbabilityStrengths;
    }

    private Collection<String> buildDegenerated(String fullToken) {
        String token;
        String header;
        ArrayList<String> tokens = new ArrayList<String>();
        int headerEnd = fullToken.indexOf(58);
        if (headerEnd >= 0) {
            header = fullToken.substring(0, headerEnd);
            token = fullToken.substring(headerEnd);
        } else {
            header = "";
            token = fullToken;
        }
        String tokenLower = token.toLowerCase(Locale.US);
        int end = token.length();
        do {
            if (!token.substring(0, end).equals(tokenLower.substring(0, end))) {
                tokens.add(header + tokenLower.substring(0, end));
                if (header.length() > 0) {
                    tokens.add(tokenLower.substring(0, end));
                }
            }
            if (end > 1 && token.charAt(0) >= 'A' && token.charAt(0) <= 'Z') {
                tokens.add(header + token.charAt(0) + tokenLower.substring(1, end));
                if (header.length() > 0) {
                    tokens.add(token.charAt(0) + tokenLower.substring(1, end));
                }
            }
            if (token.charAt(end - 1) != '!') break;
            tokens.add(header + token.substring(0, --end));
            if (header.length() <= 0) continue;
            tokens.add(token.substring(0, end));
        } while (end > 0);
        return tokens;
    }

    private double computeOverallProbability(SortedSet<TokenProbabilityStrength> tokenProbabilityStrengths, Map<String, Double> workCorpus) {
        double p = 1.0;
        double np = 1.0;
        double tempStrength = 0.5;
        int count = 15;
        Iterator iterator = tokenProbabilityStrengths.iterator();
        while (iterator.hasNext() && (count-- > 0 || tempStrength >= 0.46)) {
            TokenProbabilityStrength tps = (TokenProbabilityStrength)iterator.next();
            tempStrength = tps.strength;
            double theDoubleValue = 0.4;
            Double theDoubleObject = workCorpus.get(tps.token);
            if (theDoubleObject != null) {
                theDoubleValue = theDoubleObject;
            }
            p *= theDoubleValue;
            np *= 1.0 - theDoubleValue;
        }
        return p / (p + np);
    }
}

