/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.ai.classic;

import jakarta.annotation.Resource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.james.ai.classic.CorpusLoaderThread;
import org.apache.james.ai.classic.JDBCBayesianAnalyzer;
import org.apache.james.ai.classic.JDBCUtil;
import org.apache.james.ai.classic.SystemContext;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class BayesianAnalysis
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(BayesianAnalysis.class);
    private final JDBCUtil theJDBCUtil = new JDBCUtil();
    private final JDBCBayesianAnalyzer analyzer = new JDBCBayesianAnalyzer();
    DataSource datasource;
    private static final AttributeName MAIL_ATTRIBUTE_NAME = AttributeName.of((String)"org.apache.james.spam.probability");
    private static final String HEADER_NAME = "X-MessageIsSpamProbability";
    static final long CORPUS_RELOAD_INTERVAL = 600000L;
    private String headerName;
    private boolean ignoreLocalSender = false;
    private boolean tagSubject = true;
    private int maxSize = 100000;
    private long lastCorpusLoadTime;
    private SystemContext fs;

    public String getMailetInfo() {
        return "BayesianAnalysis Mailet";
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getLastCorpusLoadTime() {
        return this.lastCorpusLoadTime;
    }

    @Resource(name="datasource")
    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Resource(name="filesystem")
    public void setFileSystem(SystemContext fs) {
        this.fs = fs;
    }

    private void touchLastCorpusLoadTime() {
        this.lastCorpusLoadTime = System.currentTimeMillis();
    }

    public void init() throws MessagingException {
        String repositoryPath = this.getInitParameter("repositoryPath");
        if (repositoryPath == null) {
            throw new MessagingException("repositoryPath is null");
        }
        this.headerName = this.getInitParameter("headerName", HEADER_NAME);
        this.ignoreLocalSender = Boolean.parseBoolean(this.getInitParameter("ignoreLocalSender"));
        if (this.ignoreLocalSender) {
            LOGGER.debug("Will ignore messages coming from local senders");
        } else {
            LOGGER.debug("Will analyze messages coming from local senders");
        }
        String maxSizeParam = this.getInitParameter("maxSize");
        if (maxSizeParam != null) {
            this.maxSize = Integer.parseInt(maxSizeParam);
        }
        LOGGER.debug("maxSize: {}", (Object)this.getMaxSize());
        String tag = this.getInitParameter("tagSubject");
        if (tag != null && tag.equals("false")) {
            this.tagSubject = false;
        }
        this.initDb();
        CorpusLoaderThread corpusLoader = new CorpusLoaderThread(this);
        corpusLoader.setDaemon(true);
        corpusLoader.start();
    }

    private void initDb() throws MessagingException {
        try {
            this.analyzer.initSqlQueries(this.datasource.getConnection(), this.fs.readXml("sqlResources.xml"));
        }
        catch (Exception e) {
            throw new MessagingException("Exception initializing queries", e);
        }
        try {
            this.loadData(this.datasource.getConnection());
        }
        catch (SQLException se) {
            throw new MessagingException("SQLException loading data", (Exception)se);
        }
    }

    public void service(Mail mail) throws MessagingException {
        try {
            double probability;
            MimeMessage message = mail.getMessage();
            if (this.ignoreLocalSender && this.isSenderLocal(mail)) {
                return;
            }
            String[] headerArray = message.getHeader(this.headerName);
            if (headerArray != null && headerArray.length > 0) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (message.getSize() < this.getMaxSize()) {
                message.writeTo((OutputStream)baos);
                probability = this.analyzer.computeSpamProbability(new BufferedReader(new StringReader(baos.toString())));
            } else {
                probability = 0.0;
            }
            mail.setAttribute(new Attribute(MAIL_ATTRIBUTE_NAME, AttributeValue.of((Double)probability)));
            message.setHeader(this.headerName, Double.toString(probability));
            DecimalFormat probabilityForm = (DecimalFormat)DecimalFormat.getInstance();
            probabilityForm.applyPattern("##0.##%");
            String probabilityString = probabilityForm.format(probability);
            String senderString = mail.getMaybeSender().asString("null");
            if (probability > 0.1) {
                Collection recipients = mail.getRecipients();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(this.headerName + ": " + probabilityString + "; From: " + senderString + "; Recipient(s): " + this.getAddressesString(recipients));
                }
                if (this.tagSubject) {
                    this.appendToSubject(message, " [" + probabilityString + (probability > 0.9 ? " SPAM" : " spam") + "]");
                }
            }
            this.saveChanges(message);
        }
        catch (Exception e) {
            LOGGER.error("Exception: {}", (Object)e.getMessage(), (Object)e);
            throw new MessagingException("Exception thrown", e);
        }
    }

    private boolean isSenderLocal(Mail mail) {
        return mail.getMaybeSender().asOptional().map(MailAddress::getDomain).map(domain -> this.getMailetContext().isLocalServer(domain)).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadData(Connection conn) throws SQLException {
        try {
            String string = "database lock";
            synchronized ("database lock") {
                this.analyzer.tokenCountsClear();
                this.analyzer.loadHamNSpam(conn);
                this.analyzer.buildCorpus();
                this.analyzer.tokenCountsClear();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                LOGGER.error("BayesianAnalysis Corpus loaded");
                this.touchLastCorpusLoadTime();
            }
        }
        finally {
            if (conn != null) {
                this.theJDBCUtil.closeJDBCConnection(conn);
            }
        }
        {
            return;
        }
    }

    private String getAddressesString(Collection<MailAddress> addresses) {
        if (addresses == null) {
            return "null";
        }
        Iterator<MailAddress> iter = addresses.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (i + 1 < addresses.size()) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    private void appendToSubject(MimeMessage message, String toAppend) {
        try {
            String subject = message.getSubject();
            if (subject == null) {
                message.setSubject(toAppend, "iso-8859-1");
            } else {
                message.setSubject(toAppend + " " + subject, "iso-8859-1");
            }
        }
        catch (MessagingException ex) {
            LOGGER.error("Failure to append to subject phrase: '{}'", (Object)toAppend, (Object)ex);
        }
    }

    private void saveChanges(MimeMessage message) throws MessagingException {
        String messageId = message.getMessageID();
        message.saveChanges();
        if (messageId != null) {
            message.setHeader("Message-ID", messageId);
        }
    }
}

