/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.script;

import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mpt.api.ImapHostSystem;
import org.apache.james.mpt.script.GenericSimpleScriptedTestProtocol;

public class ImapScriptedTestProtocol
extends GenericSimpleScriptedTestProtocol<ImapHostSystem, ImapScriptedTestProtocol> {
    public ImapScriptedTestProtocol(String scriptDirectory, ImapHostSystem hostSystem) throws Exception {
        super(scriptDirectory, hostSystem);
    }

    public ImapScriptedTestProtocol withMailbox(MailboxPath mailboxPath) {
        return (ImapScriptedTestProtocol)this.withPreparedCommand(new CreateMailbox(mailboxPath));
    }

    public ImapScriptedTestProtocol withFilledMailbox(MailboxPath mailboxPath) {
        return (ImapScriptedTestProtocol)this.withPreparedCommand(new FillMailbox(mailboxPath));
    }

    public ImapScriptedTestProtocol withRights(MailboxPath mailboxPath, Username username, MailboxACL.Rfc4314Rights rights) {
        return (ImapScriptedTestProtocol)this.withPreparedCommand(new CreateRights(mailboxPath, username, rights));
    }

    private static class CreateMailbox
    implements GenericSimpleScriptedTestProtocol.PrepareCommand<ImapHostSystem> {
        final MailboxPath mailboxPath;

        CreateMailbox(MailboxPath mailboxPath) {
            this.mailboxPath = mailboxPath;
        }

        @Override
        public void prepare(ImapHostSystem system) throws Exception {
            system.createMailbox(this.mailboxPath);
        }
    }

    private static class FillMailbox
    implements GenericSimpleScriptedTestProtocol.PrepareCommand<ImapHostSystem> {
        final MailboxPath mailboxPath;

        FillMailbox(MailboxPath mailboxPath) {
            this.mailboxPath = mailboxPath;
        }

        @Override
        public void prepare(ImapHostSystem system) throws Exception {
            system.fillMailbox(this.mailboxPath);
        }
    }

    private static class CreateRights
    implements GenericSimpleScriptedTestProtocol.PrepareCommand<ImapHostSystem> {
        final MailboxPath mailboxPath;
        final Username username;
        final MailboxACL.Rfc4314Rights rights;

        public CreateRights(MailboxPath mailboxPath, Username username, MailboxACL.Rfc4314Rights rights) {
            this.mailboxPath = mailboxPath;
            this.username = username;
            this.rights = rights;
        }

        @Override
        public void prepare(ImapHostSystem system) throws Exception {
            system.grantRights(this.mailboxPath, this.username, this.rights);
        }
    }
}

