/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.helper;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer = ByteBuffer.allocate(160384);
    private final CharsetEncoder encoder = StandardCharsets.US_ASCII.newEncoder();
    private boolean readLast = true;

    @Override
    public int read() throws IOException {
        if (!this.readLast) {
            this.readLast = true;
            this.buffer.flip();
        }
        int result = -1;
        if (this.buffer.hasRemaining()) {
            result = this.buffer.get();
        }
        return result;
    }

    public void nextLine(String line) {
        if (this.buffer.position() > 0 && this.readLast) {
            this.buffer.compact();
        }
        this.encoder.encode(CharBuffer.wrap(line), this.buffer, true);
        this.buffer.put((byte)13);
        this.buffer.put((byte)10);
        this.readLast = false;
    }
}

