/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tools.jpa.migrator.command;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import org.apache.james.mailbox.tools.jpa.migrator.command.JpaMigrateCommand;
import org.apache.james.mailbox.tools.jpa.migrator.command.JpaMigrateQuery;
import org.apache.james.mailbox.tools.jpa.migrator.exception.JpaMigrateException;
import org.apache.openjpa.kernel.DelegatingResultList;
import org.apache.openjpa.lib.rop.ResultList;

public class IMAP180JpaMigrateCommand
implements JpaMigrateCommand {
    @Override
    public void migrate(EntityManager em) throws JpaMigrateException {
        em.getTransaction().commit();
        IMAP180JpaMigrateCommand.migrateHeaders(em);
        IMAP180JpaMigrateCommand.migrateProperties(em);
        em.getTransaction().begin();
    }

    private static void migrateHeaders(EntityManager em) {
        em.getTransaction().begin();
        Query headerCountQuery = em.createNativeQuery("SELECT COUNT(MESSAGE_ID) FROM MESSAGE_HEADER", Integer.class);
        Integer headerCount = (Integer)headerCountQuery.getResultList().get(0);
        System.out.println("Number of headers=" + headerCount);
        JpaMigrateQuery.executeUpdate(em, "ALTER TABLE HEADER ADD COLUMN MESSAGE_ID BIGINT");
        Query headerQuery = em.createNativeQuery("SELECT MESSAGE_ID, HEADERS_ID FROM MESSAGE_HEADER");
        em.getTransaction().commit();
        DelegatingResultList headerNameList = (DelegatingResultList)headerQuery.getResultList();
        ResultList rl = headerNameList.getDelegate();
        for (int i = 0; i < rl.size(); ++i) {
            Object[] results = (Object[])rl.get(i);
            Long messageId = (Long)results[0];
            Long headerId = (Long)results[1];
            em.getTransaction().begin();
            Query update = em.createNativeQuery("UPDATE HEADER SET MESSAGE_ID = ? WHERE ID = ?");
            update.setParameter(1, (Object)messageId);
            update.setParameter(2, (Object)headerId);
            int result = update.executeUpdate();
            System.out.printf("ExecuteUpdate returned a result=" + result + " for header %d of %d\n", i + 1, headerCount);
            em.getTransaction().commit();
        }
        em.getTransaction().begin();
        System.out.println("Creating index.");
        JpaMigrateQuery.executeUpdate(em, "CREATE INDEX SQL100727182411700 ON HEADER(MESSAGE_ID)");
        em.getTransaction().commit();
        em.getTransaction().begin();
        System.out.println("Creating foreign key.");
        JpaMigrateQuery.executeUpdate(em, "ALTER TABLE HEADER ADD CONSTRAINT SQL100727182411700 FOREIGN KEY (MESSAGE_ID) REFERENCES MESSAGE(ID)");
        em.getTransaction().commit();
        em.getTransaction().begin();
        System.out.println("Dropping table.");
        JpaMigrateQuery.executeUpdate(em, "DROP TABLE MESSAGE_HEADER");
        em.getTransaction().commit();
    }

    private static void migrateProperties(EntityManager em) {
        em.getTransaction().begin();
        Query propertyCountQuery = em.createNativeQuery("SELECT COUNT(MESSAGE_ID) FROM MESSAGE_PROPERTY", Integer.class);
        Integer propertyCount = (Integer)propertyCountQuery.getResultList().get(0);
        System.out.println("Number of headers=" + propertyCount);
        JpaMigrateQuery.executeUpdate(em, "ALTER TABLE PROPERTY ADD COLUMN MESSAGE_ID BIGINT");
        Query propertyQuery = em.createNativeQuery("SELECT MESSAGE_ID, PROPERTIES_ID FROM MESSAGE_PROPERTY");
        em.getTransaction().commit();
        DelegatingResultList propertyNameList = (DelegatingResultList)propertyQuery.getResultList();
        ResultList rl = propertyNameList.getDelegate();
        for (int i = 0; i < rl.size(); ++i) {
            Object[] results = (Object[])rl.get(i);
            Long messageId = (Long)results[0];
            Long propertyId = (Long)results[1];
            em.getTransaction().begin();
            Query update = em.createNativeQuery("UPDATE PROPERTY SET MESSAGE_ID = ? WHERE ID = ?");
            update.setParameter(1, (Object)messageId);
            update.setParameter(2, (Object)propertyId);
            int result = update.executeUpdate();
            System.out.printf("ExecuteUpdate returned a result=" + result + " for property %d of %d\n", i + 1, propertyCount);
            em.getTransaction().commit();
        }
        em.getTransaction().begin();
        System.out.println("Creating index.");
        JpaMigrateQuery.executeUpdate(em, "CREATE INDEX SQL100727182411780 ON PROPERTY(MESSAGE_ID)");
        em.getTransaction().commit();
        em.getTransaction().begin();
        System.out.println("Creating foreign key.");
        JpaMigrateQuery.executeUpdate(em, "ALTER TABLE PROPERTY ADD CONSTRAINT SQL100727182411780 FOREIGN KEY (MESSAGE_ID) REFERENCES MESSAGE(ID)");
        em.getTransaction().commit();
        em.getTransaction().begin();
        System.out.println("Dropping table.");
        JpaMigrateQuery.executeUpdate(em, "DROP TABLE MESSAGE_PROPERTY");
        em.getTransaction().commit();
    }
}

