/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tools.jpa.migrator.command;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import org.apache.james.mailbox.tools.jpa.migrator.command.JpaMigrateCommand;
import org.apache.james.mailbox.tools.jpa.migrator.command.JpaMigrateQuery;
import org.apache.james.mailbox.tools.jpa.migrator.exception.JpaMigrateException;

public class IMAP168JpaMigrateCommand
implements JpaMigrateCommand {
    @Override
    public void migrate(EntityManager em) throws JpaMigrateException {
        JpaMigrateQuery.executeUpdate(em, "ALTER TABLE MAILBOX ADD COLUMN NAMESPACE VARCHAR(255)");
        JpaMigrateQuery.executeUpdate(em, "ALTER TABLE MAILBOX ADD COLUMN USER0 VARCHAR(255)");
        Query query = em.createNativeQuery("SELECT NAME FROM MAILBOX");
        List nameList = query.getResultList();
        System.out.println("getResultList returned a result=" + nameList.size());
        for (String name : nameList) {
            MailboxPath mailboxPath = new MailboxPath(name);
            System.out.println(mailboxPath);
            Query update = em.createNativeQuery("UPDATE MAILBOX SET NAMESPACE = ?, USER0 = ?, NAME = ? WHERE NAME = ?");
            update.setParameter(1, (Object)mailboxPath.namespace);
            update.setParameter(2, (Object)mailboxPath.userName);
            update.setParameter(3, (Object)mailboxPath.mailboxName);
            update.setParameter(4, (Object)name);
            int resultUpdate = update.executeUpdate();
            System.out.println("ExecuteUpdate returned a result=" + resultUpdate);
        }
    }

    private static class MailboxPath {
        protected String namespace;
        protected String userName;
        protected String mailboxName;

        public MailboxPath(String name) {
            int atIndex;
            int firstDotIndex;
            if (!name.startsWith("#mail")) {
                throw new IllegalArgumentException("The name must begin with #private");
            }
            this.namespace = "#mail";
            int secondDotIndex = (name = name.substring(6)).indexOf(".", (firstDotIndex = name.indexOf(".", atIndex = name.indexOf("@"))) + 1);
            if (secondDotIndex > 0) {
                this.userName = name.substring(0, secondDotIndex);
                this.mailboxName = name.substring(this.userName.length() + 1);
            } else {
                this.userName = name;
                this.mailboxName = "";
            }
        }

        public String toString() {
            return "MailboxPath [namespace=" + this.namespace + ", userName=" + this.userName + ", mailboxName=" + this.mailboxName + "]";
        }
    }
}

