/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tools.jpa.migrator;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.Locale;
import org.apache.james.mailbox.tools.jpa.migrator.command.JpaMigrateCommand;
import org.apache.james.mailbox.tools.jpa.migrator.exception.JpaMigrateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaMigrator.class);
    private static final String JPA_MIGRATION_COMMAND_PACKAGE = JpaMigrateCommand.class.getPackage().getName();

    public static void main(String[] jiras) throws JpaMigrateException {
        try {
            EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"JamesMigrator");
            EntityManager em = factory.createEntityManager();
            for (String jira : jiras) {
                JpaMigrateCommand jiraJpaMigratable = (JpaMigrateCommand)Class.forName(JPA_MIGRATION_COMMAND_PACKAGE + "." + jira.toUpperCase(Locale.US) + JpaMigrateCommand.class.getSimpleName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LOGGER.info("Now executing {} migration", (Object)jira);
                em.getTransaction().begin();
                jiraJpaMigratable.migrate(em);
                em.getTransaction().commit();
                LOGGER.info("{} migration is successfully achieved", (Object)jira);
            }
        }
        catch (Throwable t) {
            throw new JpaMigrateException(t);
        }
    }
}

