/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.PrefixedWildcardCaseInsensitive;

public class ExactNameCaseInsensitive
implements MailboxNameExpression {
    private final String name;

    public ExactNameCaseInsensitive(String name) {
        Preconditions.checkNotNull((Object)name);
        this.name = name;
    }

    @Override
    public boolean isExpressionMatch(String mailboxName) {
        Preconditions.checkNotNull((Object)mailboxName);
        return this.name.equalsIgnoreCase(mailboxName);
    }

    @Override
    public String getCombinedName() {
        return this.name;
    }

    @Override
    public boolean isWild() {
        return false;
    }

    @Override
    public MailboxNameExpression includeChildren() {
        return new PrefixedWildcardCaseInsensitive(this.name);
    }

    public final boolean equals(Object o) {
        if (o instanceof ExactNameCaseInsensitive) {
            ExactNameCaseInsensitive exactName = (ExactNameCaseInsensitive)o;
            return Objects.equals(this.name, exactName.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }
}

