/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.mailbox.Headers;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MimeDescriptor;
import org.apache.james.mime4j.field.address.parser.ParseException;

final class MimeDescriptorStructure
implements FetchResponse.Structure {
    private final MimeDescriptor descriptor;
    private final List<String> parameters;
    private final List<FetchResponse.Structure> parts;
    private final String disposition;
    private final Map<String, String> dispositionParams;
    private final String location;
    private final String md5;
    private final List<String> languages;
    private final FetchResponse.Structure embeddedMessageStructure;
    private final FetchResponse.Envelope envelope;

    public MimeDescriptorStructure(boolean allowExtensions, MimeDescriptor descriptor, EnvelopeBuilder builder) throws MailboxException, ParseException {
        this.descriptor = descriptor;
        this.parameters = MimeDescriptorStructure.createParameters(descriptor);
        this.parts = MimeDescriptorStructure.createParts(allowExtensions, descriptor, builder);
        this.languages = descriptor.getLanguages();
        this.dispositionParams = descriptor.getDispositionParams();
        this.disposition = descriptor.getDisposition();
        this.md5 = descriptor.getContentMD5();
        this.location = descriptor.getContentLocation();
        MimeDescriptor embeddedMessage = descriptor.embeddedMessage();
        if (embeddedMessage == null) {
            this.embeddedMessageStructure = null;
            this.envelope = null;
        } else {
            this.embeddedMessageStructure = new MimeDescriptorStructure(allowExtensions, embeddedMessage, builder);
            this.envelope = builder.buildEnvelope((Headers)embeddedMessage);
        }
    }

    private static List<FetchResponse.Structure> createParts(boolean allowExtensions, MimeDescriptor descriptor, EnvelopeBuilder builder) throws MailboxException, ParseException {
        ArrayList<FetchResponse.Structure> results = new ArrayList<FetchResponse.Structure>();
        Iterator it = descriptor.parts();
        while (it.hasNext()) {
            MimeDescriptor partDescriptor = (MimeDescriptor)it.next();
            results.add(new MimeDescriptorStructure(allowExtensions, partDescriptor, builder));
        }
        return results;
    }

    private static List<String> createParameters(MimeDescriptor descriptor) throws MailboxException {
        ArrayList<String> results = new ArrayList<String>();
        for (Map.Entry entry : descriptor.contentTypeParameters().entrySet()) {
            results.add((String)entry.getKey());
            results.add((String)entry.getValue());
        }
        return results;
    }

    public String getDescription() {
        return this.descriptor.getContentDescription();
    }

    public String getEncoding() {
        return this.descriptor.getTransferContentEncoding();
    }

    public String getId() {
        return this.descriptor.getContentID();
    }

    public long getLines() {
        return this.descriptor.getLines();
    }

    public String getMediaType() {
        return this.descriptor.getMimeType();
    }

    public long getOctets() {
        return this.descriptor.getBodyOctets();
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getSubType() {
        return this.descriptor.getMimeSubType();
    }

    public Iterator<FetchResponse.Structure> parts() {
        return this.parts.iterator();
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMD5() {
        return this.md5;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public FetchResponse.Structure getBody() {
        return this.embeddedMessageStructure;
    }

    public Map<String, String> getDispositionParams() {
        return this.dispositionParams;
    }

    public FetchResponse.Envelope getEnvelope() {
        return this.envelope;
    }
}

