/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.message.request.ListRequest;
import org.apache.james.imap.message.request.XListRequest;
import org.apache.james.imap.message.response.XListResponse;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.ListProcessor;
import org.apache.james.mailbox.MailboxManager;

public class XListProcessor
extends ListProcessor
implements CapabilityImplementingProcessor {
    private MailboxTyper mailboxTyper;

    public XListProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MailboxTyper mailboxTyper) {
        super(next, mailboxManager, factory);
        this.mailboxTyper = mailboxTyper;
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        if (this.mailboxTyper == null) {
            return Collections.emptyList();
        }
        return Arrays.asList("XLIST");
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message instanceof XListRequest;
    }

    @Override
    protected void doProcess(ListRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        XListRequest request = (XListRequest)message;
        String baseReferenceName = request.getBaseReferenceName();
        String mailboxPatternString = request.getMailboxPattern();
        this.doProcess(baseReferenceName, mailboxPatternString, session, tag, command, responder, this.mailboxTyper);
    }

    @Override
    protected ImapResponseMessage createResponse(boolean noInferior, boolean noSelect, boolean marked, boolean unmarked, boolean hasChildren, boolean hasNoChildren, String mailboxName, char delimiter, MailboxType type) {
        return new XListResponse(noInferior, noSelect, marked, unmarked, hasChildren, hasNoChildren, mailboxName, delimiter, type);
    }
}

