/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.SubscribeRequest;
import org.apache.james.imap.processor.AbstractSubscriptionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionException;
import org.apache.james.mailbox.SubscriptionManager;

public class SubscribeProcessor
extends AbstractSubscriptionProcessor<SubscribeRequest> {
    public SubscribeProcessor(ImapProcessor next, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory) {
        super(SubscribeRequest.class, next, mailboxManager, subscriptionManager, factory);
    }

    @Override
    protected void doProcessRequest(SubscribeRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
        try {
            this.getSubscriptionManager().subscribe(mailboxSession, mailboxName);
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(command, tag, responder);
        }
        catch (SubscriptionException e) {
            session.getLog().debug("Subscribe failed", (Throwable)e);
            this.unsolicitedResponses(session, responder, false);
            this.no(command, tag, responder, HumanReadableText.GENERIC_SUBSCRIPTION_FAILURE);
        }
    }
}

