/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.StartTLSRequest;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.base.AbstractChainedProcessor;

public class StartTLSProcessor
extends AbstractChainedProcessor<StartTLSRequest>
implements CapabilityImplementingProcessor {
    private StatusResponseFactory factory;

    public StartTLSProcessor(ImapProcessor next, StatusResponseFactory factory) {
        super(StartTLSRequest.class, next);
        this.factory = factory;
    }

    @Override
    protected void doProcess(StartTLSRequest request, ImapProcessor.Responder responder, ImapSession session) {
        if (session.supportStartTLS()) {
            responder.respond((ImapResponseMessage)this.factory.taggedOk(request.getTag(), request.getCommand(), HumanReadableText.STARTTLS));
            session.startTLS();
        } else {
            responder.respond((ImapResponseMessage)this.factory.taggedBad(request.getTag(), request.getCommand(), HumanReadableText.UNKNOWN_COMMAND));
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        if (session.supportStartTLS()) {
            return Arrays.asList("STARTTLS");
        }
        return new ArrayList<String>();
    }
}

