/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.CharsetUtil;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.CapabilityRequest;
import org.apache.james.imap.message.response.CapabilityResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;

public class CapabilityProcessor
extends AbstractMailboxProcessor<CapabilityRequest>
implements CapabilityImplementingProcessor {
    private final List<CapabilityImplementingProcessor> capabilities = new ArrayList<CapabilityImplementingProcessor>();

    public CapabilityProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, List<CapabilityImplementingProcessor> capabilities) {
        this(next, mailboxManager, factory);
        this.capabilities.addAll(capabilities);
    }

    public CapabilityProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(CapabilityRequest.class, next, mailboxManager, factory);
        this.capabilities.add(this);
    }

    @Override
    protected void doProcess(CapabilityRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        ImapResponseMessage result = this.doProcess(request, session, tag, command);
        responder.respond(result);
        this.unsolicitedResponses(session, responder, false);
        this.okComplete(command, tag, responder);
    }

    private ImapResponseMessage doProcess(CapabilityRequest request, ImapSession session, String tag, ImapCommand command) {
        ArrayList<String> caps = new ArrayList<String>();
        for (int i = 0; i < this.capabilities.size(); ++i) {
            caps.addAll(this.capabilities.get(i).getImplementedCapabilities(session));
        }
        CapabilityResponse result = new CapabilityResponse(caps);
        return result;
    }

    public void addProcessor(CapabilityImplementingProcessor implementor) {
        this.capabilities.add(implementor);
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        ArrayList<String> capabilities = new ArrayList<String>();
        capabilities.add("IMAP4rev1");
        capabilities.add("LITERAL+");
        capabilities.add("CHILDREN");
        if (CharsetUtil.getAvailableCharsetNames().contains("UTF-8")) {
            capabilities.add("I18NLEVEL=1");
        }
        return capabilities;
    }
}

