/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;

public abstract class AbstractSubscriptionProcessor<M extends ImapRequest>
extends AbstractMailboxProcessor<M> {
    private final SubscriptionManager subscriptionManager;

    public AbstractSubscriptionProcessor(Class<M> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory) {
        super(acceptableClass, next, mailboxManager, factory);
        this.subscriptionManager = subscriptionManager;
    }

    protected SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    @Override
    protected final void doProcess(M message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxSession mSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
        this.getSubscriptionManager().startProcessingRequest(mSession);
        this.doProcessRequest(message, session, tag, command, responder);
        this.getSubscriptionManager().endProcessingRequest(mSession);
    }

    protected abstract void doProcessRequest(M var1, ImapSession var2, String var3, ImapCommand var4, ImapProcessor.Responder var5);
}

